/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax;

import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.TextMateCapture;

public final class SyntaxNodeDescriptorImpl
implements SyntaxNodeDescriptor {
    @NotNull
    private final List<SyntaxNodeDescriptor> children;
    @Nullable
    private final TextMateCapture[][] captures;
    @Nullable
    private final CharSequence[] stringAttributes;

    public SyntaxNodeDescriptorImpl(@NotNull List<? extends SyntaxNodeDescriptor> children, @Nullable TextMateCapture[][] captures, @Nullable CharSequence[] stringAttributes) {
        Intrinsics.checkNotNullParameter(children, (String)"children");
        this.children = children;
        this.captures = captures;
        this.stringAttributes = stringAttributes;
        if (!(this.stringAttributes == null || this.stringAttributes.length == Constants.StringKey.getEntries().size())) {
            boolean $i$a$-require-SyntaxNodeDescriptorImpl$32 = false;
            String $i$a$-require-SyntaxNodeDescriptorImpl$32 = "stringAttributes must be either null or define all StringKey entries";
            throw new IllegalArgumentException($i$a$-require-SyntaxNodeDescriptorImpl$32.toString());
        }
        if (!(this.captures == null || ((Object[])this.captures).length == Constants.CaptureKey.getEntries().size())) {
            boolean bl = false;
            String string = "captures must be either null or define all CaptureKey entries";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    public List<SyntaxNodeDescriptor> getChildren() {
        return this.children;
    }

    @Override
    @Nullable
    public CharSequence getStringAttribute(@NotNull Constants.StringKey key) {
        Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
        return this.stringAttributes != null ? (CharSequence)ArraysKt.getOrNull((Object[])this.stringAttributes, (int)key.ordinal()) : null;
    }

    @Override
    @Nullable
    public TextMateCapture[] getCaptureRules(@NotNull Constants.CaptureKey key) {
        Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
        return this.captures != null ? (TextMateCapture[])ArraysKt.getOrNull((Object[])((Object[])this.captures), (int)key.ordinal()) : null;
    }

    @Override
    public boolean hasBackReference(@NotNull Constants.StringKey key) {
        Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
        return true;
    }

    @Override
    public boolean hasBackReference(@NotNull Constants.CaptureKey key, int group) {
        Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
        return true;
    }

    @NotNull
    public String toString() {
        CharSequence name2;
        CharSequence charSequence = name2 = this.getStringAttribute(Constants.StringKey.NAME);
        return charSequence != null ? "Syntax rule: " + charSequence : super.toString();
    }
}

