/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax;

import java.util.Map;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.language.syntax.RawLanguageDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxIncludeRawNode;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeReferenceDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxRawNode;
import org.jetbrains.plugins.textmate.language.syntax.TextMateSyntaxTableCore;

final class SyntaxIncludeRawNode
implements SyntaxRawNode {
    private final int ruleId;
    @NotNull
    private final SyntaxRawNode parent;
    @NotNull
    private final String include;

    public SyntaxIncludeRawNode(int ruleId, @NotNull SyntaxRawNode parent, @NotNull String include) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)include, (String)"include");
        this.ruleId = ruleId;
        this.parent = parent;
        this.include = include;
    }

    @Override
    public int getRuleId() {
        return this.ruleId;
    }

    @Override
    @NotNull
    public SyntaxRawNode getParent() {
        return this.parent;
    }

    @Override
    @Nullable
    public SyntaxRawNode findInRepository(@NotNull String scopeName, @NotNull Map<CharSequence, RawLanguageDescriptor> topLevelRules) {
        Intrinsics.checkNotNullParameter((Object)scopeName, (String)"scopeName");
        Intrinsics.checkNotNullParameter(topLevelRules, (String)"topLevelRules");
        SyntaxRawNode syntaxRawNode = this.resolveInclude(topLevelRules);
        return syntaxRawNode != null ? syntaxRawNode.findInRepository(scopeName, topLevelRules) : null;
    }

    @Override
    @Nullable
    public SyntaxNodeDescriptor compile(@NotNull Map<CharSequence, RawLanguageDescriptor> topLevelNodes, @NotNull Map<Integer, SyntaxNodeDescriptor> compiledNodes, @NotNull Map<Integer, Integer> ruleIdToReferenceRuleId, @NotNull TextMateSyntaxTableCore syntaxTable) {
        SyntaxNodeDescriptor syntaxNodeDescriptor;
        SyntaxRawNode resolvedNode;
        Intrinsics.checkNotNullParameter(topLevelNodes, (String)"topLevelNodes");
        Intrinsics.checkNotNullParameter(compiledNodes, (String)"compiledNodes");
        Intrinsics.checkNotNullParameter(ruleIdToReferenceRuleId, (String)"ruleIdToReferenceRuleId");
        Intrinsics.checkNotNullParameter((Object)syntaxTable, (String)"syntaxTable");
        SyntaxRawNode syntaxRawNode = resolvedNode = this.resolveInclude(topLevelNodes);
        if (syntaxRawNode != null) {
            SyntaxRawNode resolvedNode2 = syntaxRawNode;
            boolean bl = false;
            SyntaxNodeDescriptor compiledNode = compiledNodes.get(resolvedNode2.getRuleId());
            Integer referenceRuleId = ruleIdToReferenceRuleId.get(resolvedNode2.getRuleId());
            if (compiledNode != null) {
                syntaxNodeDescriptor = compiledNode;
            } else if (referenceRuleId != null) {
                syntaxNodeDescriptor = new SyntaxNodeReferenceDescriptor(referenceRuleId, syntaxTable);
            } else {
                int referenceRuleId2 = ruleIdToReferenceRuleId.size();
                ruleIdToReferenceRuleId.put(resolvedNode2.getRuleId(), referenceRuleId2);
                syntaxNodeDescriptor = new SyntaxNodeReferenceDescriptor(referenceRuleId2, syntaxTable);
            }
        } else {
            syntaxNodeDescriptor = null;
        }
        return syntaxNodeDescriptor;
    }

    private final SyntaxRawNode resolveInclude(Map<CharSequence, RawLanguageDescriptor> topLevelNodes) {
        SyntaxRawNode syntaxRawNode;
        if (StringsKt.startsWith$default((CharSequence)this.include, (char)'#', (boolean)false, (int)2, null)) {
            SyntaxRawNode syntaxRawNode2 = this.getParent();
            String string = this.include.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            syntaxRawNode = syntaxRawNode2.findInRepository(string, topLevelNodes);
        } else if (StringsKt.equals((String)"$self", (String)this.include, (boolean)true) || StringsKt.equals((String)"$base", (String)this.include, (boolean)true)) {
            syntaxRawNode = (SyntaxRawNode)SequencesKt.last((Sequence)SequencesKt.generateSequence((Object)this.getParent(), (Function1)((Function1)resolveInclude.1.INSTANCE)));
        } else {
            String scopeName;
            String topLevelScope;
            int i2 = StringsKt.indexOf$default((CharSequence)this.include, (char)'#', (int)0, (boolean)false, (int)6, null);
            String string = topLevelScope = i2 >= 0 ? StringsKt.take((String)this.include, (int)i2) : this.include;
            if (i2 >= 0) {
                String string2 = this.include.substring(i2 + 1);
                v5 = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                v5 = scopeName = "";
            }
            if (((CharSequence)scopeName).length() > 0) {
                Object object = topLevelNodes.get(topLevelScope);
                syntaxRawNode = object != null && (object = ((RawLanguageDescriptor)object).getRootSyntaxRawNode()) != null ? object.findInRepository(scopeName, topLevelNodes) : null;
            } else {
                RawLanguageDescriptor rawLanguageDescriptor = topLevelNodes.get(topLevelScope);
                syntaxRawNode = rawLanguageDescriptor != null ? rawLanguageDescriptor.getRootSyntaxRawNode() : null;
            }
        }
        return syntaxRawNode;
    }
}

