/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language;

import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.language.syntax.InjectionNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptor;

public final class TextMateLanguageDescriptor {
    @NotNull
    private final SyntaxNodeDescriptor rootSyntaxNode;
    @NotNull
    private final List<InjectionNodeDescriptor> injections;
    @Nullable
    private final CharSequence rootScopeName;

    public TextMateLanguageDescriptor(@NotNull SyntaxNodeDescriptor rootSyntaxNode, @NotNull List<InjectionNodeDescriptor> injections) {
        Intrinsics.checkNotNullParameter((Object)rootSyntaxNode, (String)"rootSyntaxNode");
        Intrinsics.checkNotNullParameter(injections, (String)"injections");
        this.rootSyntaxNode = rootSyntaxNode;
        this.injections = injections;
        this.rootScopeName = this.rootSyntaxNode.getStringAttribute(Constants.StringKey.SCOPE_NAME);
    }

    @NotNull
    public final SyntaxNodeDescriptor getRootSyntaxNode() {
        return this.rootSyntaxNode;
    }

    @NotNull
    public final List<InjectionNodeDescriptor> getInjections() {
        return this.injections;
    }

    @Nullable
    public final CharSequence getRootScopeName() {
        return this.rootScopeName;
    }
}

