/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.bundles;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.bundles.BundleReaderCoreKt;
import org.jetbrains.plugins.textmate.bundles.TextMateBundleReader;
import org.jetbrains.plugins.textmate.bundles.TextMateFileNameMatcher;
import org.jetbrains.plugins.textmate.bundles.TextMateGrammar;
import org.jetbrains.plugins.textmate.bundles.TextMateResourceReader;
import org.jetbrains.plugins.textmate.bundles.VSCodeExtension;
import org.jetbrains.plugins.textmate.bundles.VSCodeExtensionGrammar;
import org.jetbrains.plugins.textmate.bundles.VSCodeExtensionLanguage;
import org.jetbrains.plugins.textmate.plist.Plist;
import org.jetbrains.plugins.textmate.plist.PlistReaderCore;

@SourceDebugExtension(value={"SMAP\nVSCBundleReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VSCBundleReader.kt\norg/jetbrains/plugins/textmate/bundles/VSCBundleReader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,330:1\n1208#2,2:331\n1236#2,4:333\n1617#2,9:337\n1869#2:346\n1870#2:349\n1626#2:350\n1563#2:351\n1634#2,2:352\n1636#2:361\n1563#2:362\n1634#2,3:363\n1563#2:366\n1634#2,3:367\n1563#2:370\n1634#2,3:371\n1617#2,9:374\n1869#2:383\n1870#2:385\n1626#2:386\n1#3:347\n1#3:348\n1#3:384\n382#4,7:354\n*S KotlinDebug\n*F\n+ 1 VSCBundleReader.kt\norg/jetbrains/plugins/textmate/bundles/VSCBundleReader\n*L\n33#1:331,2\n33#1:333,4\n37#1:337,9\n37#1:346\n37#1:349\n37#1:350\n42#1:351\n42#1:352,2\n42#1:361\n58#1:362\n58#1:363,3\n59#1:366\n59#1:367,3\n60#1:370\n60#1:371,3\n91#1:374,9\n91#1:383\n91#1:385\n91#1:386\n37#1:348\n91#1:384\n44#1:354,7\n*E\n"})
final class VSCBundleReader
implements TextMateBundleReader {
    @NotNull
    private final VSCodeExtension extension;
    @NotNull
    private final PlistReaderCore plistReader;
    @NotNull
    private final TextMateResourceReader resourceReader;
    @NotNull
    private final String bundleName;
    @NotNull
    private final Lazy languages$delegate;
    @NotNull
    private final Lazy languageToScope$delegate;
    @NotNull
    private final Lazy embeddedLanguages$delegate;

    public VSCBundleReader(@NotNull VSCodeExtension extension2, @NotNull PlistReaderCore plistReader, @NotNull TextMateResourceReader resourceReader) {
        Intrinsics.checkNotNullParameter((Object)extension2, (String)"extension");
        Intrinsics.checkNotNullParameter((Object)plistReader, (String)"plistReader");
        Intrinsics.checkNotNullParameter((Object)resourceReader, (String)"resourceReader");
        this.extension = extension2;
        this.plistReader = plistReader;
        this.resourceReader = resourceReader;
        this.bundleName = this.extension.getName();
        this.languages$delegate = LazyKt.lazy(() -> VSCBundleReader.languages_delegate$lambda$0(this));
        this.languageToScope$delegate = LazyKt.lazy(() -> VSCBundleReader.languageToScope_delegate$lambda$0(this));
        this.embeddedLanguages$delegate = LazyKt.lazy(() -> VSCBundleReader.embeddedLanguages_delegate$lambda$0(this));
    }

    private final Map<String, VSCodeExtensionLanguage> getLanguages() {
        Lazy lazy = this.languages$delegate;
        return (Map)lazy.getValue();
    }

    @Override
    @NotNull
    public Sequence<TextMateGrammar> readGrammars() {
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.extension.getContributes().getGrammars()), arg_0 -> VSCBundleReader.readGrammars$lambda$0(this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static final Map languages_delegate$lambda$0(VSCBundleReader this$0) {
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = this$0.extension.getContributes().getLanguages();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void language;
            VSCodeExtensionLanguage vSCodeExtensionLanguage = (VSCodeExtensionLanguage)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(language.getId(), element$iv$iv);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map languageToScope_delegate$lambda$0(VSCBundleReader this$0) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this$0.extension.getContributes().getGrammars();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            VSCodeExtensionGrammar grammar = (VSCodeExtensionGrammar)element$iv$iv;
            boolean bl2 = false;
            if (grammar.getLanguage() != null) {
                String it;
                boolean bl3 = false;
                pair = TuplesKt.to((Object)it, (Object)grammar.getScopeName());
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private static final HashMap embeddedLanguages_delegate$lambda$0(VSCBundleReader this$0) {
        void $this$mapTo$iv$iv;
        HashMap map2 = new HashMap();
        Iterable $this$map$iv = this$0.extension.getContributes().getGrammars();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void grammar;
            VSCodeExtensionGrammar vSCodeExtensionGrammar = (VSCodeExtensionGrammar)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            for (Map.Entry<String, String> entry : grammar.getEmbeddedLanguages().entrySet()) {
                Object object;
                void $this$getOrPut$iv;
                String scopeName = entry.getKey();
                String languageId = entry.getValue();
                Map map3 = map2;
                String key$iv = languageId;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl2 = false;
                    Set answer$iv = new HashSet();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((Set)object).add(scopeName);
            }
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        return map2;
    }

    /*
     * WARNING - void declaration
     */
    private static final TextMateGrammar readGrammars$lambda$0(VSCBundleReader this$0, VSCodeExtensionGrammar grammar) {
        Object object;
        Object object2;
        VSCodeExtensionLanguage language;
        Lazy plist;
        block6: {
            block5: {
                String fileName;
                Collection collection;
                String extension2;
                Collection collection2;
                Iterable $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)grammar, (String)"grammar");
                plist = LazyKt.lazy(() -> VSCBundleReader.readGrammars$lambda$0$0(this$0, grammar));
                language = this$0.getLanguages().get(grammar.getLanguage());
                object2 = language;
                if (object2 == null) break block5;
                VSCodeExtensionLanguage it = object2;
                boolean bl = false;
                Iterable $this$map$iv = it.getExtensions();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String string = (String)item$iv$iv;
                    collection2 = destination$iv$iv;
                    boolean bl2 = false;
                    collection2.add(new TextMateFileNameMatcher.Extension(StringsKt.removePrefix((String)extension2, (CharSequence)".")));
                }
                $this$map$iv = it.getFilenames();
                collection2 = (List)destination$iv$iv;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    extension2 = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(new TextMateFileNameMatcher.Name(fileName));
                }
                $this$map$iv = it.getFilenamePatterns();
                collection2 = CollectionsKt.plus((Collection)collection2, (Iterable)((List)destination$iv$iv));
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void pattern;
                    fileName = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl4 = false;
                    collection.add(new TextMateFileNameMatcher.Pattern((String)pattern));
                }
                List list2 = CollectionsKt.plus((Collection)collection2, (Iterable)((List)destination$iv$iv));
                object2 = list2;
                if (list2 != null) break block6;
            }
            object2 = CollectionsKt.emptyList();
        }
        Object fileNameMatchers = object2;
        VSCodeExtensionLanguage vSCodeExtensionLanguage = language;
        return new TextMateGrammar((Collection)fileNameMatchers, vSCodeExtensionLanguage != null ? vSCodeExtensionLanguage.getFirstLine() : null, (Lazy<Plist>)plist, (object = language) != null && (object = ((VSCodeExtensionLanguage)object).getAliases()) != null ? (String)CollectionsKt.firstOrNull((List)object) : null, grammar.getScopeName());
    }

    private static final Plist readGrammars$lambda$0$0(VSCBundleReader this$0, VSCodeExtensionGrammar $grammar) {
        Object object;
        block3: {
            block2: {
                object = this$0.resourceReader.read($grammar.getPath());
                if (object == null) break block2;
                byte[] it = object;
                boolean bl = false;
                Plist plist = BundleReaderCoreKt.readPlist(it, this$0.plistReader, $grammar.getPath());
                object = plist;
                if (plist != null) break block3;
            }
            object = Plist.Companion.getEMPTY_PLIST();
        }
        return object;
    }
}

