/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.patronus.client.model;

import java.util.List;
import java.util.UUID;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.patronus.client.model.TeamCityBuild;
import org.jetbrains.patronus.client.model.TeamCityCheckAttemptStatus;
import org.jetbrains.patronus.client.model.TeamCityFailedTest;

public final class TeamCityCheckAttemptDetails {
    @NotNull
    private final UUID id;
    private final int number;
    @NotNull
    private final String buildId;
    @NotNull
    private final String buildUrl;
    @NotNull
    private final Instant startedAt;
    @Nullable
    private final Instant finishedAt;
    @NotNull
    private final TeamCityCheckAttemptStatus status;
    @Nullable
    private final Integer failedTestsNumber;
    @Nullable
    private final Integer failedBuildsNumber;
    @Nullable
    private final Integer failedToStartBuildsNumber;
    @NotNull
    private final List<TeamCityFailedTest> failedTests;
    @NotNull
    private final List<TeamCityBuild> builds;
    @Nullable
    private final String cancellationIgnoreReason;

    public TeamCityCheckAttemptDetails(@NotNull UUID id, int number, @NotNull String buildId, @NotNull String buildUrl, @NotNull Instant startedAt, @Nullable Instant finishedAt, @NotNull TeamCityCheckAttemptStatus status2, @Nullable Integer failedTestsNumber, @Nullable Integer failedBuildsNumber, @Nullable Integer failedToStartBuildsNumber, @NotNull List<TeamCityFailedTest> failedTests, @NotNull List<TeamCityBuild> builds, @Nullable String cancellationIgnoreReason) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
        Intrinsics.checkNotNullParameter((Object)buildUrl, (String)"buildUrl");
        Intrinsics.checkNotNullParameter((Object)startedAt, (String)"startedAt");
        Intrinsics.checkNotNullParameter((Object)((Object)status2), (String)"status");
        Intrinsics.checkNotNullParameter(failedTests, (String)"failedTests");
        Intrinsics.checkNotNullParameter(builds, (String)"builds");
        this.id = id;
        this.number = number;
        this.buildId = buildId;
        this.buildUrl = buildUrl;
        this.startedAt = startedAt;
        this.finishedAt = finishedAt;
        this.status = status2;
        this.failedTestsNumber = failedTestsNumber;
        this.failedBuildsNumber = failedBuildsNumber;
        this.failedToStartBuildsNumber = failedToStartBuildsNumber;
        this.failedTests = failedTests;
        this.builds = builds;
        this.cancellationIgnoreReason = cancellationIgnoreReason;
    }

    @NotNull
    public final UUID getId() {
        return this.id;
    }

    public final int getNumber() {
        return this.number;
    }

    @NotNull
    public final String getBuildId() {
        return this.buildId;
    }

    @NotNull
    public final String getBuildUrl() {
        return this.buildUrl;
    }

    @NotNull
    public final Instant getStartedAt() {
        return this.startedAt;
    }

    @Nullable
    public final Instant getFinishedAt() {
        return this.finishedAt;
    }

    @NotNull
    public final TeamCityCheckAttemptStatus getStatus() {
        return this.status;
    }

    @Nullable
    public final Integer getFailedTestsNumber() {
        return this.failedTestsNumber;
    }

    @Nullable
    public final Integer getFailedBuildsNumber() {
        return this.failedBuildsNumber;
    }

    @Nullable
    public final Integer getFailedToStartBuildsNumber() {
        return this.failedToStartBuildsNumber;
    }

    @NotNull
    public final List<TeamCityFailedTest> getFailedTests() {
        return this.failedTests;
    }

    @Nullable
    public final String getCancellationIgnoreReason() {
        return this.cancellationIgnoreReason;
    }

    @NotNull
    public String toString() {
        return "TeamCityCheckAttemptDetails(id=" + this.id + ", number=" + this.number + ", buildId=" + this.buildId + ", buildUrl=" + this.buildUrl + ", startedAt=" + this.startedAt + ", finishedAt=" + this.finishedAt + ", status=" + this.status + ", failedTestsNumber=" + this.failedTestsNumber + ", failedBuildsNumber=" + this.failedBuildsNumber + ", failedToStartBuildsNumber=" + this.failedToStartBuildsNumber + ", failedTests=" + this.failedTests + ", builds=" + this.builds + ", cancellationIgnoreReason=" + this.cancellationIgnoreReason + ")";
    }

    public int hashCode() {
        int result2 = this.id.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.number);
        result2 = result2 * 31 + this.buildId.hashCode();
        result2 = result2 * 31 + this.buildUrl.hashCode();
        result2 = result2 * 31 + this.startedAt.hashCode();
        result2 = result2 * 31 + (this.finishedAt == null ? 0 : this.finishedAt.hashCode());
        result2 = result2 * 31 + this.status.hashCode();
        result2 = result2 * 31 + (this.failedTestsNumber == null ? 0 : ((Object)this.failedTestsNumber).hashCode());
        result2 = result2 * 31 + (this.failedBuildsNumber == null ? 0 : ((Object)this.failedBuildsNumber).hashCode());
        result2 = result2 * 31 + (this.failedToStartBuildsNumber == null ? 0 : ((Object)this.failedToStartBuildsNumber).hashCode());
        result2 = result2 * 31 + ((Object)this.failedTests).hashCode();
        result2 = result2 * 31 + ((Object)this.builds).hashCode();
        result2 = result2 * 31 + (this.cancellationIgnoreReason == null ? 0 : this.cancellationIgnoreReason.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TeamCityCheckAttemptDetails)) {
            return false;
        }
        TeamCityCheckAttemptDetails teamCityCheckAttemptDetails = (TeamCityCheckAttemptDetails)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)teamCityCheckAttemptDetails.id)) {
            return false;
        }
        if (this.number != teamCityCheckAttemptDetails.number) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.buildId, (Object)teamCityCheckAttemptDetails.buildId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.buildUrl, (Object)teamCityCheckAttemptDetails.buildUrl)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.startedAt, (Object)teamCityCheckAttemptDetails.startedAt)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.finishedAt, (Object)teamCityCheckAttemptDetails.finishedAt)) {
            return false;
        }
        if (this.status != teamCityCheckAttemptDetails.status) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.failedTestsNumber, (Object)teamCityCheckAttemptDetails.failedTestsNumber)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.failedBuildsNumber, (Object)teamCityCheckAttemptDetails.failedBuildsNumber)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.failedToStartBuildsNumber, (Object)teamCityCheckAttemptDetails.failedToStartBuildsNumber)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.failedTests, teamCityCheckAttemptDetails.failedTests)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.builds, teamCityCheckAttemptDetails.builds)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.cancellationIgnoreReason, (Object)teamCityCheckAttemptDetails.cancellationIgnoreReason);
    }
}

