/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.patronus.client.model;

import java.util.List;
import java.util.UUID;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.patronus.client.model.TeamCityCheck;

public final class RobotChecks {
    @NotNull
    private final UUID robotId;
    @NotNull
    private final List<TeamCityCheck> teamCity;

    public RobotChecks(@NotNull UUID robotId, @NotNull List<TeamCityCheck> teamCity) {
        Intrinsics.checkNotNullParameter((Object)robotId, (String)"robotId");
        Intrinsics.checkNotNullParameter(teamCity, (String)"teamCity");
        this.robotId = robotId;
        this.teamCity = teamCity;
    }

    @NotNull
    public final List<TeamCityCheck> getTeamCity() {
        return this.teamCity;
    }

    @NotNull
    public String toString() {
        return "RobotChecks(robotId=" + this.robotId + ", teamCity=" + this.teamCity + ")";
    }

    public int hashCode() {
        int result2 = this.robotId.hashCode();
        result2 = result2 * 31 + ((Object)this.teamCity).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RobotChecks)) {
            return false;
        }
        RobotChecks robotChecks = (RobotChecks)other;
        if (!Intrinsics.areEqual((Object)this.robotId, (Object)robotChecks.robotId)) {
            return false;
        }
        return Intrinsics.areEqual(this.teamCity, robotChecks.teamCity);
    }
}

