/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.patronus.client.model;

import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.patronus.client.model.GitCommit;
import org.jetbrains.patronus.client.model.RobotChangesSpaceLink;
import org.jetbrains.patronus.client.model.RobotChangesType;

public final class RobotChanges {
    @NotNull
    private final RobotChangesType type;
    private final int commitsNumber;
    @NotNull
    private final List<GitCommit> topCommits;
    @NotNull
    private final List<RobotChangesSpaceLink> spaceLinks;

    public RobotChanges(@NotNull RobotChangesType type2, int commitsNumber, @NotNull List<GitCommit> topCommits, @NotNull List<RobotChangesSpaceLink> spaceLinks) {
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        Intrinsics.checkNotNullParameter(topCommits, (String)"topCommits");
        Intrinsics.checkNotNullParameter(spaceLinks, (String)"spaceLinks");
        this.type = type2;
        this.commitsNumber = commitsNumber;
        this.topCommits = topCommits;
        this.spaceLinks = spaceLinks;
    }

    public final int getCommitsNumber() {
        return this.commitsNumber;
    }

    @NotNull
    public String toString() {
        return "RobotChanges(type=" + this.type + ", commitsNumber=" + this.commitsNumber + ", topCommits=" + this.topCommits + ", spaceLinks=" + this.spaceLinks + ")";
    }

    public int hashCode() {
        int result2 = this.type.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.commitsNumber);
        result2 = result2 * 31 + ((Object)this.topCommits).hashCode();
        result2 = result2 * 31 + ((Object)this.spaceLinks).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RobotChanges)) {
            return false;
        }
        RobotChanges robotChanges = (RobotChanges)other;
        if (this.type != robotChanges.type) {
            return false;
        }
        if (this.commitsNumber != robotChanges.commitsNumber) {
            return false;
        }
        if (!Intrinsics.areEqual(this.topCommits, robotChanges.topCommits)) {
            return false;
        }
        return Intrinsics.areEqual(this.spaceLinks, robotChanges.spaceLinks);
    }
}

