/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.nativecerts.win32;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.Crypt32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WTypes;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinCrypt;
import com.sun.jna.ptr.PointerByReference;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.nativecerts.NativeTrustedRootsInternalUtils;
import org.jetbrains.nativecerts.win32.Crypt32Ext;

public class Crypt32ExtUtil {
    private static final Logger LOGGER = Logger.getLogger(Crypt32ExtUtil.class.getName());
    private static final Map<String, Integer> customTrustedCertificatesLocations = Map.of("CERT_SYSTEM_STORE_LOCAL_MACHINE", 131072, "CERT_SYSTEM_STORE_LOCAL_MACHINE_GROUP_POLICY", 524288, "CERT_SYSTEM_STORE_LOCAL_MACHINE_ENTERPRISE", 589824, "CERT_SYSTEM_STORE_CURRENT_USER", 65536, "CERT_SYSTEM_STORE_CURRENT_USER_GROUP_POLICY", 458752);

    public static Collection<X509Certificate> getCustomTrustedRootCertificates() {
        HashSet<X509Certificate> result2 = new HashSet<X509Certificate>();
        for (Map.Entry<String, Integer> entry : customTrustedCertificatesLocations.entrySet()) {
            List<X509Certificate> root = Crypt32ExtUtil.gatherEnterpriseCertsForLocation(entry.getValue(), "ROOT");
            List<X509Certificate> intermediates = Crypt32ExtUtil.gatherEnterpriseCertsForLocation(entry.getValue(), "CA");
            if (LOGGER.isLoggable(Level.FINE)) {
                StringBuilder message2 = new StringBuilder();
                message2.append("Received ").append(root.size()).append(" certificates from store ROOT / ").append(entry.getKey());
                for (X509Certificate certificate2 : root) {
                    message2.append("\n  ROOT/").append(entry.getKey()).append(": ").append(certificate2.getSubjectX500Principal());
                }
                message2.append("\nReceived ").append(intermediates.size()).append(" certificates from store CA (Intermediates) / ").append(entry.getKey());
                for (X509Certificate certificate2 : intermediates) {
                    message2.append("\n  CA/").append(entry.getKey()).append(": ").append(certificate2.getSubjectX500Principal());
                }
                LOGGER.fine(message2.toString());
            }
            result2.addAll(root);
            for (X509Certificate intermediate : intermediates) {
                try {
                    Crypt32ExtUtil.validateCertificate(intermediate.getEncoded());
                    result2.add(intermediate);
                }
                catch (Throwable t2) {
                    LOGGER.log(Level.FINE, "Unable to validate whether certificate '" + String.valueOf(intermediate.getSubjectX500Principal()) + "' is trusted: " + t2.getMessage(), t2);
                }
            }
        }
        return result2;
    }

    public static void CertCloseStore(WinCrypt.HCERTSTORE handle2) {
        if (!Crypt32.INSTANCE.CertCloseStore(handle2, 0)) {
            throw new IllegalStateException("CertCloseStore: " + Kernel32Util.formatMessage((int)Native.getLastError()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<X509Certificate> gatherEnterpriseCertsForLocation(int location2, String store_name) {
        int flags = location2 | 0x4000 | 0x8000;
        WinCrypt.HCERTSTORE hcertstore = Crypt32Ext.INSTANCE.CertOpenStore(new WTypes.LPSTR(new Pointer(13L)), 0, new WinCrypt.HCRYPTPROV_LEGACY(0L), flags, new WTypes.LPWSTR(store_name));
        if (hcertstore == null) {
            int errorCode = Native.getLastError();
            if (errorCode == 18 || errorCode == 2) {
                return Collections.emptyList();
            }
            throw new Win32Exception(errorCode);
        }
        try {
            ArrayList<X509Certificate> result2 = new ArrayList<X509Certificate>();
            WinCrypt.CERT_CONTEXT.ByReference prev = null;
            while (true) {
                WinCrypt.CERT_CONTEXT.ByReference certificate2;
                if ((certificate2 = Crypt32.INSTANCE.CertEnumCertificatesInStore(hcertstore, prev == null ? null : prev.getPointer())) == null) {
                    int errorCode = Native.getLastError();
                    if (errorCode == -2146885628 || errorCode == 18) break;
                    throw new Win32Exception(errorCode);
                }
                byte[] bytes2 = certificate2.pbCertEncoded.getByteArray(0L, certificate2.cbCertEncoded);
                try {
                    X509Certificate x509 = NativeTrustedRootsInternalUtils.parseCertificate(bytes2);
                    result2.add(x509);
                }
                catch (Throwable parsingException) {
                    LOGGER.warning(NativeTrustedRootsInternalUtils.renderExceptionMessage("Unable to parse one of the certificatesfrom store '" + store_name + "'", parsingException));
                }
                prev = certificate2;
            }
            ArrayList<X509Certificate> arrayList = result2;
            return arrayList;
        }
        finally {
            Crypt32ExtUtil.CertCloseStore(hcertstore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validateCertificate(byte[] encodedCertificate) {
        WinCrypt.CERT_CONTEXT certificateContext = Crypt32Ext.INSTANCE.CertCreateCertificateContext(65537, encodedCertificate, encodedCertificate.length);
        if (certificateContext == null) {
            throw new Win32Exception(Native.getLastError());
        }
        try {
            WinCrypt.CERT_CHAIN_PARA pChainPara = new WinCrypt.CERT_CHAIN_PARA();
            pChainPara.cbSize = pChainPara.size();
            pChainPara.RequestedUsage.dwType = 0;
            pChainPara.RequestedUsage.Usage.cUsageIdentifier = 0;
            pChainPara.RequestedUsage.Usage.rgpszUsageIdentifier = null;
            PointerByReference ppChainContext = new PointerByReference();
            if (!Crypt32.INSTANCE.CertGetCertificateChain(null, certificateContext, null, null, pChainPara, Integer.MIN_VALUE, null, ppChainContext)) {
                throw new Win32Exception(Native.getLastError());
            }
            if (ppChainContext.getValue() == null) {
                throw new IllegalStateException("CertGetCertificateChain was successful, but returned chain context is null");
            }
            WinCrypt.CERT_CHAIN_CONTEXT pChainContext = (WinCrypt.CERT_CHAIN_CONTEXT)Structure.newInstance(WinCrypt.CERT_CHAIN_CONTEXT.class, (Pointer)ppChainContext.getValue());
            pChainContext.read();
            if (pChainContext.cbSize != pChainContext.size()) {
                throw new IllegalStateException("CertGetCertificateChain was successful, but returned chain context size is incorrect.returned cbSize is " + pChainContext.cbSize + ", but the structure size is " + pChainContext.size());
            }
            try {
                WinCrypt.CERT_CHAIN_POLICY_PARA chainPolicyPara = new WinCrypt.CERT_CHAIN_POLICY_PARA();
                chainPolicyPara.cbSize = chainPolicyPara.size();
                chainPolicyPara.dwFlags = 0;
                WinCrypt.CERT_CHAIN_POLICY_STATUS policyStatus = new WinCrypt.CERT_CHAIN_POLICY_STATUS();
                policyStatus.dwError = 1;
                policyStatus.cbSize = policyStatus.size();
                if (!Crypt32.INSTANCE.CertVerifyCertificateChainPolicy(new WTypes.LPSTR(Pointer.createConstant((int)4)), pChainContext, chainPolicyPara, policyStatus)) {
                    throw new Win32Exception(Native.getLastError());
                }
                int dwError = policyStatus.dwError;
                if (dwError != 0) {
                    throw new Win32Exception(dwError, null, "CertVerifyCertificateChainPolicy failed to validate certificate with code " + Integer.toHexString(dwError) + ":\n" + Kernel32Util.formatMessage((int)dwError)){};
                }
            }
            finally {
                Crypt32.INSTANCE.CertFreeCertificateChain(pChainContext);
            }
        }
        finally {
            Crypt32.INSTANCE.CertFreeCertificateContext(certificateContext);
        }
    }
}

