/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.sequentialparsers.impl;

import java.util.Collection;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.sequentialparsers.LocalParsingResult;
import org.intellij.markdown.parser.sequentialparsers.RangesListBuilder;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParserUtil;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LinkParserUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final LocalParsingResult parseLinkDestination(@NotNull TokensCache.Iterator iterator2) {
            Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
            TokensCache.Iterator it = iterator2;
            if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.EOL) || Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.RPAREN)) {
                return null;
            }
            int startIndex = it.getIndex();
            boolean withBraces = Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.LT);
            if (withBraces) {
                it = it.advance();
            }
            boolean hasOpenedParentheses = false;
            while (!(it.getType() == null || withBraces && Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.GT))) {
                if (!withBraces) {
                    if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.LPAREN)) {
                        if (hasOpenedParentheses) break;
                        hasOpenedParentheses = true;
                    }
                    IElementType next2 = it.rawLookup(1);
                    if (SequentialParserUtil.Companion.isWhitespace(it, 1) || next2 == null) break;
                    if (Intrinsics.areEqual((Object)next2, (Object)MarkdownTokenTypes.RPAREN)) {
                        if (!hasOpenedParentheses) break;
                        hasOpenedParentheses = false;
                    }
                }
                it = it.advance();
            }
            if (it.getType() != null && !hasOpenedParentheses) {
                return new LocalParsingResult(it, CollectionsKt.listOf((Object)new SequentialParser.Node(new IntRange(startIndex, it.getIndex() + 1), MarkdownElementTypes.LINK_DESTINATION)));
            }
            return null;
        }

        @Nullable
        public final LocalParsingResult parseLinkLabel(@NotNull TokensCache.Iterator iterator2) {
            Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
            TokensCache.Iterator it = iterator2;
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.LBRACKET)) {
                return null;
            }
            int startIndex = it.getIndex();
            RangesListBuilder delegate = new RangesListBuilder();
            it = it.advance();
            while (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.RBRACKET) && it.getType() != null) {
                delegate.put(it.getIndex());
                if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.LBRACKET)) break;
                it = it.advance();
            }
            if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.RBRACKET)) {
                int endIndex = it.getIndex();
                if (endIndex == startIndex + 1) {
                    return null;
                }
                return new LocalParsingResult(it, (Collection<SequentialParser.Node>)CollectionsKt.listOf((Object)new SequentialParser.Node(new IntRange(startIndex, endIndex + 1), MarkdownElementTypes.LINK_LABEL)), delegate.get());
            }
            return null;
        }

        @Nullable
        public final LocalParsingResult parseLinkText(@NotNull TokensCache.Iterator iterator2) {
            Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
            TokensCache.Iterator it = iterator2;
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.LBRACKET)) {
                return null;
            }
            int startIndex = it.getIndex();
            RangesListBuilder delegate = new RangesListBuilder();
            int bracketDepth = 1;
            it = it.advance();
            while (!(it.getType() == null || Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.RBRACKET) && --bracketDepth == 0)) {
                delegate.put(it.getIndex());
                if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.LBRACKET)) {
                    ++bracketDepth;
                }
                it = it.advance();
            }
            if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.RBRACKET)) {
                return new LocalParsingResult(it, (Collection<SequentialParser.Node>)CollectionsKt.listOf((Object)new SequentialParser.Node(new IntRange(startIndex, it.getIndex() + 1), MarkdownElementTypes.LINK_TEXT)), delegate.get());
            }
            return null;
        }

        @Nullable
        public final LocalParsingResult parseLinkTitle(@NotNull TokensCache.Iterator iterator2) {
            Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
            TokensCache.Iterator it = iterator2;
            if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.EOL)) {
                return null;
            }
            int startIndex = it.getIndex();
            IElementType closingType = null;
            if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.SINGLE_QUOTE) || Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.DOUBLE_QUOTE)) {
                closingType = it.getType();
            } else if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.LPAREN)) {
                closingType = MarkdownTokenTypes.RPAREN;
            } else {
                return null;
            }
            it = it.advance();
            while (it.getType() != null && !Intrinsics.areEqual((Object)it.getType(), (Object)closingType)) {
                it = it.advance();
            }
            if (it.getType() != null) {
                return new LocalParsingResult(it, CollectionsKt.listOf((Object)new SequentialParser.Node(new IntRange(startIndex, it.getIndex() + 1), MarkdownElementTypes.LINK_TITLE)));
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

