/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.sequentialparsers;

import java.util.ArrayList;
import java.util.List;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.lexer.MarkdownLexer;
import org.intellij.markdown.lexer.TokenInfo;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LexerBasedTokensCache
extends TokensCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<TokenInfo> cachedTokens;
    @NotNull
    private final List<TokenInfo> filteredTokens;
    @NotNull
    private final CharSequence originalText;
    @NotNull
    private final IntRange originalTextRange;

    public LexerBasedTokensCache(@NotNull MarkdownLexer lexer) {
        Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
        Companion.ResultOfCaching resultOfCaching = LexerBasedTokensCache.Companion.cacheTokens(lexer);
        List<TokenInfo> _cachedTokens = resultOfCaching.component1();
        List<TokenInfo> _filteredTokens = resultOfCaching.component2();
        this.cachedTokens = _cachedTokens;
        this.filteredTokens = _filteredTokens;
        this.originalText = lexer.getOriginalText();
        this.originalTextRange = RangesKt.until((int)lexer.getBufferStart(), (int)lexer.getBufferEnd());
        this.verify();
    }

    @Override
    @NotNull
    public List<TokenInfo> getCachedTokens() {
        return this.cachedTokens;
    }

    @Override
    @NotNull
    public List<TokenInfo> getFilteredTokens() {
        return this.filteredTokens;
    }

    @Override
    @NotNull
    public CharSequence getOriginalText() {
        return this.originalText;
    }

    @Override
    @NotNull
    public IntRange getOriginalTextRange() {
        return this.originalTextRange;
    }

    public static final class Companion {
        private Companion() {
        }

        private final boolean isWhitespace(IElementType elementType) {
            return Intrinsics.areEqual((Object)elementType, (Object)MarkdownTokenTypes.WHITE_SPACE);
        }

        private final ResultOfCaching cacheTokens(MarkdownLexer lexer) {
            ArrayList<TokenInfo> cachedTokens = new ArrayList<TokenInfo>();
            ArrayList<TokenInfo> filteredTokens = new ArrayList<TokenInfo>();
            while (lexer.getType() != null) {
                boolean isWhitespace = this.isWhitespace(lexer.getType());
                TokenInfo info = new TokenInfo(lexer.getType(), lexer.getTokenStart(), lexer.getTokenEnd(), cachedTokens.size(), isWhitespace ? -1 : filteredTokens.size());
                cachedTokens.add(info);
                if (!isWhitespace) {
                    filteredTokens.add(info);
                }
                lexer.advance();
            }
            return new ResultOfCaching((List<TokenInfo>)cachedTokens, (List<TokenInfo>)filteredTokens);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final class ResultOfCaching {
            @NotNull
            private final List<TokenInfo> cachedTokens;
            @NotNull
            private final List<TokenInfo> filteredTokens;

            public ResultOfCaching(@NotNull List<TokenInfo> cachedTokens, @NotNull List<TokenInfo> filteredTokens) {
                Intrinsics.checkNotNullParameter(cachedTokens, (String)"cachedTokens");
                Intrinsics.checkNotNullParameter(filteredTokens, (String)"filteredTokens");
                this.cachedTokens = cachedTokens;
                this.filteredTokens = filteredTokens;
            }

            @NotNull
            public final List<TokenInfo> component1() {
                return this.cachedTokens;
            }

            @NotNull
            public final List<TokenInfo> component2() {
                return this.filteredTokens;
            }

            @NotNull
            public String toString() {
                return "ResultOfCaching(cachedTokens=" + this.cachedTokens + ", filteredTokens=" + this.filteredTokens + ')';
            }

            public int hashCode() {
                int result2 = ((Object)this.cachedTokens).hashCode();
                result2 = result2 * 31 + ((Object)this.filteredTokens).hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ResultOfCaching)) {
                    return false;
                }
                ResultOfCaching resultOfCaching = (ResultOfCaching)other;
                if (!Intrinsics.areEqual(this.cachedTokens, resultOfCaching.cachedTokens)) {
                    return false;
                }
                return Intrinsics.areEqual(this.filteredTokens, resultOfCaching.filteredTokens);
            }
        }
    }
}

