/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.providers;

import java.util.ArrayList;
import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockImpl;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.ListItemMarkerBlock;
import org.intellij.markdown.parser.markerblocks.impl.ListMarkerBlock;
import org.jetbrains.annotations.NotNull;

public final class ListMarkerProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    @Override
    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkNotNullParameter((Object)stateInfo, (String)"stateInfo");
        MarkdownConstraints currentConstraints = stateInfo.getCurrentConstraints();
        MarkdownConstraints nextConstraints = stateInfo.getNextConstraints();
        if (!MarkerBlockProvider.Companion.isStartOfLineWithConstraints(pos, currentConstraints)) {
            return CollectionsKt.emptyList();
        }
        if (!Intrinsics.areEqual((Object)nextConstraints, (Object)currentConstraints)) {
            Character c = ArraysKt.lastOrNull((char[])nextConstraints.getTypes());
            char c2 = '>';
            if ((c == null || c.charValue() != c2) && Intrinsics.areEqual((Object)this.getLastExplicit(nextConstraints), (Object)true)) {
                ArrayList<MarkerBlockImpl> result2 = new ArrayList<MarkerBlockImpl>();
                if (!(stateInfo.getLastBlock() instanceof ListMarkerBlock)) {
                    ProductionHolder.Marker marker = productionHolder.mark();
                    Character c3 = ArraysKt.lastOrNull((char[])nextConstraints.getTypes());
                    Intrinsics.checkNotNull((Object)c3);
                    result2.add(new ListMarkerBlock(nextConstraints, marker, c3.charValue()));
                }
                result2.add(new ListItemMarkerBlock(nextConstraints, productionHolder.mark()));
                return result2;
            }
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        return false;
    }

    private final Boolean getLastExplicit(MarkdownConstraints $this$getLastExplicit) {
        return ArraysKt.lastOrNull((boolean[])$this$getLastExplicit.isExplicit());
    }
}

