/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.providers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.CharsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.LinkReferenceDefinitionMarkerBlock;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LinkReferenceDefinitionProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkNotNullParameter((Object)stateInfo, (String)"stateInfo");
        if (!MarkerBlockProvider.Companion.isStartOfLineWithConstraints(pos, stateInfo.getCurrentConstraints())) {
            return CollectionsKt.emptyList();
        }
        List<IntRange> list2 = Companion.matchLinkDefinition(pos.getOriginalText(), pos.getOffset());
        if (list2 == null) {
            return CollectionsKt.emptyList();
        }
        List<IntRange> matchResult = list2;
        Iterator iterator2 = ((Iterable)matchResult).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            IElementType iElementType;
            int i2 = n++;
            IntRange range = (IntRange)iterator2.next();
            IntRange intRange = Companion.addToRangeAndWiden(range, 0);
            switch (i2) {
                case 0: {
                    iElementType = MarkdownElementTypes.LINK_LABEL;
                    break;
                }
                case 1: {
                    iElementType = MarkdownElementTypes.LINK_DESTINATION;
                    break;
                }
                case 2: {
                    iElementType = MarkdownElementTypes.LINK_TITLE;
                    break;
                }
                default: {
                    throw new AssertionError((Object)"There are no more than three groups in this regex");
                }
            }
            productionHolder.addProduction(CollectionsKt.listOf((Object)new SequentialParser.Node(intRange, iElementType)));
        }
        int matchLength = ((IntRange)CollectionsKt.last(matchResult)).getLast() - pos.getOffset() + 1;
        LookaheadText.Position endPosition = pos.nextPosition(matchLength);
        if (endPosition != null && !Companion.isEndOfLine(endPosition)) {
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.listOf((Object)new LinkReferenceDefinitionMarkerBlock(stateInfo.getCurrentConstraints(), productionHolder.mark(), pos.getOffset() + matchLength));
    }

    @Override
    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        return false;
    }

    @SourceDebugExtension(value={"SMAP\nLinkReferenceDefinitionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinkReferenceDefinitionProvider.kt\norg/intellij/markdown/parser/markerblocks/providers/LinkReferenceDefinitionProvider$Companion\n*L\n1#1,223:1\n218#1:224\n220#1:225\n218#1:226\n220#1:227\n218#1:228\n220#1:229\n218#1:230\n220#1:231\n218#1:232\n218#1:233\n220#1:234\n218#1:235\n218#1:236\n218#1:237\n218#1:238\n*S KotlinDebug\n*F\n+ 1 LinkReferenceDefinitionProvider.kt\norg/intellij/markdown/parser/markerblocks/providers/LinkReferenceDefinitionProvider$Companion\n*L\n78#1:224\n99#1:225\n99#1:226\n101#1:227\n101#1:228\n112#1:229\n112#1:230\n126#1:231\n126#1:232\n162#1:233\n166#1:234\n166#1:235\n208#1:236\n212#1:237\n220#1:238\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IntRange addToRangeAndWiden(@NotNull IntRange range, int t2) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            return new IntRange(range.getFirst() + t2, range.getLast() + t2 + 1);
        }

        public final boolean isEndOfLine(@NotNull LookaheadText.Position pos) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            return pos.getOffsetInCurrentLine() == -1 || pos.charsToNonWhitespace() == null;
        }

        @Nullable
        public final List<IntRange> matchLinkDefinition(@NotNull CharSequence text2, int startOffset) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            int offset = MarkerBlockProvider.Companion.passSmallIndent(text2, startOffset);
            IntRange intRange = this.matchLinkLabel(text2, offset);
            if (intRange == null) {
                return null;
            }
            IntRange linkLabel = intRange;
            offset = linkLabel.getLast() + 1;
            if (offset >= text2.length() || text2.charAt(offset) != ':') {
                return null;
            }
            ++offset;
            offset = this.passOneNewline(text2, offset);
            IntRange intRange2 = this.matchLinkDestination(text2, offset);
            if (intRange2 == null) {
                return null;
            }
            IntRange destination = intRange2;
            offset = destination.getLast() + 1;
            offset = this.passOneNewline(text2, offset);
            IntRange title2 = this.matchLinkTitle(text2, offset);
            ArrayList<IntRange> result2 = new ArrayList<IntRange>();
            result2.add(linkLabel);
            result2.add(destination);
            if (title2 != null) {
                for (offset = title2.getLast() + 1; offset < text2.length(); ++offset) {
                    Companion companion = this;
                    char c$iv = text2.charAt(offset);
                    boolean $i$f$isSpace = false;
                    if (!(c$iv == ' ' || c$iv == '\t')) break;
                }
                if (offset >= text2.length() || text2.charAt(offset) == '\n') {
                    result2.add(title2);
                }
            }
            return result2;
        }

        @Nullable
        public final IntRange matchLinkDestination(@NotNull CharSequence text2, int start2) {
            int offset;
            block16: {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                if (start2 >= text2.length()) {
                    return null;
                }
                offset = start2;
                if (text2.charAt(offset) != '<') break block16;
                ++offset;
                while (offset < text2.length()) {
                    Companion this_$iv;
                    char c;
                    block18: {
                        block17: {
                            c = text2.charAt(offset);
                            if (c == '>') {
                                return new IntRange(start2, offset);
                            }
                            if (c == '<' || c == '>') break block17;
                            this_$iv = this;
                            boolean $i$f$isSpaceOrNewline = false;
                            Companion this_$iv$iv = this_$iv;
                            boolean $i$f$isSpace = false;
                            if (!(c == ' ' || c == '\t' || c == '\n')) break block18;
                        }
                        return null;
                    }
                    if (c == '\\' && offset + 1 < text2.length()) {
                        this_$iv = this;
                        char c$iv = text2.charAt(offset + 1);
                        boolean $i$f$isSpaceOrNewline = false;
                        Companion this_$iv$iv = this_$iv;
                        boolean $i$f$isSpace = false;
                        if (!(c$iv == ' ' || c$iv == '\t' || c$iv == '\n')) {
                            ++offset;
                        }
                    }
                    ++offset;
                }
                return null;
            }
            boolean hasParens = false;
            while (offset < text2.length()) {
                char c = text2.charAt(offset);
                Companion this_$iv = this;
                boolean $i$f$isSpaceOrNewline = false;
                Companion this_$iv$iv = this_$iv;
                boolean $i$f$isSpace = false;
                if (c == ' ' || c == '\t' || c == '\n' || c <= '\u001b') break;
                if (c == '(') {
                    if (hasParens) break;
                    hasParens = true;
                } else if (c == ')') {
                    if (!hasParens) break;
                    hasParens = false;
                } else if (c == '\\' && offset + 1 < text2.length()) {
                    this_$iv = this;
                    char c$iv = text2.charAt(offset + 1);
                    boolean $i$f$isSpaceOrNewline2 = false;
                    Companion this_$iv$iv2 = this_$iv;
                    boolean $i$f$isSpace2 = false;
                    if (!(c$iv == ' ' || c$iv == '\t' || c$iv == '\n')) {
                        ++offset;
                    }
                }
                ++offset;
            }
            if (start2 == offset) {
                return null;
            }
            return new IntRange(start2, offset - 1);
        }

        @Nullable
        public final IntRange matchLinkTitle(@NotNull CharSequence text2, int start2) {
            char c;
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            if (start2 >= text2.length()) {
                return null;
            }
            char c2 = text2.charAt(start2);
            if (c2 == '\'') {
                c = '\'';
            } else if (c2 == '\"') {
                c = '\"';
            } else if (c2 == '(') {
                c = ')';
            } else {
                return null;
            }
            char endDelim = c;
            boolean isBlank = false;
            for (int offset = start2 + 1; offset < text2.length(); ++offset) {
                Companion this_$iv;
                char c3 = text2.charAt(offset);
                if (c3 == endDelim) {
                    return new IntRange(start2, offset);
                }
                if (c3 == '\n') {
                    if (isBlank) {
                        return null;
                    }
                    isBlank = true;
                } else {
                    this_$iv = this;
                    boolean $i$f$isSpace = false;
                    if (!(c3 == ' ' || c3 == '\t')) {
                        isBlank = false;
                    }
                }
                if (c3 != '\\' || offset + 1 >= text2.length()) continue;
                this_$iv = this;
                char c$iv = text2.charAt(offset + 1);
                boolean $i$f$isSpaceOrNewline = false;
                Companion this_$iv$iv = this_$iv;
                boolean $i$f$isSpace = false;
                if (c$iv == ' ' || c$iv == '\t' || c$iv == '\n') continue;
                ++offset;
            }
            return null;
        }

        @Nullable
        public final IntRange matchLinkLabel(@NotNull CharSequence text2, int start2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            int offset = start2;
            if (offset >= text2.length() || text2.charAt(offset) != '[') {
                return null;
            }
            ++offset;
            boolean seenNonWhitespace = false;
            for (int i2 = 1; i2 < 1000; ++i2) {
                if (offset >= text2.length()) {
                    return null;
                }
                char c = text2.charAt(offset);
                if (c == '[' || c == ']') break;
                if (c == '\\') {
                    if (++offset >= text2.length()) {
                        return null;
                    }
                    c = text2.charAt(offset);
                }
                if (!CharsKt.isWhitespace((char)c)) {
                    seenNonWhitespace = true;
                }
                ++offset;
            }
            if (!seenNonWhitespace || offset >= text2.length() || text2.charAt(offset) != ']') {
                return null;
            }
            return new IntRange(start2, offset);
        }

        private final int passOneNewline(CharSequence text2, int start2) {
            boolean $i$f$isSpace;
            char c$iv;
            int offset;
            for (offset = start2; offset < text2.length(); ++offset) {
                Companion companion = this;
                c$iv = text2.charAt(offset);
                $i$f$isSpace = false;
                if (!(c$iv == ' ' || c$iv == '\t')) break;
            }
            if (offset < text2.length() && text2.charAt(offset) == '\n') {
                ++offset;
                while (offset < text2.length()) {
                    Companion this_$iv = this;
                    c$iv = text2.charAt(offset);
                    $i$f$isSpace = false;
                    if (!(c$iv == ' ' || c$iv == '\t')) break;
                    ++offset;
                }
            }
            return offset;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

