/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.providers;

import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.CharsKt;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.AtxHeaderMarkerBlock;
import org.jetbrains.annotations.NotNull;

public final class AtxHeaderProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    @Override
    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkNotNullParameter((Object)stateInfo, (String)"stateInfo");
        IntRange headerRange = this.matches(pos);
        if (headerRange != null) {
            return CollectionsKt.listOf((Object)new AtxHeaderMarkerBlock(stateInfo.getCurrentConstraints(), productionHolder, headerRange, this.calcTailStartPos(pos, headerRange.getLast()), pos.getNextLineOrEofOffset()));
        }
        return CollectionsKt.emptyList();
    }

    private final int calcTailStartPos(LookaheadText.Position pos, int headerSize) {
        int offset;
        CharSequence line = pos.getCurrentLineFromPosition();
        for (offset = line.length() - 1; offset > headerSize && CharsKt.isWhitespace((char)line.charAt(offset)); --offset) {
        }
        while (offset > headerSize && line.charAt(offset) == '#' && line.charAt(offset - 1) != '\\') {
            --offset;
        }
        if (offset + 1 < line.length() && CharsKt.isWhitespace((char)line.charAt(offset)) && line.charAt(offset + 1) == '#') {
            return pos.getOffset() + offset + 1;
        }
        return pos.getOffset() + line.length();
    }

    @Override
    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        return this.matches(pos) != null;
    }

    private final IntRange matches(LookaheadText.Position pos) {
        if (pos.getOffsetInCurrentLine() != -1) {
            Object[] objectArray;
            CharSequence text2 = pos.getCurrentLineFromPosition();
            int offset = 0;
            offset = MarkerBlockProvider.Companion.passSmallIndent$default(MarkerBlockProvider.Companion, text2, 0, 2, null);
            if (offset >= text2.length() || text2.charAt(offset) != '#') {
                return null;
            }
            int start2 = offset;
            int n = 6;
            for (int j = 0; j < n; ++j) {
                int it = j;
                boolean bl = false;
                if (offset >= text2.length() || text2.charAt(offset) != '#') continue;
                ++offset;
            }
            if (offset < text2.length() && !CollectionsKt.listOf((Object[])(objectArray = new Character[]{Character.valueOf(' '), Character.valueOf('\t')})).contains(Character.valueOf(text2.charAt(offset)))) {
                return null;
            }
            return new IntRange(start2, offset - 1);
        }
        return null;
    }
}

