/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.impl;

import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockImpl;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.jetbrains.annotations.NotNull;

public final class SetextHeaderMarkerBlock
extends MarkerBlockImpl {
    @NotNull
    private final ProductionHolder productionHolder;
    @NotNull
    private final ProductionHolder.Marker contentMarker;
    @NotNull
    private IElementType nodeType;

    public SetextHeaderMarkerBlock(@NotNull MarkdownConstraints myConstraints, @NotNull ProductionHolder productionHolder) {
        Intrinsics.checkNotNullParameter((Object)myConstraints, (String)"myConstraints");
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        super(myConstraints, productionHolder.mark());
        this.productionHolder = productionHolder;
        this.contentMarker = this.productionHolder.mark();
        this.nodeType = MarkdownElementTypes.SETEXT_1;
    }

    @Override
    public boolean allowsSubBlocks() {
        return false;
    }

    @Override
    public boolean isInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return pos.getOffsetInCurrentLine() == -1;
    }

    @Override
    protected int calcNextInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return pos.getNextLineOrEofOffset();
    }

    @Override
    @NotNull
    public IElementType getDefaultNodeType() {
        return this.nodeType;
    }

    @Override
    @NotNull
    protected MarkerBlock.ClosingAction getDefaultAction() {
        return MarkerBlock.ClosingAction.DONE;
    }

    @Override
    @NotNull
    protected MarkerBlock.ProcessingResult doProcessToken(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints currentConstraints) {
        LookaheadText.Position setextMarkerStart;
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)currentConstraints, (String)"currentConstraints");
        if (pos.getOffsetInCurrentLine() != -1) {
            return MarkerBlock.ProcessingResult.Companion.getCANCEL();
        }
        Integer n = pos.charsToNonWhitespace();
        if (n == null) {
            return new MarkerBlock.ProcessingResult(MarkerBlock.ClosingAction.DROP, MarkerBlock.ClosingAction.DROP, MarkerBlock.EventAction.PROPAGATE);
        }
        int startSpaces = n;
        LookaheadText.Position position = setextMarkerStart = pos.nextPosition(startSpaces);
        boolean bl = position != null ? position.getChar() == '-' : false;
        if (bl) {
            this.nodeType = MarkdownElementTypes.SETEXT_2;
        }
        LookaheadText.Position position2 = setextMarkerStart;
        int setextMarkerStartOffset = position2 != null ? position2.getOffset() : pos.getOffset();
        IElementType markerNodeType = Intrinsics.areEqual((Object)this.nodeType, (Object)MarkdownElementTypes.SETEXT_2) ? MarkdownTokenTypes.SETEXT_2 : MarkdownTokenTypes.SETEXT_1;
        this.contentMarker.done(MarkdownTokenTypes.SETEXT_CONTENT);
        this.productionHolder.addProduction(CollectionsKt.listOf((Object)new SequentialParser.Node(new IntRange(setextMarkerStartOffset, pos.getNextLineOrEofOffset()), markerNodeType)));
        this.scheduleProcessingResult(pos.getNextLineOrEofOffset(), MarkerBlock.ProcessingResult.Companion.getDEFAULT());
        return MarkerBlock.ProcessingResult.Companion.getCANCEL();
    }
}

