/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.impl;

import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockImpl;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.jetbrains.annotations.NotNull;

public final class AtxHeaderMarkerBlock
extends MarkerBlockImpl {
    @NotNull
    private final IElementType nodeType;

    public AtxHeaderMarkerBlock(@NotNull MarkdownConstraints myConstraints, @NotNull ProductionHolder productionHolder, @NotNull IntRange headerRange, int tailStartPos, int endOfLinePos) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)myConstraints, (String)"myConstraints");
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkNotNullParameter((Object)headerRange, (String)"headerRange");
        super(myConstraints, productionHolder.mark());
        int curPos = productionHolder.getCurrentPosition();
        List $this$_init__u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$_init__u24lambda_u240.add(new SequentialParser.Node(new IntRange(curPos + headerRange.getFirst(), curPos + headerRange.getLast() + 1), MarkdownTokenTypes.ATX_HEADER));
        if (curPos + headerRange.getLast() + 1 != tailStartPos) {
            $this$_init__u24lambda_u240.add(new SequentialParser.Node(new IntRange(curPos + headerRange.getLast() + 1, tailStartPos), MarkdownTokenTypes.ATX_CONTENT));
        }
        if (tailStartPos != endOfLinePos) {
            $this$_init__u24lambda_u240.add(new SequentialParser.Node(new IntRange(tailStartPos, endOfLinePos), MarkdownTokenTypes.ATX_HEADER));
        }
        List nodes = CollectionsKt.build((List)list2);
        productionHolder.addProduction(nodes);
        this.nodeType = this.calcNodeType(headerRange.getLast() - headerRange.getFirst() + 1);
    }

    @Override
    public boolean allowsSubBlocks() {
        return false;
    }

    @Override
    public boolean isInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return true;
    }

    private final IElementType calcNodeType(int headerSize) {
        switch (headerSize) {
            case 1: {
                return MarkdownElementTypes.ATX_1;
            }
            case 2: {
                return MarkdownElementTypes.ATX_2;
            }
            case 3: {
                return MarkdownElementTypes.ATX_3;
            }
            case 4: {
                return MarkdownElementTypes.ATX_4;
            }
            case 5: {
                return MarkdownElementTypes.ATX_5;
            }
            case 6: {
                return MarkdownElementTypes.ATX_6;
            }
        }
        return MarkdownElementTypes.ATX_6;
    }

    @Override
    @NotNull
    public IElementType getDefaultNodeType() {
        return this.nodeType;
    }

    @Override
    @NotNull
    protected MarkerBlock.ClosingAction getDefaultAction() {
        return MarkerBlock.ClosingAction.DONE;
    }

    @Override
    protected int calcNextInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return pos.getNextLineOrEofOffset();
    }

    @Override
    @NotNull
    protected MarkerBlock.ProcessingResult doProcessToken(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints currentConstraints) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)currentConstraints, (String)"currentConstraints");
        if (pos.getOffsetInCurrentLine() == -1) {
            return new MarkerBlock.ProcessingResult(MarkerBlock.ClosingAction.DROP, MarkerBlock.ClosingAction.DONE, MarkerBlock.EventAction.PROPAGATE);
        }
        return MarkerBlock.ProcessingResult.Companion.getCANCEL();
    }
}

