/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks;

import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.jetbrains.annotations.NotNull;

public interface MarkerBlock {
    public int getNextInterestingOffset(@NotNull LookaheadText.Position var1);

    public boolean isInterestingOffset(@NotNull LookaheadText.Position var1);

    public boolean allowsSubBlocks();

    @NotNull
    public ProcessingResult processToken(@NotNull LookaheadText.Position var1, @NotNull MarkdownConstraints var2);

    @NotNull
    public MarkdownConstraints getBlockConstraints();

    public boolean acceptAction(@NotNull ClosingAction var1);

    public static final abstract class ClosingAction
    extends Enum<ClosingAction> {
        public static final /* enum */ ClosingAction DONE = new DONE("DONE", 0);
        public static final /* enum */ ClosingAction DROP = new DROP("DROP", 1);
        public static final /* enum */ ClosingAction DEFAULT = new DEFAULT("DEFAULT", 2);
        public static final /* enum */ ClosingAction NOTHING = new NOTHING("NOTHING", 3);
        private static final /* synthetic */ ClosingAction[] $VALUES;

        private ClosingAction() {
        }

        public abstract void doAction(@NotNull ProductionHolder.Marker var1, @NotNull IElementType var2);

        public /* synthetic */ ClosingAction(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            $VALUES = closingActionArray = new ClosingAction[]{ClosingAction.DONE, ClosingAction.DROP, ClosingAction.DEFAULT, ClosingAction.NOTHING};
        }

        static final class DEFAULT
        extends ClosingAction {
            /*
             * WARNING - void declaration
             */
            DEFAULT() {
                void var1_1;
            }

            @Override
            public void doAction(@NotNull ProductionHolder.Marker marker, @NotNull IElementType type2) {
                Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
                Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                throw new UnsupportedOperationException("Should not be invoked");
            }
        }

        static final class DONE
        extends ClosingAction {
            /*
             * WARNING - void declaration
             */
            DONE() {
                void var1_1;
            }

            @Override
            public void doAction(@NotNull ProductionHolder.Marker marker, @NotNull IElementType type2) {
                Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
                Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                marker.done(type2);
            }
        }

        static final class DROP
        extends ClosingAction {
            /*
             * WARNING - void declaration
             */
            DROP() {
                void var1_1;
            }

            @Override
            public void doAction(@NotNull ProductionHolder.Marker marker, @NotNull IElementType type2) {
                Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
                Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            }
        }

        static final class NOTHING
        extends ClosingAction {
            /*
             * WARNING - void declaration
             */
            NOTHING() {
                void var1_1;
            }

            @Override
            public void doAction(@NotNull ProductionHolder.Marker marker, @NotNull IElementType type2) {
                Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
                Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            }
        }
    }

    public static final class EventAction
    extends Enum<EventAction> {
        public static final /* enum */ EventAction PROPAGATE = new EventAction();
        public static final /* enum */ EventAction CANCEL = new EventAction();
        private static final /* synthetic */ EventAction[] $VALUES;

        static {
            $VALUES = eventActionArray = new EventAction[]{EventAction.PROPAGATE, EventAction.CANCEL};
        }
    }

    public static final class ProcessingResult {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final ClosingAction childrenAction;
        @NotNull
        private final ClosingAction selfAction;
        @NotNull
        private final EventAction eventAction;
        @NotNull
        private static final ProcessingResult PASS = new ProcessingResult(ClosingAction.NOTHING, ClosingAction.NOTHING, EventAction.PROPAGATE);
        @NotNull
        private static final ProcessingResult CANCEL = new ProcessingResult(ClosingAction.NOTHING, ClosingAction.NOTHING, EventAction.CANCEL);
        @NotNull
        private static final ProcessingResult DEFAULT = new ProcessingResult(ClosingAction.DEFAULT, ClosingAction.DONE, EventAction.PROPAGATE);

        public ProcessingResult(@NotNull ClosingAction childrenAction, @NotNull ClosingAction selfAction, @NotNull EventAction eventAction) {
            Intrinsics.checkNotNullParameter((Object)((Object)childrenAction), (String)"childrenAction");
            Intrinsics.checkNotNullParameter((Object)((Object)selfAction), (String)"selfAction");
            Intrinsics.checkNotNullParameter((Object)((Object)eventAction), (String)"eventAction");
            this.childrenAction = childrenAction;
            this.selfAction = selfAction;
            this.eventAction = eventAction;
        }

        @NotNull
        public final ClosingAction getChildrenAction() {
            return this.childrenAction;
        }

        @NotNull
        public final ClosingAction getSelfAction() {
            return this.selfAction;
        }

        @NotNull
        public final EventAction getEventAction() {
            return this.eventAction;
        }

        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ProcessingResult getPASS() {
                return PASS;
            }

            @NotNull
            public final ProcessingResult getCANCEL() {
                return CANCEL;
            }

            @NotNull
            public final ProcessingResult getDEFAULT() {
                return DEFAULT;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

