/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.markdown.MarkdownParsingException;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTNodeBuilder;
import org.intellij.markdown.lexer.Compat;
import org.intellij.markdown.lexer.Stack;
import org.intellij.markdown.parser.CancellationToken;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nTreeBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TreeBuilder.kt\norg/intellij/markdown/parser/TreeBuilder\n+ 2 Compat.kt\norg/intellij/markdown/lexer/Compat\n+ 3 Compat.kt\norg/intellij/markdown/lexer/Compat$assert$1\n*L\n1#1,127:1\n107#2,4:128\n107#2,4:132\n107#2,4:136\n106#2,3:140\n110#2:144\n106#3:143\n*S KotlinDebug\n*F\n+ 1 TreeBuilder.kt\norg/intellij/markdown/parser/TreeBuilder\n*L\n22#1:128,4\n23#1:132,4\n41#1:136,4\n51#1:140,3\n51#1:144\n51#1:143\n*E\n"})
public abstract class TreeBuilder {
    @NotNull
    private final ASTNodeBuilder nodeBuilder;
    @NotNull
    private final CancellationToken cancellationToken;

    public TreeBuilder(@NotNull ASTNodeBuilder nodeBuilder, @NotNull CancellationToken cancellationToken) {
        Intrinsics.checkNotNullParameter((Object)nodeBuilder, (String)"nodeBuilder");
        Intrinsics.checkNotNullParameter((Object)cancellationToken, (String)"cancellationToken");
        this.nodeBuilder = nodeBuilder;
        this.cancellationToken = cancellationToken;
    }

    @NotNull
    protected final ASTNodeBuilder getNodeBuilder() {
        return this.nodeBuilder;
    }

    public TreeBuilder(@NotNull ASTNodeBuilder nodeBuilder) {
        Intrinsics.checkNotNullParameter((Object)nodeBuilder, (String)"nodeBuilder");
        this(nodeBuilder, CancellationToken.NonCancellable.INSTANCE);
    }

    @NotNull
    public final ASTNode buildTree(@NotNull List<SequentialParser.Node> production) {
        boolean condition$iv;
        Intrinsics.checkNotNullParameter(production, (String)"production");
        List<MyEvent> events = this.constructEvents(production);
        Stack<Pair> markersStack = new Stack<Pair>();
        Compat compat = Compat.INSTANCE;
        int n = !((Collection)events).isEmpty() ? 1 : 0;
        boolean $i$f$assert = false;
        if (!condition$iv) {
            boolean bl = false;
            String string = "nonsense";
            throw new MarkdownParsingException(string);
        }
        Compat this_$iv = Compat.INSTANCE;
        condition$iv = Intrinsics.areEqual((Object)((MyEvent)CollectionsKt.first(events)).getInfo(), (Object)((MyEvent)CollectionsKt.last(events)).getInfo());
        $i$f$assert = false;
        if (!condition$iv) {
            boolean bl = false;
            String string = "more than one root?\nfirst: " + ((MyEvent)CollectionsKt.first(events)).getInfo() + "\nlast: " + ((MyEvent)CollectionsKt.last(events)).getInfo();
            throw new MarkdownParsingException(string);
        }
        n = ((Collection)events).size();
        for (int i2 = 0; i2 < n; ++i2) {
            List list2;
            this.cancellationToken.checkCancelled();
            MyEvent event = events.get(i2);
            this.flushEverythingBeforeEvent(event, markersStack.isEmpty() ? null : (List)((Pair)markersStack.peek()).getSecond());
            if (event.isStart()) {
                markersStack.push(new Pair((Object)event, new ArrayList()));
                continue;
            }
            if (event.isEmpty()) {
                list2 = new ArrayList();
            } else {
                Pair eventAndChildren = (Pair)markersStack.pop();
                Compat compat2 = Compat.INSTANCE;
                boolean condition$iv2 = Intrinsics.areEqual((Object)((MyEvent)eventAndChildren.getFirst()).getInfo(), (Object)event.getInfo());
                boolean $i$f$assert2 = false;
                if (!condition$iv2) {
                    boolean bl = false;
                    String string = "Intersecting parsed nodes detected: " + ((MyEvent)eventAndChildren.getFirst()).getInfo() + " vs " + event.getInfo();
                    throw new MarkdownParsingException(string);
                }
                list2 = (List)eventAndChildren.getSecond();
            }
            List currentNodeChildren = list2;
            boolean isTopmostNode = markersStack.isEmpty();
            MyASTNodeWrapper newNode = this.createASTNodeOnClosingEvent(event, currentNodeChildren, isTopmostNode);
            if (isTopmostNode) {
                Compat condition$iv2 = Compat.INSTANCE;
                boolean condition$iv3 = i2 + 1 == events.size();
                boolean $i$f$assert3 = false;
                if (!condition$iv3) {
                    boolean bl = false;
                    String string = "";
                    throw new MarkdownParsingException(string);
                }
                return newNode.getAstNode();
            }
            ((List)((Pair)markersStack.peek()).getSecond()).add(newNode);
        }
        throw new AssertionError((Object)"markers stack should close some time thus would not be here!");
    }

    @NotNull
    protected abstract MyASTNodeWrapper createASTNodeOnClosingEvent(@NotNull MyEvent var1, @NotNull List<MyASTNodeWrapper> var2, boolean var3);

    protected abstract void flushEverythingBeforeEvent(@NotNull MyEvent var1, @Nullable List<MyASTNodeWrapper> var2);

    private final List<MyEvent> constructEvents(List<SequentialParser.Node> production) {
        ArrayList<MyEvent> events = new ArrayList<MyEvent>();
        int n = ((Collection)production).size();
        for (int index = 0; index < n; ++index) {
            this.cancellationToken.checkCancelled();
            SequentialParser.Node result2 = production.get(index);
            int startTokenId = result2.getRange().getFirst();
            int endTokenId = result2.getRange().getLast();
            events.add(new MyEvent(startTokenId, index, result2));
            if (endTokenId == startTokenId) continue;
            events.add(new MyEvent(endTokenId, index, result2));
        }
        CollectionsKt.sort((List)events);
        return events;
    }

    protected static final class MyASTNodeWrapper {
        @NotNull
        private final ASTNode astNode;
        private final int startTokenIndex;
        private final int endTokenIndex;

        public MyASTNodeWrapper(@NotNull ASTNode astNode, int startTokenIndex, int endTokenIndex) {
            Intrinsics.checkNotNullParameter((Object)astNode, (String)"astNode");
            this.astNode = astNode;
            this.startTokenIndex = startTokenIndex;
            this.endTokenIndex = endTokenIndex;
        }

        @NotNull
        public final ASTNode getAstNode() {
            return this.astNode;
        }

        public final int getStartTokenIndex() {
            return this.startTokenIndex;
        }

        public final int getEndTokenIndex() {
            return this.endTokenIndex;
        }
    }

    protected static final class MyEvent
    implements Comparable<MyEvent> {
        private final int position;
        private final int timeClosed;
        @NotNull
        private final SequentialParser.Node info;

        public MyEvent(int position, int timeClosed, @NotNull SequentialParser.Node info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            this.position = position;
            this.timeClosed = timeClosed;
            this.info = info;
        }

        public final int getPosition() {
            return this.position;
        }

        @NotNull
        public final SequentialParser.Node getInfo() {
            return this.info;
        }

        public final boolean isStart() {
            return this.info.getRange().getLast() != this.position;
        }

        public final boolean isEmpty() {
            return this.info.getRange().getFirst() == this.info.getRange().getLast();
        }

        @Override
        public int compareTo(@NotNull MyEvent other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            if (this.position != other.position) {
                return this.position - other.position;
            }
            if (this.isStart() == other.isStart()) {
                int positionDiff = this.info.getRange().getFirst() + this.info.getRange().getLast() - (other.info.getRange().getFirst() + other.info.getRange().getLast());
                if (positionDiff != 0) {
                    if (this.isEmpty() || other.isEmpty()) {
                        return positionDiff;
                    }
                    return -positionDiff;
                }
                int timeDiff = this.timeClosed - other.timeClosed;
                return this.isStart() ? -timeDiff : timeDiff;
            }
            return this.isStart() ? 1 : -1;
        }

        @NotNull
        public String toString() {
            return (this.isStart() ? "Open" : "Close") + ": " + this.position + " (" + this.info + ')';
        }
    }
}

