/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.markdown.MarkdownParsingException;
import org.intellij.markdown.lexer.Compat;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.constraints.MarkdownConstraintsKt;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.ParagraphMarkerBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nMarkerProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkerProcessor.kt\norg/intellij/markdown/parser/MarkerProcessor\n+ 2 Compat.kt\norg/intellij/markdown/lexer/Compat\n+ 3 Compat.kt\norg/intellij/markdown/lexer/Compat$assert$1\n*L\n1#1,200:1\n106#2,3:201\n110#2:205\n107#2,4:206\n106#3:204\n*S KotlinDebug\n*F\n+ 1 MarkerProcessor.kt\norg/intellij/markdown/parser/MarkerProcessor\n*L\n44#1:201,3\n44#1:205\n159#1:206,4\n44#1:204\n*E\n"})
public abstract class MarkerProcessor<T extends StateInfo> {
    @NotNull
    private final ProductionHolder productionHolder;
    @NotNull
    private final MarkdownConstraints startConstraints;
    @NotNull
    private final List<MarkerBlock> NO_BLOCKS;
    @NotNull
    private final List<MarkerBlock> markersStack;
    @NotNull
    private MarkdownConstraints topBlockConstraints;
    private int nextInterestingPosForExistingMarkers;
    @NotNull
    private final Function2<LookaheadText.Position, MarkdownConstraints, Boolean> interruptsParagraph;

    public MarkerProcessor(@NotNull ProductionHolder productionHolder, @NotNull MarkdownConstraints startConstraints) {
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkNotNullParameter((Object)startConstraints, (String)"startConstraints");
        this.productionHolder = productionHolder;
        this.startConstraints = startConstraints;
        this.NO_BLOCKS = CollectionsKt.emptyList();
        this.markersStack = new ArrayList();
        this.topBlockConstraints = this.startConstraints;
        this.nextInterestingPosForExistingMarkers = -1;
        this.interruptsParagraph = (Function2)new Function2<LookaheadText.Position, MarkdownConstraints, Boolean>(this){
            final /* synthetic */ MarkerProcessor<T> this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final Boolean invoke(LookaheadText.Position position, MarkdownConstraints constraints) {
                Intrinsics.checkNotNullParameter((Object)position, (String)"position");
                Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
                boolean result2 = false;
                for (MarkerBlockProvider<T> provider2 : this.this$0.getMarkerBlockProviders()) {
                    if (!provider2.interruptsParagraph(position, constraints)) continue;
                    result2 = true;
                    break;
                }
                return result2;
            }
        };
    }

    @NotNull
    protected final MarkdownConstraints getStartConstraints() {
        return this.startConstraints;
    }

    @NotNull
    protected final List<MarkerBlock> getNO_BLOCKS() {
        return this.NO_BLOCKS;
    }

    @NotNull
    protected final List<MarkerBlock> getMarkersStack() {
        return this.markersStack;
    }

    @NotNull
    protected final MarkdownConstraints getTopBlockConstraints() {
        return this.topBlockConstraints;
    }

    @NotNull
    protected abstract T getStateInfo();

    @NotNull
    protected abstract List<MarkerBlockProvider<T>> getMarkerBlockProviders();

    protected abstract void updateStateInfo(@NotNull LookaheadText.Position var1);

    protected abstract void populateConstraintsTokens(@NotNull LookaheadText.Position var1, @NotNull MarkdownConstraints var2, @NotNull ProductionHolder var3);

    @NotNull
    public List<MarkerBlock> createNewMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        Compat compat = Compat.INSTANCE;
        boolean bl = MarkerBlockProvider.Companion.isStartOfLineWithConstraints(pos, ((StateInfo)this.getStateInfo()).getCurrentConstraints());
        boolean $i$f$assert = false;
        if (!bl) {
            boolean bl2 = false;
            String string = "";
            throw new MarkdownParsingException(string);
        }
        for (MarkerBlockProvider markerBlockProvider : this.getMarkerBlockProviders()) {
            List<MarkerBlock> list2 = markerBlockProvider.createMarkerBlocks(pos, productionHolder, this.getStateInfo());
            if (!(!((Collection)list2).isEmpty())) continue;
            return list2;
        }
        if (pos.getOffsetInCurrentLine() >= MarkdownConstraintsKt.getCharsEaten(((StateInfo)this.getStateInfo()).getNextConstraints(), pos.getCurrentLine()) && pos.charsToNonWhitespace() != null) {
            return CollectionsKt.listOf((Object)new ParagraphMarkerBlock(((StateInfo)this.getStateInfo()).getCurrentConstraints(), productionHolder.mark(), this.interruptsParagraph));
        }
        return CollectionsKt.emptyList();
    }

    @Nullable
    public final LookaheadText.Position processPosition(@NotNull LookaheadText.Position pos) {
        int delta;
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        this.updateStateInfo(pos);
        boolean shouldRecalcNextPos = false;
        if (pos.getOffset() >= this.nextInterestingPosForExistingMarkers) {
            this.processMarkers(pos);
            shouldRecalcNextPos = true;
        }
        if (MarkerBlockProvider.Companion.isStartOfLineWithConstraints(pos, ((StateInfo)this.getStateInfo()).getCurrentConstraints())) {
            MarkerBlock markerBlock = (MarkerBlock)CollectionsKt.lastOrNull(this.markersStack);
            if (!(markerBlock != null ? !markerBlock.allowsSubBlocks() : false)) {
                List<MarkerBlock> newMarkerBlocks = this.createNewMarkerBlocks(pos, this.productionHolder);
                for (MarkerBlock newMarkerBlock : newMarkerBlocks) {
                    this.addNewMarkerBlock(newMarkerBlock);
                    shouldRecalcNextPos = true;
                }
            }
        }
        if (shouldRecalcNextPos) {
            this.nextInterestingPosForExistingMarkers = this.calculateNextPosForExistingMarkers(pos);
        }
        if ((pos.getOffsetInCurrentLine() == -1 || MarkerBlockProvider.Companion.isStartOfLineWithConstraints(pos, ((StateInfo)this.getStateInfo()).getCurrentConstraints())) && (delta = MarkdownConstraintsKt.getCharsEaten(((StateInfo)this.getStateInfo()).getNextConstraints(), pos.getCurrentLine()) - pos.getOffsetInCurrentLine()) > 0) {
            if (pos.getOffsetInCurrentLine() != -1 && ((StateInfo)this.getStateInfo()).getNextConstraints().getIndent() <= this.topBlockConstraints.getIndent()) {
                this.populateConstraintsTokens(pos, ((StateInfo)this.getStateInfo()).getNextConstraints(), this.productionHolder);
            }
            return pos.nextPosition(delta);
        }
        return pos.nextPosition(this.nextInterestingPosForExistingMarkers - pos.getOffset());
    }

    private final int calculateNextPosForExistingMarkers(LookaheadText.Position pos) {
        MarkerBlock markerBlock = (MarkerBlock)CollectionsKt.lastOrNull(this.markersStack);
        int result2 = markerBlock != null ? markerBlock.getNextInterestingOffset(pos) : pos.getNextLineOrEofOffset();
        return result2 == -1 ? Integer.MAX_VALUE : result2;
    }

    public final void addNewMarkerBlock(@NotNull MarkerBlock newMarkerBlock) {
        Intrinsics.checkNotNullParameter((Object)newMarkerBlock, (String)"newMarkerBlock");
        this.markersStack.add(newMarkerBlock);
        this.relaxTopConstraints();
    }

    public final void flushMarkers() {
        this.closeChildren(-1, MarkerBlock.ClosingAction.DEFAULT);
    }

    private final boolean processMarkers(LookaheadText.Position pos) {
        int index = this.markersStack.size();
        while (index > 0) {
            MarkerBlock markerBlock;
            MarkerBlock.ProcessingResult processingResult;
            if (--index >= this.markersStack.size() || Intrinsics.areEqual((Object)(processingResult = (markerBlock = this.markersStack.get(index)).processToken(pos, ((StateInfo)this.getStateInfo()).getCurrentConstraints())), (Object)MarkerBlock.ProcessingResult.Companion.getPASS())) continue;
            this.applyProcessingResult(index, markerBlock, processingResult);
            if (processingResult.getEventAction() != MarkerBlock.EventAction.CANCEL) continue;
            return true;
        }
        return false;
    }

    private final void applyProcessingResult(int index, MarkerBlock markerBlock, MarkerBlock.ProcessingResult processingResult) {
        this.closeChildren(index, processingResult.getChildrenAction());
        if (markerBlock.acceptAction(processingResult.getSelfAction())) {
            this.markersStack.remove(index);
            this.relaxTopConstraints();
        }
    }

    private final void closeChildren(int index, MarkerBlock.ClosingAction childrenAction) {
        if (childrenAction != MarkerBlock.ClosingAction.NOTHING) {
            for (int latterIndex = this.markersStack.size() - 1; latterIndex > index; --latterIndex) {
                boolean result2 = this.markersStack.get(latterIndex).acceptAction(childrenAction);
                Compat this_$iv = Compat.INSTANCE;
                boolean $i$f$assert = false;
                if (!result2) {
                    boolean bl = false;
                    String string = "If closing action is not NOTHING, marker should be gone";
                    throw new MarkdownParsingException(string);
                }
                this.markersStack.remove(latterIndex);
            }
            this.relaxTopConstraints();
        }
    }

    private final void relaxTopConstraints() {
        this.topBlockConstraints = this.markersStack.isEmpty() ? this.startConstraints : ((MarkerBlock)CollectionsKt.last(this.markersStack)).getBlockConstraints();
    }

    @SourceDebugExtension(value={"SMAP\nMarkerProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkerProcessor.kt\norg/intellij/markdown/parser/MarkerProcessor$StateInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,200:1\n295#2,2:201\n*S KotlinDebug\n*F\n+ 1 MarkerProcessor.kt\norg/intellij/markdown/parser/MarkerProcessor$StateInfo\n*L\n180#1:201,2\n*E\n"})
    public static class StateInfo {
        @NotNull
        private final MarkdownConstraints currentConstraints;
        @NotNull
        private final MarkdownConstraints nextConstraints;
        @NotNull
        private final List<MarkerBlock> markersStack;

        public StateInfo(@NotNull MarkdownConstraints currentConstraints, @NotNull MarkdownConstraints nextConstraints, @NotNull List<? extends MarkerBlock> markersStack) {
            Intrinsics.checkNotNullParameter((Object)currentConstraints, (String)"currentConstraints");
            Intrinsics.checkNotNullParameter((Object)nextConstraints, (String)"nextConstraints");
            Intrinsics.checkNotNullParameter(markersStack, (String)"markersStack");
            this.currentConstraints = currentConstraints;
            this.nextConstraints = nextConstraints;
            this.markersStack = markersStack;
        }

        @NotNull
        public final MarkdownConstraints getCurrentConstraints() {
            return this.currentConstraints;
        }

        @NotNull
        public final MarkdownConstraints getNextConstraints() {
            return this.nextConstraints;
        }

        @Nullable
        public final ParagraphMarkerBlock getParagraphBlock() {
            Object v0;
            block1: {
                Iterable $this$firstOrNull$iv = this.markersStack;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    MarkerBlock block = (MarkerBlock)element$iv;
                    boolean bl = false;
                    if (!(block instanceof ParagraphMarkerBlock)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        @Nullable
        public final MarkerBlock getLastBlock() {
            return (MarkerBlock)CollectionsKt.lastOrNull(this.markersStack);
        }

        public boolean equals(@Nullable Object other) {
            StateInfo stateInfo = other instanceof StateInfo ? (StateInfo)other : null;
            if (stateInfo == null) {
                return false;
            }
            StateInfo otherStateInfo = stateInfo;
            return Intrinsics.areEqual((Object)this.currentConstraints, (Object)otherStateInfo.currentConstraints) && Intrinsics.areEqual((Object)this.nextConstraints, (Object)otherStateInfo.nextConstraints) && Intrinsics.areEqual(this.markersStack, otherStateInfo.markersStack);
        }

        public int hashCode() {
            int result2 = this.currentConstraints.hashCode();
            result2 = result2 * 37 + this.nextConstraints.hashCode();
            result2 = result2 * 37 + ((Object)this.markersStack).hashCode();
            return result2;
        }
    }
}

