/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.flavours.commonmark;

import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.MarkerProcessorFactory;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.CommonMarkdownConstraints;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.constraints.MarkdownConstraintsKt;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.providers.AtxHeaderProvider;
import org.intellij.markdown.parser.markerblocks.providers.BlockQuoteProvider;
import org.intellij.markdown.parser.markerblocks.providers.CodeBlockProvider;
import org.intellij.markdown.parser.markerblocks.providers.CodeFenceProvider;
import org.intellij.markdown.parser.markerblocks.providers.HorizontalRuleProvider;
import org.intellij.markdown.parser.markerblocks.providers.HtmlBlockProvider;
import org.intellij.markdown.parser.markerblocks.providers.LinkReferenceDefinitionProvider;
import org.intellij.markdown.parser.markerblocks.providers.ListMarkerProvider;
import org.intellij.markdown.parser.markerblocks.providers.SetextHeaderProvider;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.jetbrains.annotations.NotNull;

public class CommonMarkMarkerProcessor
extends MarkerProcessor<MarkerProcessor.StateInfo> {
    @NotNull
    private MarkerProcessor.StateInfo stateInfo;
    @NotNull
    private final List<MarkerBlockProvider<MarkerProcessor.StateInfo>> markerBlockProviders;

    public CommonMarkMarkerProcessor(@NotNull ProductionHolder productionHolder, @NotNull MarkdownConstraints constraintsBase) {
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkNotNullParameter((Object)constraintsBase, (String)"constraintsBase");
        super(productionHolder, constraintsBase);
        this.stateInfo = new MarkerProcessor.StateInfo(this.getStartConstraints(), this.getStartConstraints(), this.getMarkersStack());
        Object[] objectArray = new MarkerBlockProvider[]{new CodeBlockProvider(), new HorizontalRuleProvider(), new CodeFenceProvider(), new SetextHeaderProvider(), new BlockQuoteProvider(), new ListMarkerProvider(), new AtxHeaderProvider(), new HtmlBlockProvider(), new LinkReferenceDefinitionProvider()};
        this.markerBlockProviders = CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    protected MarkerProcessor.StateInfo getStateInfo() {
        return this.stateInfo;
    }

    public void setStateInfo(@NotNull MarkerProcessor.StateInfo stateInfo) {
        Intrinsics.checkNotNullParameter((Object)stateInfo, (String)"<set-?>");
        this.stateInfo = stateInfo;
    }

    @Override
    @NotNull
    protected List<MarkerBlockProvider<MarkerProcessor.StateInfo>> getMarkerBlockProviders() {
        return this.markerBlockProviders;
    }

    @Override
    protected void updateStateInfo(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (pos.getOffsetInCurrentLine() == -1) {
            this.setStateInfo(new MarkerProcessor.StateInfo(this.getStartConstraints(), this.getTopBlockConstraints().applyToNextLine(pos), this.getMarkersStack()));
        } else if (MarkerBlockProvider.Companion.isStartOfLineWithConstraints(pos, this.getStateInfo().getNextConstraints())) {
            MarkdownConstraints markdownConstraints = this.getStateInfo().getNextConstraints();
            MarkdownConstraints markdownConstraints2 = this.getStateInfo().getNextConstraints().addModifierIfNeeded(pos);
            if (markdownConstraints2 == null) {
                markdownConstraints2 = this.getStateInfo().getNextConstraints();
            }
            this.setStateInfo(new MarkerProcessor.StateInfo(markdownConstraints, markdownConstraints2, this.getMarkersStack()));
        }
    }

    @Override
    protected void populateConstraintsTokens(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints, @NotNull ProductionHolder productionHolder) {
        IElementType iElementType;
        Character c;
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        if (constraints.getIndent() == 0) {
            return;
        }
        int startOffset = pos.getOffset();
        int endOffset = Math.min(pos.getOffset() - pos.getOffsetInCurrentLine() + MarkdownConstraintsKt.getCharsEaten(constraints, pos.getCurrentLine()), pos.getNextLineOrEofOffset());
        Character c2 = c = ArraysKt.lastOrNull((char[])constraints.getTypes());
        char c3 = '>';
        if (c2 != null && c2.charValue() == c3) {
            iElementType = MarkdownTokenTypes.BLOCK_QUOTE;
        } else {
            boolean bl;
            Character c4 = c;
            c3 = '.';
            if (c4 != null && c4.charValue() == c3) {
                bl = true;
            } else {
                Character c5 = c;
                c3 = ')';
                bl = c5 != null && c5.charValue() == c3;
            }
            iElementType = bl ? MarkdownTokenTypes.LIST_NUMBER : MarkdownTokenTypes.LIST_BULLET;
        }
        IElementType type2 = iElementType;
        productionHolder.addProduction(CollectionsKt.listOf((Object)new SequentialParser.Node(new IntRange(startOffset, endOffset), type2)));
    }

    @Override
    @NotNull
    public List<MarkerBlock> createNewMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        if (pos.getOffsetInCurrentLine() == -1) {
            return this.getNO_BLOCKS();
        }
        return super.createNewMarkerBlocks(pos, productionHolder);
    }

    public static final class Factory
    implements MarkerProcessorFactory {
        @NotNull
        public static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        @Override
        @NotNull
        public MarkerProcessor<?> createMarkerProcessor(@NotNull ProductionHolder productionHolder) {
            Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
            return new CommonMarkMarkerProcessor(productionHolder, CommonMarkdownConstraints.Companion.getBASE());
        }
    }
}

