/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.ast;

import java.util.ArrayList;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.CompositeASTNode;
import org.intellij.markdown.ast.LeafASTNode;
import org.intellij.markdown.ast.impl.ListCompositeNode;
import org.intellij.markdown.ast.impl.ListItemCompositeNode;
import org.intellij.markdown.parser.CancellationToken;
import org.jetbrains.annotations.NotNull;

public class ASTNodeBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CharSequence text;
    @NotNull
    private final CancellationToken cancellationToken;

    public ASTNodeBuilder(@NotNull CharSequence text2, @NotNull CancellationToken cancellationToken) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)cancellationToken, (String)"cancellationToken");
        this.text = text2;
        this.cancellationToken = cancellationToken;
    }

    @NotNull
    protected final CharSequence getText() {
        return this.text;
    }

    public ASTNodeBuilder(@NotNull CharSequence text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this(text2, CancellationToken.NonCancellable.INSTANCE);
    }

    @NotNull
    public List<ASTNode> createLeafNodes(@NotNull IElementType type2, int startOffset, int endOffset) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (Intrinsics.areEqual((Object)type2, (Object)MarkdownTokenTypes.WHITE_SPACE)) {
            ArrayList<LeafASTNode> result2 = new ArrayList<LeafASTNode>();
            int lastEol = startOffset;
            while (lastEol < endOffset) {
                this.cancellationToken.checkCancelled();
                int nextEol = Companion.indexOfSubSeq(this.text, lastEol, endOffset, '\n');
                if (nextEol == -1) break;
                if (nextEol > lastEol) {
                    result2.add(new LeafASTNode(MarkdownTokenTypes.WHITE_SPACE, lastEol, nextEol));
                }
                result2.add(new LeafASTNode(MarkdownTokenTypes.EOL, nextEol, nextEol + 1));
                lastEol = nextEol + 1;
            }
            if (endOffset > lastEol) {
                result2.add(new LeafASTNode(MarkdownTokenTypes.WHITE_SPACE, lastEol, endOffset));
            }
            return result2;
        }
        return CollectionsKt.listOf((Object)new LeafASTNode(type2, startOffset, endOffset));
    }

    @NotNull
    public CompositeASTNode createCompositeNode(@NotNull IElementType type2, @NotNull List<? extends ASTNode> children) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        this.cancellationToken.checkCancelled();
        IElementType iElementType = type2;
        if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.UNORDERED_LIST) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ORDERED_LIST)) {
            return new ListCompositeNode(type2, children);
        }
        if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.LIST_ITEM)) {
            return new ListItemCompositeNode(children);
        }
        return new CompositeASTNode(type2, children);
    }

    public static final class Companion {
        private Companion() {
        }

        public final int indexOfSubSeq(@NotNull CharSequence s, int from, int to, char c) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            int i2 = from;
            int n = to - 1;
            if (i2 <= n) {
                while (true) {
                    if (s.charAt(i2) == c) {
                        return i2;
                    }
                    if (i2 == n) break;
                    ++i2;
                }
            }
            return -1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

