/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop;

import com.canonical.DBusMenu;
import java.util.List;
import org.freedesktop.IStatusNotifierItem;
import org.freedesktop.Pixmap;
import org.freedesktop.StatusNotifierItemImpl;
import org.freedesktop.StatusNotifierItemMenuItemListener;
import org.freedesktop.StatusNotifierListener;
import org.freedesktop.dbus.exceptions.DBusException;

public class StatusNotifierItem {
    private StatusNotifierItemImpl statusNotifierItem;
    private DBusMenu dbusMenu;

    public StatusNotifierItem(String serviceName, String title2, IStatusNotifierItem.Category category, List<Pixmap> pixmaps, String iconName, String iconThemePath, List<MenuItem> menuItems2) throws DBusException {
        try {
            this.dbusMenu = new DBusMenu(serviceName, menuItems2);
            this.statusNotifierItem = new StatusNotifierItemImpl(serviceName, title2, category, pixmaps, iconName, iconThemePath);
        }
        catch (DBusException e) {
            this.statusNotifierItem = null;
            this.dbusMenu = null;
            throw e;
        }
    }

    public synchronized void unregister() throws DBusException {
        if (this.statusNotifierItem != null) {
            try {
                this.statusNotifierItem.unregister();
            }
            finally {
                this.statusNotifierItem = null;
                if (this.dbusMenu != null) {
                    try {
                        this.dbusMenu.unregister();
                    }
                    finally {
                        this.dbusMenu = null;
                    }
                }
            }
        }
    }

    public synchronized void onActivate(StatusNotifierListener listener) {
        if (this.statusNotifierItem != null) {
            this.statusNotifierItem.addActivateListener(listener);
        }
    }

    public static class MenuItem {
        private final String text;
        private final StatusNotifierItemMenuItemListener listener;

        public MenuItem(String text2, StatusNotifierItemMenuItemListener listener) {
            this.text = text2;
            this.listener = listener;
        }

        public String getText() {
            return this.text;
        }

        public StatusNotifierItemMenuItemListener getListener() {
            return this.listener;
        }
    }
}

