/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce;

import java.io.IOException;
import java.security.PublicKey;
import java.util.List;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.internal.asn1.misc.MiscObjectIdentifiers;
import org.bouncycastle.jcajce.provider.asymmetric.compositesignatures.CompositeIndex;

public class CompositePublicKey
implements PublicKey {
    private final List<PublicKey> keys;
    private final ASN1ObjectIdentifier algorithmIdentifier;

    public List<PublicKey> getPublicKeys() {
        return this.keys;
    }

    @Override
    public String getAlgorithm() {
        return CompositeIndex.getAlgorithmName(this.algorithmIdentifier);
    }

    public ASN1ObjectIdentifier getAlgorithmIdentifier() {
        return this.algorithmIdentifier;
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (int j = 0; j < this.keys.size(); ++j) {
            if (this.algorithmIdentifier.equals(MiscObjectIdentifiers.id_composite_key)) {
                aSN1EncodableVector.add(SubjectPublicKeyInfo.getInstance(this.keys.get(j).getEncoded()));
                continue;
            }
            SubjectPublicKeyInfo subjectPublicKeyInfo2 = SubjectPublicKeyInfo.getInstance(this.keys.get(j).getEncoded());
            aSN1EncodableVector.add(subjectPublicKeyInfo2.getPublicKeyData());
        }
        try {
            return new SubjectPublicKeyInfo(new AlgorithmIdentifier(this.algorithmIdentifier), new DERSequence(aSN1EncodableVector)).getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new IllegalStateException("unable to encode composite public key: " + iOException.getMessage());
        }
    }

    public int hashCode() {
        return this.keys.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CompositePublicKey) {
            boolean bl = true;
            CompositePublicKey compositePublicKey = (CompositePublicKey)object;
            if (!compositePublicKey.getAlgorithmIdentifier().equals(this.algorithmIdentifier) || !this.keys.equals(compositePublicKey.keys)) {
                bl = false;
            }
            return bl;
        }
        return false;
    }
}

