/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetStringParser;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1SetParser;
import org.bouncycastle.asn1.cms.ContentInfoParser;
import org.bouncycastle.asn1.cms.SignedDataParser;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSContentInfoParser;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedHelper;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.PKCS7TypedStream;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.util.Store;

public class CMSSignedDataParser
extends CMSContentInfoParser {
    private static final CMSSignedHelper HELPER = CMSSignedHelper.INSTANCE;
    private static final DefaultDigestAlgorithmIdentifierFinder dgstAlgFinder = new DefaultDigestAlgorithmIdentifierFinder();
    private SignedDataParser _signedData;
    private ASN1ObjectIdentifier _signedContentType;
    private CMSTypedStream _signedContent;
    private Map digests;
    private Set<AlgorithmIdentifier> digestAlgorithms;
    private SignerInformationStore _signerInfoStore;
    private ASN1Set _certSet;
    private ASN1Set _crlSet;
    private boolean _isCertCrlParsed;

    public CMSSignedDataParser(DigestCalculatorProvider digestCalculatorProvider, InputStream inputStream) throws CMSException {
        this(digestCalculatorProvider, null, inputStream);
    }

    public CMSSignedDataParser(DigestCalculatorProvider digestCalculatorProvider, CMSTypedStream cMSTypedStream, InputStream inputStream) throws CMSException {
        super(inputStream);
        try {
            Object object;
            Object object2;
            ASN1Encodable aSN1Encodable;
            this._signedContent = cMSTypedStream;
            this._signedData = SignedDataParser.getInstance(this._contentInfo.getContent(16));
            this.digests = new HashMap();
            ASN1SetParser aSN1SetParser = this._signedData.getDigestAlgorithms();
            HashSet<AlgorithmIdentifier> hashSet = new HashSet<AlgorithmIdentifier>();
            while ((aSN1Encodable = aSN1SetParser.readObject()) != null) {
                object2 = AlgorithmIdentifier.getInstance(aSN1Encodable);
                hashSet.add((AlgorithmIdentifier)object2);
                try {
                    object = digestCalculatorProvider.get((AlgorithmIdentifier)object2);
                    if (object == null) continue;
                    this.digests.put(((AlgorithmIdentifier)object2).getAlgorithm(), object);
                }
                catch (OperatorCreationException operatorCreationException) {}
            }
            this.digestAlgorithms = Collections.unmodifiableSet(hashSet);
            object2 = this._signedData.getEncapContentInfo();
            object = ((ContentInfoParser)object2).getContent(4);
            if (object instanceof ASN1OctetStringParser) {
                ASN1OctetStringParser aSN1OctetStringParser = (ASN1OctetStringParser)object;
                CMSTypedStream cMSTypedStream2 = new CMSTypedStream(((ContentInfoParser)object2).getContentType(), aSN1OctetStringParser.getOctetStream());
                if (this._signedContent == null) {
                    this._signedContent = cMSTypedStream2;
                } else {
                    cMSTypedStream2.drain();
                }
            } else if (object != null) {
                PKCS7TypedStream pKCS7TypedStream = new PKCS7TypedStream(((ContentInfoParser)object2).getContentType(), (ASN1Encodable)object);
                if (this._signedContent == null) {
                    this._signedContent = pKCS7TypedStream;
                } else {
                    pKCS7TypedStream.drain();
                }
            }
            this._signedContentType = cMSTypedStream == null ? ((ContentInfoParser)object2).getContentType() : this._signedContent.getContentType();
        }
        catch (IOException iOException) {
            throw new CMSException("io exception: " + iOException.getMessage(), iOException);
        }
    }

    public SignerInformationStore getSignerInfos() throws CMSException {
        if (this._signerInfoStore == null) {
            this.populateCertCrlSets();
            ArrayList<SignerInformation> arrayList = new ArrayList<SignerInformation>();
            HashMap hashMap = new HashMap();
            for (Object object : this.digests.keySet()) {
                hashMap.put(object, ((DigestCalculator)this.digests.get(object)).getDigest());
            }
            try {
                ASN1Encodable aSN1Encodable;
                Object object;
                object = this._signedData.getSignerInfos();
                while ((aSN1Encodable = object.readObject()) != null) {
                    SignerInfo signerInfo = SignerInfo.getInstance(aSN1Encodable.toASN1Primitive());
                    byte[] byArray = (byte[])hashMap.get(signerInfo.getDigestAlgorithm().getAlgorithm());
                    arrayList.add(new SignerInformation(signerInfo, this._signedContentType, null, byArray));
                }
            }
            catch (IOException iOException) {
                throw new CMSException("io exception: " + iOException.getMessage(), iOException);
            }
            this._signerInfoStore = new SignerInformationStore(arrayList);
        }
        return this._signerInfoStore;
    }

    public Store getCertificates() throws CMSException {
        this.populateCertCrlSets();
        return HELPER.getCertificates(this._certSet);
    }

    private void populateCertCrlSets() throws CMSException {
        if (this._isCertCrlParsed) {
            return;
        }
        this._isCertCrlParsed = true;
        try {
            this._certSet = CMSSignedDataParser.getASN1Set(this._signedData.getCertificates());
            this._crlSet = CMSSignedDataParser.getASN1Set(this._signedData.getCrls());
        }
        catch (IOException iOException) {
            throw new CMSException("problem parsing cert/crl sets", iOException);
        }
    }

    public CMSTypedStream getSignedContent() {
        if (this._signedContent == null) {
            return null;
        }
        InputStream inputStream = CMSUtils.attachDigestsToInputStream(this.digests.values(), this._signedContent.getContentStream());
        return new CMSTypedStream(this._signedContent.getContentType(), inputStream);
    }

    private static ASN1Set getASN1Set(ASN1SetParser aSN1SetParser) {
        return aSN1SetParser == null ? null : ASN1Set.getInstance(aSN1SetParser.toASN1Primitive());
    }
}

