/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.cms.Attribute;

public class AttributeTable {
    private Hashtable attributes = new Hashtable();

    public AttributeTable(ASN1Set aSN1Set) {
        for (int j = 0; j != aSN1Set.size(); ++j) {
            Attribute attribute = Attribute.getInstance(aSN1Set.getObjectAt(j));
            this.addAttribute(attribute.getAttrType(), attribute);
        }
    }

    private void addAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, Attribute attribute) {
        Object v = this.attributes.get(aSN1ObjectIdentifier);
        if (v == null) {
            this.attributes.put(aSN1ObjectIdentifier, attribute);
        } else {
            Vector<Object> vector;
            if (v instanceof Attribute) {
                vector = new Vector<Object>();
                vector.addElement(v);
                vector.addElement(attribute);
            } else {
                vector = (Vector<Object>)v;
                vector.addElement(attribute);
            }
            this.attributes.put(aSN1ObjectIdentifier, vector);
        }
    }

    public ASN1EncodableVector getAll(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Object v = this.attributes.get(aSN1ObjectIdentifier);
        if (v instanceof Vector) {
            Enumeration enumeration = ((Vector)v).elements();
            while (enumeration.hasMoreElements()) {
                aSN1EncodableVector.add((Attribute)enumeration.nextElement());
            }
        } else if (v != null) {
            aSN1EncodableVector.add((Attribute)v);
        }
        return aSN1EncodableVector;
    }
}

