/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.DataInput;
import java.io.IOException;

public final class ByteUtils {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    private static void checkReadLength(int length) {
        if (length > 8) {
            throw new IllegalArgumentException("Can't read more than eight bytes into a long value");
        }
    }

    public static long fromLittleEndian(byte[] bytes2, int off, int length) {
        ByteUtils.checkReadLength(length);
        long l = 0L;
        for (int i2 = 0; i2 < length; ++i2) {
            l |= ((long)bytes2[off + i2] & 0xFFL) << 8 * i2;
        }
        return l;
    }

    public static long fromLittleEndian(DataInput in, int length) throws IOException {
        ByteUtils.checkReadLength(length);
        long l = 0L;
        for (int i2 = 0; i2 < length; ++i2) {
            long b = in.readUnsignedByte();
            l |= b << i2 * 8;
        }
        return l;
    }

    public static void toLittleEndian(byte[] b, long value2, int off, int length) {
        long num = value2;
        for (int i2 = 0; i2 < length; ++i2) {
            b[off + i2] = (byte)(num & 0xFFL);
            num >>= 8;
        }
    }
}

