/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.nio.charset.StandardCharsets;

public class ArchiveUtils {
    public static boolean isArrayZero(byte[] a, int size) {
        for (int i2 = 0; i2 < size; ++i2) {
            if (a[i2] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqual(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2, boolean ignoreTrailingNulls) {
        int i2;
        int minLen = Math.min(length1, length2);
        for (i2 = 0; i2 < minLen; ++i2) {
            if (buffer1[offset1 + i2] == buffer2[offset2 + i2]) continue;
            return false;
        }
        if (length1 == length2) {
            return true;
        }
        if (ignoreTrailingNulls) {
            if (length1 > length2) {
                for (i2 = length2; i2 < length1; ++i2) {
                    if (buffer1[offset1 + i2] == 0) continue;
                    return false;
                }
            } else {
                for (i2 = length1; i2 < length2; ++i2) {
                    if (buffer2[offset2 + i2] == 0) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean matchAsciiBuffer(String expected, byte[] buffer, int offset, int length) {
        byte[] buffer1 = expected.getBytes(StandardCharsets.US_ASCII);
        return ArchiveUtils.isEqual(buffer1, 0, buffer1.length, buffer, offset, length, false);
    }
}

