/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.tls.internal.der;

import java.math.BigInteger;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.tls.internal.der.AlgorithmIdentifier;
import okhttp3.tls.internal.der.AttributeTypeAndValue;
import okhttp3.tls.internal.der.BitString;
import okhttp3.tls.internal.der.Extension;
import okhttp3.tls.internal.der.SubjectPublicKeyInfo;
import okhttp3.tls.internal.der.Validity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TbsCertificate {
    private final long version;
    @NotNull
    private final BigInteger serialNumber;
    @NotNull
    private final AlgorithmIdentifier signature;
    @NotNull
    private final List<List<AttributeTypeAndValue>> issuer;
    @NotNull
    private final Validity validity;
    @NotNull
    private final List<List<AttributeTypeAndValue>> subject;
    @NotNull
    private final SubjectPublicKeyInfo subjectPublicKeyInfo;
    @Nullable
    private final BitString issuerUniqueID;
    @Nullable
    private final BitString subjectUniqueID;
    @NotNull
    private final List<Extension> extensions;

    public TbsCertificate(long version, @NotNull BigInteger serialNumber, @NotNull AlgorithmIdentifier signature, @NotNull List<? extends List<AttributeTypeAndValue>> issuer, @NotNull Validity validity2, @NotNull List<? extends List<AttributeTypeAndValue>> subject, @NotNull SubjectPublicKeyInfo subjectPublicKeyInfo2, @Nullable BitString issuerUniqueID, @Nullable BitString subjectUniqueID, @NotNull List<Extension> extensions) {
        Intrinsics.checkNotNullParameter((Object)serialNumber, (String)"serialNumber");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter(issuer, (String)"issuer");
        Intrinsics.checkNotNullParameter((Object)validity2, (String)"validity");
        Intrinsics.checkNotNullParameter(subject, (String)"subject");
        Intrinsics.checkNotNullParameter((Object)subjectPublicKeyInfo2, (String)"subjectPublicKeyInfo");
        Intrinsics.checkNotNullParameter(extensions, (String)"extensions");
        this.version = version;
        this.serialNumber = serialNumber;
        this.signature = signature;
        this.issuer = issuer;
        this.validity = validity2;
        this.subject = subject;
        this.subjectPublicKeyInfo = subjectPublicKeyInfo2;
        this.issuerUniqueID = issuerUniqueID;
        this.subjectUniqueID = subjectUniqueID;
        this.extensions = extensions;
    }

    public final long getVersion() {
        return this.version;
    }

    @NotNull
    public final BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    @NotNull
    public final AlgorithmIdentifier getSignature() {
        return this.signature;
    }

    @NotNull
    public final List<List<AttributeTypeAndValue>> getIssuer() {
        return this.issuer;
    }

    @NotNull
    public final Validity getValidity() {
        return this.validity;
    }

    @NotNull
    public final List<List<AttributeTypeAndValue>> getSubject() {
        return this.subject;
    }

    @NotNull
    public final SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.subjectPublicKeyInfo;
    }

    @Nullable
    public final BitString getIssuerUniqueID() {
        return this.issuerUniqueID;
    }

    @Nullable
    public final BitString getSubjectUniqueID() {
        return this.subjectUniqueID;
    }

    @NotNull
    public final List<Extension> getExtensions() {
        return this.extensions;
    }

    @NotNull
    public final String getSignatureAlgorithmName() {
        String string;
        String string2 = this.signature.getAlgorithm();
        if (Intrinsics.areEqual((Object)string2, (Object)"1.2.840.113549.1.1.11")) {
            string = "SHA256WithRSA";
        } else if (Intrinsics.areEqual((Object)string2, (Object)"1.2.840.10045.4.3.2")) {
            string = "SHA256withECDSA";
        } else {
            throw new IllegalStateException(("unexpected signature algorithm: " + this.signature.getAlgorithm()).toString());
        }
        return string;
    }

    public int hashCode() {
        int result2 = 0;
        result2 = 31 * result2 + (int)this.version;
        result2 = 31 * result2 + this.serialNumber.hashCode();
        result2 = 31 * result2 + this.signature.hashCode();
        result2 = 31 * result2 + ((Object)this.issuer).hashCode();
        result2 = 31 * result2 + this.validity.hashCode();
        result2 = 31 * result2 + ((Object)this.subject).hashCode();
        result2 = 31 * result2 + this.subjectPublicKeyInfo.hashCode();
        BitString bitString = this.issuerUniqueID;
        result2 = 31 * result2 + (bitString != null ? bitString.hashCode() : 0);
        BitString bitString2 = this.subjectUniqueID;
        result2 = 31 * result2 + (bitString2 != null ? bitString2.hashCode() : 0);
        result2 = 31 * result2 + ((Object)this.extensions).hashCode();
        return result2;
    }

    public final long component1() {
        return this.version;
    }

    @NotNull
    public final BigInteger component2() {
        return this.serialNumber;
    }

    @NotNull
    public final AlgorithmIdentifier component3() {
        return this.signature;
    }

    @NotNull
    public final List<List<AttributeTypeAndValue>> component4() {
        return this.issuer;
    }

    @NotNull
    public final Validity component5() {
        return this.validity;
    }

    @NotNull
    public final List<List<AttributeTypeAndValue>> component6() {
        return this.subject;
    }

    @NotNull
    public final SubjectPublicKeyInfo component7() {
        return this.subjectPublicKeyInfo;
    }

    @Nullable
    public final BitString component8() {
        return this.issuerUniqueID;
    }

    @Nullable
    public final BitString component9() {
        return this.subjectUniqueID;
    }

    @NotNull
    public final List<Extension> component10() {
        return this.extensions;
    }

    @NotNull
    public final TbsCertificate copy(long version, @NotNull BigInteger serialNumber, @NotNull AlgorithmIdentifier signature, @NotNull List<? extends List<AttributeTypeAndValue>> issuer, @NotNull Validity validity2, @NotNull List<? extends List<AttributeTypeAndValue>> subject, @NotNull SubjectPublicKeyInfo subjectPublicKeyInfo2, @Nullable BitString issuerUniqueID, @Nullable BitString subjectUniqueID, @NotNull List<Extension> extensions) {
        Intrinsics.checkNotNullParameter((Object)serialNumber, (String)"serialNumber");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter(issuer, (String)"issuer");
        Intrinsics.checkNotNullParameter((Object)validity2, (String)"validity");
        Intrinsics.checkNotNullParameter(subject, (String)"subject");
        Intrinsics.checkNotNullParameter((Object)subjectPublicKeyInfo2, (String)"subjectPublicKeyInfo");
        Intrinsics.checkNotNullParameter(extensions, (String)"extensions");
        return new TbsCertificate(version, serialNumber, signature, issuer, validity2, subject, subjectPublicKeyInfo2, issuerUniqueID, subjectUniqueID, extensions);
    }

    public static /* synthetic */ TbsCertificate copy$default(TbsCertificate tbsCertificate2, long l, BigInteger bigInteger, AlgorithmIdentifier algorithmIdentifier2, List list2, Validity validity2, List list3, SubjectPublicKeyInfo subjectPublicKeyInfo2, BitString bitString, BitString bitString2, List list4, int n, Object object) {
        if ((n & 1) != 0) {
            l = tbsCertificate2.version;
        }
        if ((n & 2) != 0) {
            bigInteger = tbsCertificate2.serialNumber;
        }
        if ((n & 4) != 0) {
            algorithmIdentifier2 = tbsCertificate2.signature;
        }
        if ((n & 8) != 0) {
            list2 = tbsCertificate2.issuer;
        }
        if ((n & 0x10) != 0) {
            validity2 = tbsCertificate2.validity;
        }
        if ((n & 0x20) != 0) {
            list3 = tbsCertificate2.subject;
        }
        if ((n & 0x40) != 0) {
            subjectPublicKeyInfo2 = tbsCertificate2.subjectPublicKeyInfo;
        }
        if ((n & 0x80) != 0) {
            bitString = tbsCertificate2.issuerUniqueID;
        }
        if ((n & 0x100) != 0) {
            bitString2 = tbsCertificate2.subjectUniqueID;
        }
        if ((n & 0x200) != 0) {
            list4 = tbsCertificate2.extensions;
        }
        return tbsCertificate2.copy(l, bigInteger, algorithmIdentifier2, list2, validity2, list3, subjectPublicKeyInfo2, bitString, bitString2, list4);
    }

    @NotNull
    public String toString() {
        return "TbsCertificate(version=" + this.version + ", serialNumber=" + this.serialNumber + ", signature=" + this.signature + ", issuer=" + this.issuer + ", validity=" + this.validity + ", subject=" + this.subject + ", subjectPublicKeyInfo=" + this.subjectPublicKeyInfo + ", issuerUniqueID=" + this.issuerUniqueID + ", subjectUniqueID=" + this.subjectUniqueID + ", extensions=" + this.extensions + ')';
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TbsCertificate)) {
            return false;
        }
        TbsCertificate tbsCertificate2 = (TbsCertificate)other;
        if (this.version != tbsCertificate2.version) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.serialNumber, (Object)tbsCertificate2.serialNumber)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.signature, (Object)tbsCertificate2.signature)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.issuer, tbsCertificate2.issuer)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.validity, (Object)tbsCertificate2.validity)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.subject, tbsCertificate2.subject)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.subjectPublicKeyInfo, (Object)tbsCertificate2.subjectPublicKeyInfo)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.issuerUniqueID, (Object)tbsCertificate2.issuerUniqueID)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.subjectUniqueID, (Object)tbsCertificate2.subjectUniqueID)) {
            return false;
        }
        return Intrinsics.areEqual(this.extensions, tbsCertificate2.extensions);
    }
}

