/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.tls.internal.der;

import kotlin.jvm.internal.Intrinsics;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BitString {
    @NotNull
    private final ByteString byteString;
    private final int unusedBitsCount;

    public BitString(@NotNull ByteString byteString, int unusedBitsCount) {
        Intrinsics.checkNotNullParameter((Object)byteString, (String)"byteString");
        this.byteString = byteString;
        this.unusedBitsCount = unusedBitsCount;
    }

    @NotNull
    public final ByteString getByteString() {
        return this.byteString;
    }

    public final int getUnusedBitsCount() {
        return this.unusedBitsCount;
    }

    public int hashCode() {
        int result2 = 0;
        result2 = 31 * result2 + this.byteString.hashCode();
        result2 = 31 * result2 + this.unusedBitsCount;
        return result2;
    }

    @NotNull
    public final ByteString component1() {
        return this.byteString;
    }

    public final int component2() {
        return this.unusedBitsCount;
    }

    @NotNull
    public final BitString copy(@NotNull ByteString byteString, int unusedBitsCount) {
        Intrinsics.checkNotNullParameter((Object)byteString, (String)"byteString");
        return new BitString(byteString, unusedBitsCount);
    }

    public static /* synthetic */ BitString copy$default(BitString bitString, ByteString byteString, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            byteString = bitString.byteString;
        }
        if ((n2 & 2) != 0) {
            n = bitString.unusedBitsCount;
        }
        return bitString.copy(byteString, n);
    }

    @NotNull
    public String toString() {
        return "BitString(byteString=" + this.byteString + ", unusedBitsCount=" + this.unusedBitsCount + ')';
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BitString)) {
            return false;
        }
        BitString bitString = (BitString)other;
        if (!Intrinsics.areEqual((Object)this.byteString, (Object)bitString.byteString)) {
            return false;
        }
        return this.unusedBitsCount == bitString.unusedBitsCount;
    }
}

