/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.tls.internal;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.platform.Platform;
import okhttp3.tls.HandshakeCertificates;
import okhttp3.tls.HeldCertificate;
import okhttp3.tls.internal.InsecureAndroidTrustManager;
import okhttp3.tls.internal.InsecureExtendedTrustManager;
import okhttp3.tls.internal.TlsUtil;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TlsUtil {
    @NotNull
    public static final TlsUtil INSTANCE = new TlsUtil();
    @NotNull
    private static final char[] password;
    @NotNull
    private static final Lazy localhost$delegate;

    private TlsUtil() {
    }

    @NotNull
    public final char[] getPassword() {
        return password;
    }

    private final HandshakeCertificates getLocalhost() {
        Lazy lazy = localhost$delegate;
        return (HandshakeCertificates)lazy.getValue();
    }

    @JvmStatic
    @NotNull
    public static final HandshakeCertificates localhost() {
        return INSTANCE.getLocalhost();
    }

    @JvmStatic
    @IgnoreJRERequirement
    @NotNull
    public static final X509TrustManager newTrustManager(@Nullable String keyStoreType, @NotNull List<? extends X509Certificate> trustedCertificates, @NotNull List<String> insecureHosts) {
        Intrinsics.checkNotNullParameter(trustedCertificates, (String)"trustedCertificates");
        Intrinsics.checkNotNullParameter(insecureHosts, (String)"insecureHosts");
        KeyStore trustStore = INSTANCE.newEmptyKeyStore(keyStoreType);
        int n = trustedCertificates.size();
        for (int i2 = 0; i2 < n; ++i2) {
            trustStore.setCertificateEntry("cert_" + i2, trustedCertificates.get(i2));
        }
        TrustManagerFactory factory2 = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory2.init(trustStore);
        Object[] objectArray = factory2.getTrustManagers();
        Intrinsics.checkNotNull((Object)objectArray);
        Object[] result2 = objectArray;
        if (!(result2.length == 1 && result2[0] instanceof X509TrustManager)) {
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder().append("Unexpected trust managers: ");
            String string = Arrays.toString(result2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
            String string2 = stringBuilder.append(string).toString();
            throw new IllegalStateException(string2.toString());
        }
        TrustManager trustManager = result2[0];
        Intrinsics.checkNotNull((Object)trustManager, (String)"null cannot be cast to non-null type javax.net.ssl.X509TrustManager");
        X509TrustManager trustManager2 = (X509TrustManager)trustManager;
        return insecureHosts.isEmpty() ? trustManager2 : (Platform.Companion.isAndroid() ? (X509TrustManager)new InsecureAndroidTrustManager(trustManager2, insecureHosts) : (X509TrustManager)new InsecureExtendedTrustManager((X509ExtendedTrustManager)trustManager2, insecureHosts));
    }

    @JvmStatic
    @NotNull
    public static final X509KeyManager newKeyManager(@Nullable String keyStoreType, @Nullable HeldCertificate heldCertificate, X509Certificate ... intermediates) {
        Intrinsics.checkNotNullParameter((Object)intermediates, (String)"intermediates");
        KeyStore keyStore = INSTANCE.newEmptyKeyStore(keyStoreType);
        if (heldCertificate != null) {
            Object[] chain = new Certificate[1 + intermediates.length];
            chain[0] = heldCertificate.certificate();
            ArraysKt.copyInto$default((Object[])intermediates, (Object[])chain, (int)1, (int)0, (int)0, (int)12, null);
            keyStore.setKeyEntry("private", heldCertificate.keyPair().getPrivate(), password, (Certificate[])chain);
        }
        KeyManagerFactory factory2 = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        factory2.init(keyStore, password);
        Object[] objectArray = factory2.getKeyManagers();
        Intrinsics.checkNotNull((Object)objectArray);
        Object[] result2 = objectArray;
        if (!(result2.length == 1 && result2[0] instanceof X509KeyManager)) {
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder().append("Unexpected key managers:");
            String string = Arrays.toString(result2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
            String string2 = stringBuilder.append(string).toString();
            throw new IllegalStateException(string2.toString());
        }
        KeyManager keyManager = result2[0];
        Intrinsics.checkNotNull((Object)keyManager, (String)"null cannot be cast to non-null type javax.net.ssl.X509KeyManager");
        return (X509KeyManager)keyManager;
    }

    private final KeyStore newEmptyKeyStore(String keyStoreType) {
        KeyStore keyStore;
        String string = keyStoreType;
        if (string == null) {
            string = KeyStore.getDefaultType();
        }
        KeyStore $this$newEmptyKeyStore_u24lambda_u242 = keyStore = KeyStore.getInstance(string);
        boolean bl = false;
        InputStream inputStream = null;
        $this$newEmptyKeyStore_u24lambda_u242.load(inputStream, password);
        KeyStore keyStore2 = keyStore;
        Intrinsics.checkNotNullExpressionValue((Object)keyStore2, (String)"getInstance(keyStoreType\u2026utStream, password)\n    }");
        return keyStore2;
    }

    static {
        char[] cArray = "password".toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        password = cArray;
        localhost$delegate = LazyKt.lazy((Function0)localhost.2.INSTANCE);
    }
}

