/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.publicsuffix;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.IDN;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import okhttp3.internal.Util;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PublicSuffixDatabase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicBoolean listRead = new AtomicBoolean(false);
    @NotNull
    private final CountDownLatch readCompleteLatch = new CountDownLatch(1);
    private byte[] publicSuffixListBytes;
    private byte[] publicSuffixExceptionListBytes;
    @NotNull
    public static final String PUBLIC_SUFFIX_RESOURCE = "publicsuffixes.gz";
    @NotNull
    private static final byte[] WILDCARD_LABEL;
    @NotNull
    private static final List<String> PREVAILING_RULE;
    private static final char EXCEPTION_MARKER = '!';
    @NotNull
    private static final PublicSuffixDatabase instance;

    @Nullable
    public final String getEffectiveTldPlusOne(@NotNull String domain) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        String unicodeDomain = IDN.toUnicode(domain);
        Intrinsics.checkNotNullExpressionValue((Object)unicodeDomain, (String)"unicodeDomain");
        List<String> domainLabels = this.splitDomain(unicodeDomain);
        List<String> rule = this.findMatchingRule(domainLabels);
        if (domainLabels.size() == rule.size() && rule.get(0).charAt(0) != '!') {
            return null;
        }
        int firstLabelOffset = rule.get(0).charAt(0) == '!' ? domainLabels.size() - rule.size() : domainLabels.size() - (rule.size() + 1);
        return SequencesKt.joinToString$default((Sequence)SequencesKt.drop((Sequence)CollectionsKt.asSequence((Iterable)this.splitDomain(domain)), (int)firstLabelOffset), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
    }

    private final List<String> splitDomain(String domain) {
        char[] cArray = new char[]{'.'};
        List domainLabels = StringsKt.split$default((CharSequence)domain, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        if (Intrinsics.areEqual((Object)CollectionsKt.last((List)domainLabels), (Object)"")) {
            return CollectionsKt.dropLast((List)domainLabels, (int)1);
        }
        return domainLabels;
    }

    private final List<String> findMatchingRule(List<String> domainLabels) {
        char[] cArray;
        List list2;
        Object exactRuleLabels;
        char[] cArray2;
        String rule;
        if (!this.listRead.get() && this.listRead.compareAndSet(false, true)) {
            this.readTheListUninterruptibly();
        } else {
            try {
                this.readCompleteLatch.await();
            }
            catch (InterruptedException _) {
                Thread.currentThread().interrupt();
            }
        }
        if (!(this.publicSuffixListBytes != null)) {
            boolean $i$a$-check-PublicSuffixDatabase$findMatchingRule$32 = false;
            String $i$a$-check-PublicSuffixDatabase$findMatchingRule$32 = "Unable to load publicsuffixes.gz resource from the classpath.";
            throw new IllegalStateException($i$a$-check-PublicSuffixDatabase$findMatchingRule$32.toString());
        }
        int $i$a$-check-PublicSuffixDatabase$findMatchingRule$32 = 0;
        int n = domainLabels.size();
        byte[][] byArrayArray = new byte[n][];
        while ($i$a$-check-PublicSuffixDatabase$findMatchingRule$32 < n) {
            int n2 = $i$a$-check-PublicSuffixDatabase$findMatchingRule$32++;
            String string = domainLabels.get(n2);
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Intrinsics.checkNotNullExpressionValue((Object)string.getBytes(charset), (String)"this as java.lang.String).getBytes(charset)");
        }
        byte[][] domainLabelsUtf8Bytes = byArrayArray;
        String exactMatch = null;
        int n3 = ((Object[])domainLabelsUtf8Bytes).length;
        for (int i2 = 0; i2 < n3; ++i2) {
            String rule2;
            byte[] byArray = this.publicSuffixListBytes;
            if (this.publicSuffixListBytes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"publicSuffixListBytes");
                byArray = null;
            }
            if ((rule2 = PublicSuffixDatabase.Companion.binarySearch(byArray, domainLabelsUtf8Bytes, i2)) == null) continue;
            exactMatch = rule2;
            break;
        }
        Object wildcardMatch = null;
        if (((Object[])domainLabelsUtf8Bytes).length > 1) {
            byte[][] labelsWithWildcard = (byte[][])((Object[])domainLabelsUtf8Bytes).clone();
            int n4 = ((Object[])labelsWithWildcard).length - 1;
            for (int labelIndex = 0; labelIndex < n4; ++labelIndex) {
                labelsWithWildcard[labelIndex] = WILDCARD_LABEL;
                byte[] byArray = this.publicSuffixListBytes;
                if (this.publicSuffixListBytes == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"publicSuffixListBytes");
                    byArray = null;
                }
                if ((rule = PublicSuffixDatabase.Companion.binarySearch(byArray, labelsWithWildcard, labelIndex)) == null) continue;
                wildcardMatch = rule;
                break;
            }
        }
        String exception = null;
        if (wildcardMatch != null) {
            int n5 = ((Object[])domainLabelsUtf8Bytes).length - 1;
            for (int labelIndex = 0; labelIndex < n5; ++labelIndex) {
                byte[] byArray = this.publicSuffixExceptionListBytes;
                if (this.publicSuffixExceptionListBytes == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"publicSuffixExceptionListBytes");
                    byArray = null;
                }
                if ((rule = PublicSuffixDatabase.Companion.binarySearch(byArray, domainLabelsUtf8Bytes, labelIndex)) == null) continue;
                exception = rule;
                break;
            }
        }
        if (exception != null) {
            exception = '!' + exception;
            char[] labelIndex = new char[]{'.'};
            return StringsKt.split$default((CharSequence)exception, (char[])labelIndex, (boolean)false, (int)0, (int)6, null);
        }
        if (exactMatch == null && wildcardMatch == null) {
            return PREVAILING_RULE;
        }
        Object object = exactMatch;
        if (object == null || (object = StringsKt.split$default((CharSequence)((CharSequence)object), (char[])(cArray2 = new char[]{'.'}), (boolean)false, (int)0, (int)6, null)) == null) {
            object = exactRuleLabels = CollectionsKt.emptyList();
        }
        if ((list2 = wildcardMatch) == null || (list2 = StringsKt.split$default((CharSequence)((CharSequence)((Object)list2)), (char[])(cArray = new char[]{'.'}), (boolean)false, (int)0, (int)6, null)) == null) {
            list2 = CollectionsKt.emptyList();
        }
        List wildcardRuleLabels = list2;
        return exactRuleLabels.size() > wildcardRuleLabels.size() ? exactRuleLabels : wildcardRuleLabels;
    }

    /*
     * Exception decompiling
     */
    private final void readTheListUninterruptibly() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void readTheList() throws IOException {
        try {
            InputStream inputStream;
            Ref.ObjectRef publicSuffixListBytes = new Ref.ObjectRef();
            Ref.ObjectRef publicSuffixExceptionListBytes = new Ref.ObjectRef();
            if (PublicSuffixDatabase.class.getResourceAsStream(PUBLIC_SUFFIX_RESOURCE) == null) {
                return;
            }
            InputStream resource2 = inputStream;
            Object object = (Closeable)Okio.buffer((Source)((Source)new GzipSource(Okio.source((InputStream)resource2))));
            Throwable throwable = null;
            try {
                BufferedSource bufferedSource = (BufferedSource)object;
                boolean bl = false;
                int totalBytes = bufferedSource.readInt();
                publicSuffixListBytes.element = bufferedSource.readByteArray((long)totalBytes);
                int totalExceptionBytes = bufferedSource.readInt();
                publicSuffixExceptionListBytes.element = bufferedSource.readByteArray((long)totalExceptionBytes);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = this;
            synchronized (object) {
                boolean bl = false;
                Object object2 = publicSuffixListBytes.element;
                Intrinsics.checkNotNull((Object)object2);
                this.publicSuffixListBytes = (byte[])object2;
                Object object3 = publicSuffixExceptionListBytes.element;
                Intrinsics.checkNotNull((Object)object3);
                this.publicSuffixExceptionListBytes = (byte[])object3;
                Unit unit = Unit.INSTANCE;
            }
        }
        finally {
            this.readCompleteLatch.countDown();
        }
    }

    public final void setListBytes(@NotNull byte[] publicSuffixListBytes, @NotNull byte[] publicSuffixExceptionListBytes) {
        Intrinsics.checkNotNullParameter((Object)publicSuffixListBytes, (String)"publicSuffixListBytes");
        Intrinsics.checkNotNullParameter((Object)publicSuffixExceptionListBytes, (String)"publicSuffixExceptionListBytes");
        this.publicSuffixListBytes = publicSuffixListBytes;
        this.publicSuffixExceptionListBytes = publicSuffixExceptionListBytes;
        this.listRead.set(true);
        this.readCompleteLatch.countDown();
    }

    static {
        byte[] byArray = new byte[]{42};
        WILDCARD_LABEL = byArray;
        PREVAILING_RULE = CollectionsKt.listOf((Object)"*");
        instance = new PublicSuffixDatabase();
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PublicSuffixDatabase get() {
            return instance;
        }

        private final String binarySearch(byte[] $this$binarySearch, byte[][] labels, int labelIndex) {
            int low = 0;
            int high = $this$binarySearch.length;
            String match2 = null;
            while (low < high) {
                int mid;
                for (mid = (low + high) / 2; mid > -1 && $this$binarySearch[mid] != 10; --mid) {
                }
                ++mid;
                int end = 1;
                while ($this$binarySearch[mid + end] != 10) {
                    ++end;
                }
                int publicSuffixLength = mid + end - mid;
                int compareResult = 0;
                int currentLabelIndex = labelIndex;
                int currentLabelByteIndex = 0;
                int publicSuffixByteIndex = 0;
                boolean expectDot = false;
                while (true) {
                    int byte0 = 0;
                    if (expectDot) {
                        byte0 = 46;
                        expectDot = false;
                    } else {
                        byte0 = Util.and(labels[currentLabelIndex][currentLabelByteIndex], 255);
                    }
                    int byte1 = Util.and($this$binarySearch[mid + publicSuffixByteIndex], 255);
                    compareResult = byte0 - byte1;
                    if (compareResult != 0) break;
                    ++currentLabelByteIndex;
                    if (++publicSuffixByteIndex == publicSuffixLength) break;
                    if (labels[currentLabelIndex].length != currentLabelByteIndex) continue;
                    if (currentLabelIndex == ((Object[])labels).length - 1) break;
                    ++currentLabelIndex;
                    currentLabelByteIndex = -1;
                    expectDot = true;
                }
                if (compareResult < 0) {
                    high = mid - 1;
                    continue;
                }
                if (compareResult > 0) {
                    low = mid + end + 1;
                    continue;
                }
                int publicSuffixBytesLeft = publicSuffixLength - publicSuffixByteIndex;
                int labelBytesLeft = labels[currentLabelIndex].length - currentLabelByteIndex;
                int n = ((Object[])labels).length;
                for (int i2 = currentLabelIndex + 1; i2 < n; ++i2) {
                    labelBytesLeft += labels[i2].length;
                }
                if (labelBytesLeft < publicSuffixBytesLeft) {
                    high = mid - 1;
                    continue;
                }
                if (labelBytesLeft > publicSuffixBytesLeft) {
                    low = mid + end + 1;
                    continue;
                }
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                Charset charset2 = charset;
                match2 = new String($this$binarySearch, mid, publicSuffixLength, charset2);
                break;
            }
            return match2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

