/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform.android;

import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.Util;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.platform.android.AndroidSocketAdapter;
import okhttp3.internal.platform.android.SocketAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StandardAndroidSocketAdapter
extends AndroidSocketAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Class<? super SSLSocketFactory> sslSocketFactoryClass;
    @NotNull
    private final Class<?> paramClass;

    public StandardAndroidSocketAdapter(@NotNull Class<? super SSLSocket> sslSocketClass, @NotNull Class<? super SSLSocketFactory> sslSocketFactoryClass, @NotNull Class<?> paramClass) {
        Intrinsics.checkNotNullParameter(sslSocketClass, (String)"sslSocketClass");
        Intrinsics.checkNotNullParameter(sslSocketFactoryClass, (String)"sslSocketFactoryClass");
        Intrinsics.checkNotNullParameter(paramClass, (String)"paramClass");
        super(sslSocketClass);
        this.sslSocketFactoryClass = sslSocketFactoryClass;
        this.paramClass = paramClass;
    }

    @Override
    public boolean matchesSocketFactory(@NotNull SSLSocketFactory sslSocketFactory) {
        Intrinsics.checkNotNullParameter((Object)sslSocketFactory, (String)"sslSocketFactory");
        return this.sslSocketFactoryClass.isInstance(sslSocketFactory);
    }

    @Override
    @Nullable
    public X509TrustManager trustManager(@NotNull SSLSocketFactory sslSocketFactory) {
        Object context2;
        Intrinsics.checkNotNullParameter((Object)sslSocketFactory, (String)"sslSocketFactory");
        Object obj = context2 = Util.readFieldOrNull(sslSocketFactory, this.paramClass, "sslParameters");
        Intrinsics.checkNotNull(obj);
        X509TrustManager x509TrustManager = Util.readFieldOrNull(obj, X509TrustManager.class, "x509TrustManager");
        X509TrustManager x509TrustManager2 = x509TrustManager;
        if (x509TrustManager2 == null) {
            x509TrustManager2 = Util.readFieldOrNull(context2, X509TrustManager.class, "trustManager");
        }
        return x509TrustManager2;
    }

    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final SocketAdapter buildIfSupported(@NotNull String packageName) {
            SocketAdapter socketAdapter;
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            try {
                Class<?> clazz = Class.forName(packageName + ".OpenSSLSocketImpl");
                Intrinsics.checkNotNull(clazz, (String)"null cannot be cast to non-null type java.lang.Class<in javax.net.ssl.SSLSocket>");
                Class<?> sslSocketClass = clazz;
                Class<?> clazz2 = Class.forName(packageName + ".OpenSSLSocketFactoryImpl");
                Intrinsics.checkNotNull(clazz2, (String)"null cannot be cast to non-null type java.lang.Class<in javax.net.ssl.SSLSocketFactory>");
                Class<?> sslSocketFactoryClass = clazz2;
                Class<?> paramsClass = Class.forName(packageName + ".SSLParametersImpl");
                Intrinsics.checkNotNullExpressionValue(paramsClass, (String)"paramsClass");
                socketAdapter = new StandardAndroidSocketAdapter(sslSocketClass, sslSocketFactoryClass, paramsClass);
            }
            catch (Exception e) {
                Platform.Companion.get().log("unable to load android socket classes", 5, e);
                socketAdapter = null;
            }
            return socketAdapter;
        }

        public static /* synthetic */ SocketAdapter buildIfSupported$default(Companion companion, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = "com.android.org.conscrypt";
            }
            return companion.buildIfSupported(string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

