/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;

public interface FileSystem {
    @NotNull
    public static final Companion Companion = okhttp3.internal.io.FileSystem$Companion.$$INSTANCE;
    @JvmField
    @NotNull
    public static final FileSystem SYSTEM = new Companion.SystemFileSystem();

    @NotNull
    public Source source(@NotNull File var1) throws FileNotFoundException;

    @NotNull
    public Sink sink(@NotNull File var1) throws FileNotFoundException;

    @NotNull
    public Sink appendingSink(@NotNull File var1) throws FileNotFoundException;

    public void delete(@NotNull File var1) throws IOException;

    public boolean exists(@NotNull File var1);

    public long size(@NotNull File var1);

    public void rename(@NotNull File var1, @NotNull File var2) throws IOException;

    public void deleteContents(@NotNull File var1) throws IOException;

    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
        }

        private static final class SystemFileSystem
        implements FileSystem {
            @Override
            @NotNull
            public Source source(@NotNull File file) throws FileNotFoundException {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return Okio.source((File)file);
            }

            @Override
            @NotNull
            public Sink sink(@NotNull File file) throws FileNotFoundException {
                Sink sink;
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                try {
                    sink = Okio.sink$default((File)file, (boolean)false, (int)1, null);
                }
                catch (FileNotFoundException _) {
                    file.getParentFile().mkdirs();
                    sink = Okio.sink$default((File)file, (boolean)false, (int)1, null);
                }
                return sink;
            }

            @Override
            @NotNull
            public Sink appendingSink(@NotNull File file) throws FileNotFoundException {
                Sink sink;
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                try {
                    sink = Okio.appendingSink((File)file);
                }
                catch (FileNotFoundException _) {
                    file.getParentFile().mkdirs();
                    sink = Okio.appendingSink((File)file);
                }
                return sink;
            }

            @Override
            public void delete(@NotNull File file) throws IOException {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                if (!file.delete() && file.exists()) {
                    throw new IOException("failed to delete " + file);
                }
            }

            @Override
            public boolean exists(@NotNull File file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return file.exists();
            }

            @Override
            public long size(@NotNull File file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return file.length();
            }

            @Override
            public void rename(@NotNull File from, @NotNull File to) throws IOException {
                Intrinsics.checkNotNullParameter((Object)from, (String)"from");
                Intrinsics.checkNotNullParameter((Object)to, (String)"to");
                this.delete(to);
                if (!from.renameTo(to)) {
                    throw new IOException("failed to rename " + from + " to " + to);
                }
            }

            @Override
            public void deleteContents(@NotNull File directory) throws IOException {
                Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
                File[] fileArray = directory.listFiles();
                if (fileArray == null) {
                    throw new IOException("not a readable directory: " + directory);
                }
                for (File file : fileArray) {
                    if (file.isDirectory()) {
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                        this.deleteContents(file);
                    }
                    if (file.delete()) continue;
                    throw new IOException("failed to delete " + file);
                }
            }

            @NotNull
            public String toString() {
                return "FileSystem.SYSTEM";
            }
        }
    }
}

