/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import okhttp3.internal.Util;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Hpack;
import okhttp3.internal.http2.Http2;
import okhttp3.internal.http2.Settings;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;

public final class Http2Reader
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BufferedSource source;
    private final boolean client;
    @NotNull
    private final ContinuationSource continuation;
    @NotNull
    private final Hpack.Reader hpackReader;
    @NotNull
    private static final Logger logger;

    public Http2Reader(@NotNull BufferedSource source, boolean client) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = source;
        this.client = client;
        this.continuation = new ContinuationSource(this.source);
        this.hpackReader = new Hpack.Reader(this.continuation, 4096, 0, 4, null);
    }

    public final void readConnectionPreface(@NotNull Handler handler2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        if (this.client) {
            if (!this.nextFrame(true, handler2)) {
                throw new IOException("Required SETTINGS preface not received");
            }
        } else {
            ByteString connectionPreface = this.source.readByteString((long)Http2.CONNECTION_PREFACE.size());
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(Util.format("<< CONNECTION " + connectionPreface.hex(), new Object[0]));
            }
            if (!Intrinsics.areEqual((Object)Http2.CONNECTION_PREFACE, (Object)connectionPreface)) {
                throw new IOException("Expected a connection header but was " + connectionPreface.utf8());
            }
        }
    }

    public final boolean nextFrame(boolean requireSettings, @NotNull Handler handler2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        try {
            this.source.require(9L);
        }
        catch (EOFException e) {
            return false;
        }
        int length = Util.readMedium(this.source);
        if (length > 16384) {
            throw new IOException("FRAME_SIZE_ERROR: " + length);
        }
        int type2 = Util.and(this.source.readByte(), 255);
        int flags = Util.and(this.source.readByte(), 255);
        int streamId = this.source.readInt() & Integer.MAX_VALUE;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(Http2.INSTANCE.frameLog(true, streamId, length, type2, flags));
        }
        if (requireSettings && type2 != 4) {
            throw new IOException("Expected a SETTINGS frame but was " + Http2.INSTANCE.formattedType$okhttp(type2));
        }
        switch (type2) {
            case 0: {
                this.readData(handler2, length, flags, streamId);
                break;
            }
            case 1: {
                this.readHeaders(handler2, length, flags, streamId);
                break;
            }
            case 2: {
                this.readPriority(handler2, length, flags, streamId);
                break;
            }
            case 3: {
                this.readRstStream(handler2, length, flags, streamId);
                break;
            }
            case 4: {
                this.readSettings(handler2, length, flags, streamId);
                break;
            }
            case 5: {
                this.readPushPromise(handler2, length, flags, streamId);
                break;
            }
            case 6: {
                this.readPing(handler2, length, flags, streamId);
                break;
            }
            case 7: {
                this.readGoAway(handler2, length, flags, streamId);
                break;
            }
            case 8: {
                this.readWindowUpdate(handler2, length, flags, streamId);
                break;
            }
            default: {
                this.source.skip((long)length);
            }
        }
        return true;
    }

    private final void readHeaders(Handler handler2, int length, int flags, int streamId) throws IOException {
        if (streamId == 0) {
            throw new IOException("PROTOCOL_ERROR: TYPE_HEADERS streamId == 0");
        }
        boolean endStream = (flags & 1) != 0;
        int padding = (flags & 8) != 0 ? Util.and(this.source.readByte(), 255) : 0;
        int headerBlockLength = length;
        if ((flags & 0x20) != 0) {
            this.readPriority(handler2, streamId);
            headerBlockLength -= 5;
        }
        headerBlockLength = Companion.lengthWithoutPadding(headerBlockLength, flags, padding);
        List<Header> headerBlock = this.readHeaderBlock(headerBlockLength, padding, flags, streamId);
        handler2.headers(endStream, streamId, -1, headerBlock);
    }

    private final List<Header> readHeaderBlock(int length, int padding, int flags, int streamId) throws IOException {
        this.continuation.setLeft(length);
        this.continuation.setLength(this.continuation.getLeft());
        this.continuation.setPadding(padding);
        this.continuation.setFlags(flags);
        this.continuation.setStreamId(streamId);
        this.hpackReader.readHeaders();
        return this.hpackReader.getAndResetHeaderList();
    }

    private final void readData(Handler handler2, int length, int flags, int streamId) throws IOException {
        boolean gzipped;
        if (streamId == 0) {
            throw new IOException("PROTOCOL_ERROR: TYPE_DATA streamId == 0");
        }
        boolean inFinished = (flags & 1) != 0;
        boolean bl = gzipped = (flags & 0x20) != 0;
        if (gzipped) {
            throw new IOException("PROTOCOL_ERROR: FLAG_COMPRESSED without SETTINGS_COMPRESS_DATA");
        }
        int padding = (flags & 8) != 0 ? Util.and(this.source.readByte(), 255) : 0;
        int dataLength = Companion.lengthWithoutPadding(length, flags, padding);
        handler2.data(inFinished, streamId, this.source, dataLength);
        this.source.skip((long)padding);
    }

    private final void readPriority(Handler handler2, int length, int flags, int streamId) throws IOException {
        if (length != 5) {
            throw new IOException("TYPE_PRIORITY length: " + length + " != 5");
        }
        if (streamId == 0) {
            throw new IOException("TYPE_PRIORITY streamId == 0");
        }
        this.readPriority(handler2, streamId);
    }

    private final void readPriority(Handler handler2, int streamId) throws IOException {
        int w1 = this.source.readInt();
        boolean exclusive = (w1 & Integer.MIN_VALUE) != 0;
        int streamDependency = w1 & Integer.MAX_VALUE;
        int weight = Util.and(this.source.readByte(), 255) + 1;
        handler2.priority(streamId, streamDependency, weight, exclusive);
    }

    private final void readRstStream(Handler handler2, int length, int flags, int streamId) throws IOException {
        if (length != 4) {
            throw new IOException("TYPE_RST_STREAM length: " + length + " != 4");
        }
        if (streamId == 0) {
            throw new IOException("TYPE_RST_STREAM streamId == 0");
        }
        int errorCodeInt = this.source.readInt();
        ErrorCode errorCode = ErrorCode.Companion.fromHttp2(errorCodeInt);
        if (errorCode == null) {
            throw new IOException("TYPE_RST_STREAM unexpected error code: " + errorCodeInt);
        }
        ErrorCode errorCode2 = errorCode;
        handler2.rstStream(streamId, errorCode2);
    }

    private final void readSettings(Handler handler2, int length, int flags, int streamId) throws IOException {
        if (streamId != 0) {
            throw new IOException("TYPE_SETTINGS streamId != 0");
        }
        if ((flags & 1) != 0) {
            if (length != 0) {
                throw new IOException("FRAME_SIZE_ERROR ack frame should be empty!");
            }
            handler2.ackSettings();
            return;
        }
        if (length % 6 != 0) {
            throw new IOException("TYPE_SETTINGS length % 6 != 0: " + length);
        }
        Settings settings2 = new Settings();
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)length)), (int)6);
        int i2 = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        if (n2 > 0 && i2 <= n || n2 < 0 && n <= i2) {
            while (true) {
                int id = Util.and(this.source.readShort(), 65535);
                int value2 = this.source.readInt();
                switch (id) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        if (value2 == 0 || value2 == 1) break;
                        throw new IOException("PROTOCOL_ERROR SETTINGS_ENABLE_PUSH != 0 or 1");
                    }
                    case 3: {
                        id = 4;
                        break;
                    }
                    case 4: {
                        id = 7;
                        if (value2 >= 0) break;
                        throw new IOException("PROTOCOL_ERROR SETTINGS_INITIAL_WINDOW_SIZE > 2^31 - 1");
                    }
                    case 5: {
                        if (value2 >= 16384 && value2 <= 0xFFFFFF) break;
                        throw new IOException("PROTOCOL_ERROR SETTINGS_MAX_FRAME_SIZE: " + value2);
                    }
                }
                settings2.set(id, value2);
                if (i2 == n) break;
                i2 += n2;
            }
        }
        handler2.settings(false, settings2);
    }

    private final void readPushPromise(Handler handler2, int length, int flags, int streamId) throws IOException {
        if (streamId == 0) {
            throw new IOException("PROTOCOL_ERROR: TYPE_PUSH_PROMISE streamId == 0");
        }
        int padding = (flags & 8) != 0 ? Util.and(this.source.readByte(), 255) : 0;
        int promisedStreamId = this.source.readInt() & Integer.MAX_VALUE;
        int headerBlockLength = Companion.lengthWithoutPadding(length - 4, flags, padding);
        List<Header> headerBlock = this.readHeaderBlock(headerBlockLength, padding, flags, streamId);
        handler2.pushPromise(streamId, promisedStreamId, headerBlock);
    }

    private final void readPing(Handler handler2, int length, int flags, int streamId) throws IOException {
        if (length != 8) {
            throw new IOException("TYPE_PING length != 8: " + length);
        }
        if (streamId != 0) {
            throw new IOException("TYPE_PING streamId != 0");
        }
        int payload1 = this.source.readInt();
        int payload2 = this.source.readInt();
        boolean ack2 = (flags & 1) != 0;
        handler2.ping(ack2, payload1, payload2);
    }

    private final void readGoAway(Handler handler2, int length, int flags, int streamId) throws IOException {
        if (length < 8) {
            throw new IOException("TYPE_GOAWAY length < 8: " + length);
        }
        if (streamId != 0) {
            throw new IOException("TYPE_GOAWAY streamId != 0");
        }
        int lastStreamId = this.source.readInt();
        int errorCodeInt = this.source.readInt();
        int opaqueDataLength = length - 8;
        ErrorCode errorCode = ErrorCode.Companion.fromHttp2(errorCodeInt);
        if (errorCode == null) {
            throw new IOException("TYPE_GOAWAY unexpected error code: " + errorCodeInt);
        }
        ErrorCode errorCode2 = errorCode;
        ByteString debugData = ByteString.EMPTY;
        if (opaqueDataLength > 0) {
            debugData = this.source.readByteString((long)opaqueDataLength);
        }
        handler2.goAway(lastStreamId, errorCode2, debugData);
    }

    private final void readWindowUpdate(Handler handler2, int length, int flags, int streamId) throws IOException {
        if (length != 4) {
            throw new IOException("TYPE_WINDOW_UPDATE length !=4: " + length);
        }
        long increment = Util.and(this.source.readInt(), Integer.MAX_VALUE);
        if (increment == 0L) {
            throw new IOException("windowSizeIncrement was 0");
        }
        handler2.windowUpdate(streamId, increment);
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }

    static {
        Logger logger = Logger.getLogger(Http2.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(Http2::class.java.name)");
        Http2Reader.logger = logger;
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public final int lengthWithoutPadding(int length, int flags, int padding) throws IOException {
            int result2 = length;
            if ((flags & 8) != 0) {
                --result2;
            }
            if (padding > result2) {
                throw new IOException("PROTOCOL_ERROR padding " + padding + " > remaining length " + result2);
            }
            return result2 -= padding;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public static final class ContinuationSource
    implements Source {
        @NotNull
        private final BufferedSource source;
        private int length;
        private int flags;
        private int streamId;
        private int left;
        private int padding;

        public ContinuationSource(@NotNull BufferedSource source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            this.source = source;
        }

        public final int getLength() {
            return this.length;
        }

        public final void setLength(int n) {
            this.length = n;
        }

        public final int getFlags() {
            return this.flags;
        }

        public final void setFlags(int n) {
            this.flags = n;
        }

        public final int getStreamId() {
            return this.streamId;
        }

        public final void setStreamId(int n) {
            this.streamId = n;
        }

        public final int getLeft() {
            return this.left;
        }

        public final void setLeft(int n) {
            this.left = n;
        }

        public final int getPadding() {
            return this.padding;
        }

        public final void setPadding(int n) {
            this.padding = n;
        }

        public long read(@NotNull Buffer sink, long byteCount) throws IOException {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            while (this.left == 0) {
                this.source.skip((long)this.padding);
                this.padding = 0;
                if ((this.flags & 4) != 0) {
                    return -1L;
                }
                this.readContinuationHeader();
            }
            long read2 = this.source.read(sink, Math.min(byteCount, (long)this.left));
            if (read2 == -1L) {
                return -1L;
            }
            this.left -= (int)read2;
            return read2;
        }

        @NotNull
        public Timeout timeout() {
            return this.source.timeout();
        }

        public void close() throws IOException {
        }

        private final void readContinuationHeader() throws IOException {
            int previousStreamId = this.streamId;
            this.length = this.left = Util.readMedium(this.source);
            int type2 = Util.and(this.source.readByte(), 255);
            this.flags = Util.and(this.source.readByte(), 255);
            if (Companion.getLogger().isLoggable(Level.FINE)) {
                Companion.getLogger().fine(Http2.INSTANCE.frameLog(true, this.streamId, this.length, type2, this.flags));
            }
            this.streamId = this.source.readInt() & Integer.MAX_VALUE;
            if (type2 != 9) {
                throw new IOException(type2 + " != TYPE_CONTINUATION");
            }
            if (this.streamId != previousStreamId) {
                throw new IOException("TYPE_CONTINUATION streamId changed");
            }
        }
    }

    public static interface Handler {
        public void data(boolean var1, int var2, @NotNull BufferedSource var3, int var4) throws IOException;

        public void headers(boolean var1, int var2, int var3, @NotNull List<Header> var4);

        public void rstStream(int var1, @NotNull ErrorCode var2);

        public void settings(boolean var1, @NotNull Settings var2);

        public void ackSettings();

        public void ping(boolean var1, int var2, int var3);

        public void goAway(int var1, @NotNull ErrorCode var2, @NotNull ByteString var3);

        public void windowUpdate(int var1, long var2);

        public void priority(int var1, int var2, int var3, boolean var4);

        public void pushPromise(int var1, int var2, @NotNull List<Header> var3) throws IOException;

        public void alternateService(int var1, @NotNull String var2, @NotNull ByteString var3, @NotNull String var4, int var5, long var6);
    }
}

