/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.IOException;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Util;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.http.RealInterceptorChain;
import okhttp3.internal.http.RequestLine;
import okhttp3.internal.http.StatusLine;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Http2Connection;
import okhttp3.internal.http2.Http2Stream;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Http2ExchangeCodec
implements ExchangeCodec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RealConnection connection;
    @NotNull
    private final RealInterceptorChain chain;
    @NotNull
    private final Http2Connection http2Connection;
    @Nullable
    private volatile Http2Stream stream;
    @NotNull
    private final Protocol protocol;
    private volatile boolean canceled;
    @NotNull
    private static final String CONNECTION = "connection";
    @NotNull
    private static final String HOST = "host";
    @NotNull
    private static final String KEEP_ALIVE = "keep-alive";
    @NotNull
    private static final String PROXY_CONNECTION = "proxy-connection";
    @NotNull
    private static final String TRANSFER_ENCODING = "transfer-encoding";
    @NotNull
    private static final String TE = "te";
    @NotNull
    private static final String ENCODING = "encoding";
    @NotNull
    private static final String UPGRADE = "upgrade";
    @NotNull
    private static final List<String> HTTP_2_SKIPPED_REQUEST_HEADERS;
    @NotNull
    private static final List<String> HTTP_2_SKIPPED_RESPONSE_HEADERS;

    public Http2ExchangeCodec(@NotNull OkHttpClient client, @NotNull RealConnection connection, @NotNull RealInterceptorChain chain, @NotNull Http2Connection http2Connection) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)connection, (String)CONNECTION);
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)http2Connection, (String)"http2Connection");
        this.connection = connection;
        this.chain = chain;
        this.http2Connection = http2Connection;
        this.protocol = client.protocols().contains((Object)Protocol.H2_PRIOR_KNOWLEDGE) ? Protocol.H2_PRIOR_KNOWLEDGE : Protocol.HTTP_2;
    }

    @Override
    @NotNull
    public RealConnection getConnection() {
        return this.connection;
    }

    @Override
    @NotNull
    public Sink createRequestBody(@NotNull Request request2, long contentLength) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Http2Stream http2Stream = this.stream;
        Intrinsics.checkNotNull((Object)http2Stream);
        return http2Stream.getSink();
    }

    @Override
    public void writeRequestHeaders(@NotNull Request request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        if (this.stream != null) {
            return;
        }
        boolean hasRequestBody = request2.body() != null;
        List<Header> requestHeaders = Companion.http2HeadersList(request2);
        this.stream = this.http2Connection.newStream(requestHeaders, hasRequestBody);
        if (this.canceled) {
            Http2Stream http2Stream = this.stream;
            Intrinsics.checkNotNull((Object)http2Stream);
            http2Stream.closeLater(ErrorCode.CANCEL);
            throw new IOException("Canceled");
        }
        Http2Stream http2Stream = this.stream;
        Intrinsics.checkNotNull((Object)http2Stream);
        http2Stream.readTimeout().timeout((long)this.chain.getReadTimeoutMillis$okhttp(), TimeUnit.MILLISECONDS);
        Http2Stream http2Stream2 = this.stream;
        Intrinsics.checkNotNull((Object)http2Stream2);
        http2Stream2.writeTimeout().timeout((long)this.chain.getWriteTimeoutMillis$okhttp(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void flushRequest() {
        this.http2Connection.flush();
    }

    @Override
    public void finishRequest() {
        Http2Stream http2Stream = this.stream;
        Intrinsics.checkNotNull((Object)http2Stream);
        http2Stream.getSink().close();
    }

    @Override
    @Nullable
    public Response.Builder readResponseHeaders(boolean expectContinue) {
        Http2Stream http2Stream = this.stream;
        if (http2Stream == null) {
            throw new IOException("stream wasn't created");
        }
        Http2Stream stream = http2Stream;
        Headers headers2 = stream.takeHeaders();
        Response.Builder responseBuilder = Companion.readHttp2HeadersList(headers2, this.protocol);
        return expectContinue && responseBuilder.getCode$okhttp() == 100 ? null : responseBuilder;
    }

    @Override
    public long reportedContentLength(@NotNull Response response2) {
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        return !HttpHeaders.promisesBody(response2) ? 0L : Util.headersContentLength(response2);
    }

    @Override
    @NotNull
    public Source openResponseBodySource(@NotNull Response response2) {
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Http2Stream http2Stream = this.stream;
        Intrinsics.checkNotNull((Object)http2Stream);
        return http2Stream.getSource$okhttp();
    }

    @Override
    @NotNull
    public Headers trailers() {
        Http2Stream http2Stream = this.stream;
        Intrinsics.checkNotNull((Object)http2Stream);
        return http2Stream.trailers();
    }

    @Override
    public void cancel() {
        block0: {
            this.canceled = true;
            Http2Stream http2Stream = this.stream;
            if (http2Stream == null) break block0;
            http2Stream.closeLater(ErrorCode.CANCEL);
        }
    }

    static {
        String[] stringArray = new String[]{CONNECTION, HOST, KEEP_ALIVE, PROXY_CONNECTION, TE, TRANSFER_ENCODING, ENCODING, UPGRADE, ":method", ":path", ":scheme", ":authority"};
        HTTP_2_SKIPPED_REQUEST_HEADERS = Util.immutableListOf(stringArray);
        stringArray = new String[]{CONNECTION, HOST, KEEP_ALIVE, PROXY_CONNECTION, TE, TRANSFER_ENCODING, ENCODING, UPGRADE};
        HTTP_2_SKIPPED_RESPONSE_HEADERS = Util.immutableListOf(stringArray);
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Header> http2HeadersList(@NotNull Request request2) {
            Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
            Headers headers2 = request2.headers();
            ArrayList<Header> result2 = new ArrayList<Header>(headers2.size() + 4);
            result2.add(new Header(Header.TARGET_METHOD, request2.method()));
            result2.add(new Header(Header.TARGET_PATH, RequestLine.INSTANCE.requestPath(request2.url())));
            String host = request2.header("Host");
            if (host != null) {
                result2.add(new Header(Header.TARGET_AUTHORITY, host));
            }
            result2.add(new Header(Header.TARGET_SCHEME, request2.url().scheme()));
            int n = headers2.size();
            for (int i2 = 0; i2 < n; ++i2) {
                String name2;
                String string = headers2.name(i2);
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                Intrinsics.checkNotNullExpressionValue((Object)string.toLowerCase(locale), (String)"this as java.lang.String).toLowerCase(locale)");
                if (HTTP_2_SKIPPED_REQUEST_HEADERS.contains(name2) && (!Intrinsics.areEqual((Object)name2, (Object)Http2ExchangeCodec.TE) || !Intrinsics.areEqual((Object)headers2.value(i2), (Object)"trailers"))) continue;
                result2.add(new Header(name2, headers2.value(i2)));
            }
            return result2;
        }

        @NotNull
        public final Response.Builder readHttp2HeadersList(@NotNull Headers headerBlock, @NotNull Protocol protocol) {
            Intrinsics.checkNotNullParameter((Object)headerBlock, (String)"headerBlock");
            Intrinsics.checkNotNullParameter((Object)((Object)protocol), (String)"protocol");
            StatusLine statusLine = null;
            Headers.Builder headersBuilder = new Headers.Builder();
            int n = headerBlock.size();
            for (int i2 = 0; i2 < n; ++i2) {
                String name2 = headerBlock.name(i2);
                String value2 = headerBlock.value(i2);
                if (Intrinsics.areEqual((Object)name2, (Object)":status")) {
                    statusLine = StatusLine.Companion.parse("HTTP/1.1 " + value2);
                    continue;
                }
                if (HTTP_2_SKIPPED_RESPONSE_HEADERS.contains(name2)) continue;
                headersBuilder.addLenient$okhttp(name2, value2);
            }
            if (statusLine == null) {
                throw new ProtocolException("Expected ':status' header not present");
            }
            return new Response.Builder().protocol(protocol).code(statusLine.code).message(statusLine.message).headers(headersBuilder.build());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

