/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http1;

import java.io.EOFException;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.util.concurrent.TimeUnit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.CookieJar;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Util;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.http.RequestLine;
import okhttp3.internal.http.StatusLine;
import okhttp3.internal.http1.HeadersReader;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ForwardingTimeout;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nHttp1ExchangeCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http1ExchangeCodec.kt\nokhttp3/internal/http1/Http1ExchangeCodec\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,505:1\n1#2:506\n*E\n"})
public final class Http1ExchangeCodec
implements ExchangeCodec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final OkHttpClient client;
    @NotNull
    private final RealConnection connection;
    @NotNull
    private final BufferedSource source;
    @NotNull
    private final BufferedSink sink;
    private int state;
    @NotNull
    private final HeadersReader headersReader;
    @Nullable
    private Headers trailers;
    private static final long NO_CHUNK_YET = -1L;
    private static final int STATE_IDLE = 0;
    private static final int STATE_OPEN_REQUEST_BODY = 1;
    private static final int STATE_WRITING_REQUEST_BODY = 2;
    private static final int STATE_READ_RESPONSE_HEADERS = 3;
    private static final int STATE_OPEN_RESPONSE_BODY = 4;
    private static final int STATE_READING_RESPONSE_BODY = 5;
    private static final int STATE_CLOSED = 6;

    public Http1ExchangeCodec(@Nullable OkHttpClient client, @NotNull RealConnection connection, @NotNull BufferedSource source, @NotNull BufferedSink sink) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        this.client = client;
        this.connection = connection;
        this.source = source;
        this.sink = sink;
        this.headersReader = new HeadersReader(this.source);
    }

    @Override
    @NotNull
    public RealConnection getConnection() {
        return this.connection;
    }

    private final boolean isChunked(Response $this$isChunked) {
        return StringsKt.equals((String)"chunked", (String)Response.header$default($this$isChunked, "Transfer-Encoding", null, 2, null), (boolean)true);
    }

    private final boolean isChunked(Request $this$isChunked) {
        return StringsKt.equals((String)"chunked", (String)$this$isChunked.header("Transfer-Encoding"), (boolean)true);
    }

    public final boolean isClosed() {
        return this.state == 6;
    }

    @Override
    @NotNull
    public Sink createRequestBody(@NotNull Request request2, long contentLength) {
        Sink sink;
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        if (request2.body() != null && request2.body().isDuplex()) {
            throw new ProtocolException("Duplex connections are not supported for HTTP/1");
        }
        if (this.isChunked(request2)) {
            sink = this.newChunkedSink();
        } else if (contentLength != -1L) {
            sink = this.newKnownLengthSink();
        } else {
            throw new IllegalStateException("Cannot stream a request body without chunked encoding or a known content length!");
        }
        return sink;
    }

    @Override
    public void cancel() {
        this.getConnection().cancel();
    }

    @Override
    public void writeRequestHeaders(@NotNull Request request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Proxy.Type type2 = this.getConnection().route().proxy().type();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)type2), (String)"connection.route().proxy.type()");
        String requestLine = RequestLine.INSTANCE.get(request2, type2);
        this.writeRequest(request2.headers(), requestLine);
    }

    @Override
    public long reportedContentLength(@NotNull Response response2) {
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        return !HttpHeaders.promisesBody(response2) ? 0L : (this.isChunked(response2) ? -1L : Util.headersContentLength(response2));
    }

    @Override
    @NotNull
    public Source openResponseBodySource(@NotNull Response response2) {
        long contentLength;
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        return !HttpHeaders.promisesBody(response2) ? this.newFixedLengthSource(0L) : (this.isChunked(response2) ? this.newChunkedSource(response2.request().url()) : ((contentLength = Util.headersContentLength(response2)) != -1L ? this.newFixedLengthSource(contentLength) : this.newUnknownLengthSource()));
    }

    @Override
    @NotNull
    public Headers trailers() {
        if (!(this.state == 6)) {
            boolean bl = false;
            String string = "too early; can't read the trailers yet";
            throw new IllegalStateException(string.toString());
        }
        Headers headers2 = this.trailers;
        if (headers2 == null) {
            headers2 = Util.EMPTY_HEADERS;
        }
        return headers2;
    }

    @Override
    public void flushRequest() {
        this.sink.flush();
    }

    @Override
    public void finishRequest() {
        this.sink.flush();
    }

    public final void writeRequest(@NotNull Headers headers2, @NotNull String requestLine) {
        Intrinsics.checkNotNullParameter((Object)headers2, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)requestLine, (String)"requestLine");
        if (!(this.state == 0)) {
            boolean bl = false;
            String string = "state: " + this.state;
            throw new IllegalStateException(string.toString());
        }
        this.sink.writeUtf8(requestLine).writeUtf8("\r\n");
        int n = headers2.size();
        for (int i2 = 0; i2 < n; ++i2) {
            this.sink.writeUtf8(headers2.name(i2)).writeUtf8(": ").writeUtf8(headers2.value(i2)).writeUtf8("\r\n");
        }
        this.sink.writeUtf8("\r\n");
        this.state = 1;
    }

    @Override
    @Nullable
    public Response.Builder readResponseHeaders(boolean expectContinue) {
        if (!(this.state == 1 || this.state == 2 || this.state == 3)) {
            boolean $i$a$-check-Http1ExchangeCodec$readResponseHeaders$22 = false;
            String $i$a$-check-Http1ExchangeCodec$readResponseHeaders$22 = "state: " + this.state;
            throw new IllegalStateException($i$a$-check-Http1ExchangeCodec$readResponseHeaders$22.toString());
        }
        try {
            Response.Builder builder;
            StatusLine statusLine = StatusLine.Companion.parse(this.headersReader.readLine());
            Response.Builder responseBuilder = new Response.Builder().protocol(statusLine.protocol).code(statusLine.code).message(statusLine.message).headers(this.headersReader.readHeaders());
            if (expectContinue && statusLine.code == 100) {
                builder = null;
            } else if (statusLine.code == 100) {
                this.state = 3;
                builder = responseBuilder;
            } else {
                int n = statusLine.code;
                boolean bl = 102 <= n ? n < 200 : false;
                if (bl) {
                    this.state = 3;
                    builder = responseBuilder;
                } else {
                    this.state = 4;
                    builder = responseBuilder;
                }
            }
            return builder;
        }
        catch (EOFException e) {
            String address = this.getConnection().route().address().url().redact();
            throw new IOException("unexpected end of stream on " + address, e);
        }
    }

    private final Sink newChunkedSink() {
        if (!(this.state == 1)) {
            boolean bl = false;
            String string = "state: " + this.state;
            throw new IllegalStateException(string.toString());
        }
        this.state = 2;
        return new ChunkedSink();
    }

    private final Sink newKnownLengthSink() {
        if (!(this.state == 1)) {
            boolean bl = false;
            String string = "state: " + this.state;
            throw new IllegalStateException(string.toString());
        }
        this.state = 2;
        return new KnownLengthSink();
    }

    private final Source newFixedLengthSource(long length) {
        if (!(this.state == 4)) {
            boolean bl = false;
            String string = "state: " + this.state;
            throw new IllegalStateException(string.toString());
        }
        this.state = 5;
        return new FixedLengthSource(length);
    }

    private final Source newChunkedSource(HttpUrl url) {
        if (!(this.state == 4)) {
            boolean bl = false;
            String string = "state: " + this.state;
            throw new IllegalStateException(string.toString());
        }
        this.state = 5;
        return new ChunkedSource(url);
    }

    private final Source newUnknownLengthSource() {
        if (!(this.state == 4)) {
            boolean bl = false;
            String string = "state: " + this.state;
            throw new IllegalStateException(string.toString());
        }
        this.state = 5;
        this.getConnection().noNewExchanges$okhttp();
        return new UnknownLengthSource();
    }

    private final void detachTimeout(ForwardingTimeout timeout2) {
        Timeout oldDelegate = timeout2.delegate();
        timeout2.setDelegate(Timeout.NONE);
        oldDelegate.clearDeadline();
        oldDelegate.clearTimeout();
    }

    public final void skipConnectBody(@NotNull Response response2) {
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        long contentLength = Util.headersContentLength(response2);
        if (contentLength == -1L) {
            return;
        }
        Source body = this.newFixedLengthSource(contentLength);
        Util.skipAll(body, Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
        body.close();
    }

    private abstract class AbstractSource
    implements Source {
        @NotNull
        private final ForwardingTimeout timeout;
        private boolean closed;

        public AbstractSource() {
            this.timeout = new ForwardingTimeout(Http1ExchangeCodec.this.source.timeout());
        }

        @NotNull
        protected final ForwardingTimeout getTimeout() {
            return this.timeout;
        }

        protected final boolean getClosed() {
            return this.closed;
        }

        protected final void setClosed(boolean bl) {
            this.closed = bl;
        }

        @NotNull
        public Timeout timeout() {
            return (Timeout)this.timeout;
        }

        public long read(@NotNull Buffer sink, long byteCount) {
            long l;
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            try {
                l = Http1ExchangeCodec.this.source.read(sink, byteCount);
            }
            catch (IOException e) {
                Http1ExchangeCodec.this.getConnection().noNewExchanges$okhttp();
                this.responseBodyComplete();
                throw e;
            }
            return l;
        }

        public final void responseBodyComplete() {
            if (Http1ExchangeCodec.this.state == 6) {
                return;
            }
            if (Http1ExchangeCodec.this.state != 5) {
                throw new IllegalStateException("state: " + Http1ExchangeCodec.this.state);
            }
            Http1ExchangeCodec.this.detachTimeout(this.timeout);
            Http1ExchangeCodec.this.state = 6;
        }
    }

    @SourceDebugExtension(value={"SMAP\nHttp1ExchangeCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http1ExchangeCodec.kt\nokhttp3/internal/http1/Http1ExchangeCodec$ChunkedSink\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,505:1\n1#2:506\n*E\n"})
    private final class ChunkedSink
    implements Sink {
        @NotNull
        private final ForwardingTimeout timeout;
        private boolean closed;

        public ChunkedSink() {
            this.timeout = new ForwardingTimeout(Http1ExchangeCodec.this.sink.timeout());
        }

        @NotNull
        public Timeout timeout() {
            return (Timeout)this.timeout;
        }

        public void write(@NotNull Buffer source, long byteCount) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            if (!(!this.closed)) {
                boolean bl = false;
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            if (byteCount == 0L) {
                return;
            }
            Http1ExchangeCodec.this.sink.writeHexadecimalUnsignedLong(byteCount);
            Http1ExchangeCodec.this.sink.writeUtf8("\r\n");
            Http1ExchangeCodec.this.sink.write(source, byteCount);
            Http1ExchangeCodec.this.sink.writeUtf8("\r\n");
        }

        public synchronized void flush() {
            if (this.closed) {
                return;
            }
            Http1ExchangeCodec.this.sink.flush();
        }

        public synchronized void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            Http1ExchangeCodec.this.sink.writeUtf8("0\r\n\r\n");
            Http1ExchangeCodec.this.detachTimeout(this.timeout);
            Http1ExchangeCodec.this.state = 3;
        }
    }

    @SourceDebugExtension(value={"SMAP\nHttp1ExchangeCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http1ExchangeCodec.kt\nokhttp3/internal/http1/Http1ExchangeCodec$ChunkedSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,505:1\n1#2:506\n*E\n"})
    private final class ChunkedSource
    extends AbstractSource {
        @NotNull
        private final HttpUrl url;
        private long bytesRemainingInChunk;
        private boolean hasMoreChunks;

        public ChunkedSource(HttpUrl url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.url = url;
            this.bytesRemainingInChunk = -1L;
            this.hasMoreChunks = true;
        }

        @Override
        public long read(@NotNull Buffer sink, long byteCount) {
            long read2;
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            if (!(byteCount >= 0L)) {
                boolean $i$a$-require-Http1ExchangeCodec$ChunkedSource$read$22 = false;
                String $i$a$-require-Http1ExchangeCodec$ChunkedSource$read$22 = "byteCount < 0: " + byteCount;
                throw new IllegalArgumentException($i$a$-require-Http1ExchangeCodec$ChunkedSource$read$22.toString());
            }
            if (!(!this.getClosed())) {
                boolean bl = false;
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            if (!this.hasMoreChunks) {
                return -1L;
            }
            if (this.bytesRemainingInChunk == 0L || this.bytesRemainingInChunk == -1L) {
                this.readChunkSize();
                if (!this.hasMoreChunks) {
                    return -1L;
                }
            }
            if ((read2 = super.read(sink, Math.min(byteCount, this.bytesRemainingInChunk))) == -1L) {
                Http1ExchangeCodec.this.getConnection().noNewExchanges$okhttp();
                ProtocolException e = new ProtocolException("unexpected end of stream");
                this.responseBodyComplete();
                throw e;
            }
            this.bytesRemainingInChunk -= read2;
            return read2;
        }

        private final void readChunkSize() {
            if (this.bytesRemainingInChunk != -1L) {
                Http1ExchangeCodec.this.source.readUtf8LineStrict();
            }
            try {
                this.bytesRemainingInChunk = Http1ExchangeCodec.this.source.readHexadecimalUnsignedLong();
                String extensions = ((Object)StringsKt.trim((CharSequence)Http1ExchangeCodec.this.source.readUtf8LineStrict())).toString();
                if (this.bytesRemainingInChunk < 0L || ((CharSequence)extensions).length() > 0 && !StringsKt.startsWith$default((String)extensions, (String)";", (boolean)false, (int)2, null)) {
                    throw new ProtocolException("expected chunk size and optional extensions but was \"" + this.bytesRemainingInChunk + extensions + '\"');
                }
            }
            catch (NumberFormatException e) {
                throw new ProtocolException(e.getMessage());
            }
            if (this.bytesRemainingInChunk == 0L) {
                this.hasMoreChunks = false;
                Http1ExchangeCodec.this.trailers = Http1ExchangeCodec.this.headersReader.readHeaders();
                OkHttpClient okHttpClient = Http1ExchangeCodec.this.client;
                Intrinsics.checkNotNull((Object)okHttpClient);
                CookieJar cookieJar2 = okHttpClient.cookieJar();
                Headers headers2 = Http1ExchangeCodec.this.trailers;
                Intrinsics.checkNotNull((Object)headers2);
                HttpHeaders.receiveHeaders(cookieJar2, this.url, headers2);
                this.responseBodyComplete();
            }
        }

        public void close() {
            if (this.getClosed()) {
                return;
            }
            if (this.hasMoreChunks && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
                Http1ExchangeCodec.this.getConnection().noNewExchanges$okhttp();
                this.responseBodyComplete();
            }
            this.setClosed(true);
        }
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @SourceDebugExtension(value={"SMAP\nHttp1ExchangeCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http1ExchangeCodec.kt\nokhttp3/internal/http1/Http1ExchangeCodec$FixedLengthSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,505:1\n1#2:506\n*E\n"})
    private final class FixedLengthSource
    extends AbstractSource {
        private long bytesRemaining;

        public FixedLengthSource(long bytesRemaining) {
            this.bytesRemaining = bytesRemaining;
            if (this.bytesRemaining == 0L) {
                this.responseBodyComplete();
            }
        }

        @Override
        public long read(@NotNull Buffer sink, long byteCount) {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            if (!(byteCount >= 0L)) {
                boolean $i$a$-require-Http1ExchangeCodec$FixedLengthSource$read$22 = false;
                String $i$a$-require-Http1ExchangeCodec$FixedLengthSource$read$22 = "byteCount < 0: " + byteCount;
                throw new IllegalArgumentException($i$a$-require-Http1ExchangeCodec$FixedLengthSource$read$22.toString());
            }
            if (!(!this.getClosed())) {
                boolean bl = false;
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            if (this.bytesRemaining == 0L) {
                return -1L;
            }
            long read2 = super.read(sink, Math.min(this.bytesRemaining, byteCount));
            if (read2 == -1L) {
                Http1ExchangeCodec.this.getConnection().noNewExchanges$okhttp();
                ProtocolException e = new ProtocolException("unexpected end of stream");
                this.responseBodyComplete();
                throw e;
            }
            this.bytesRemaining -= read2;
            if (this.bytesRemaining == 0L) {
                this.responseBodyComplete();
            }
            return read2;
        }

        public void close() {
            if (this.getClosed()) {
                return;
            }
            if (this.bytesRemaining != 0L && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
                Http1ExchangeCodec.this.getConnection().noNewExchanges$okhttp();
                this.responseBodyComplete();
            }
            this.setClosed(true);
        }
    }

    @SourceDebugExtension(value={"SMAP\nHttp1ExchangeCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http1ExchangeCodec.kt\nokhttp3/internal/http1/Http1ExchangeCodec$KnownLengthSink\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,505:1\n1#2:506\n*E\n"})
    private final class KnownLengthSink
    implements Sink {
        @NotNull
        private final ForwardingTimeout timeout;
        private boolean closed;

        public KnownLengthSink() {
            this.timeout = new ForwardingTimeout(Http1ExchangeCodec.this.sink.timeout());
        }

        @NotNull
        public Timeout timeout() {
            return (Timeout)this.timeout;
        }

        public void write(@NotNull Buffer source, long byteCount) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            if (!(!this.closed)) {
                boolean bl = false;
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            Util.checkOffsetAndCount(source.size(), 0L, byteCount);
            Http1ExchangeCodec.this.sink.write(source, byteCount);
        }

        public void flush() {
            if (this.closed) {
                return;
            }
            Http1ExchangeCodec.this.sink.flush();
        }

        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            Http1ExchangeCodec.this.detachTimeout(this.timeout);
            Http1ExchangeCodec.this.state = 3;
        }
    }

    @SourceDebugExtension(value={"SMAP\nHttp1ExchangeCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http1ExchangeCodec.kt\nokhttp3/internal/http1/Http1ExchangeCodec$UnknownLengthSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,505:1\n1#2:506\n*E\n"})
    private final class UnknownLengthSource
    extends AbstractSource {
        private boolean inputExhausted;

        @Override
        public long read(@NotNull Buffer sink, long byteCount) {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            if (!(byteCount >= 0L)) {
                boolean $i$a$-require-Http1ExchangeCodec$UnknownLengthSource$read$22 = false;
                String $i$a$-require-Http1ExchangeCodec$UnknownLengthSource$read$22 = "byteCount < 0: " + byteCount;
                throw new IllegalArgumentException($i$a$-require-Http1ExchangeCodec$UnknownLengthSource$read$22.toString());
            }
            if (!(!this.getClosed())) {
                boolean bl = false;
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            if (this.inputExhausted) {
                return -1L;
            }
            long read2 = super.read(sink, byteCount);
            if (read2 == -1L) {
                this.inputExhausted = true;
                this.responseBodyComplete();
                return -1L;
            }
            return read2;
        }

        public void close() {
            if (this.getClosed()) {
                return;
            }
            if (!this.inputExhausted) {
                this.responseBodyComplete();
            }
            this.setClosed(true);
        }
    }
}

