/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal;

import java.net.IDN;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Locale;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.internal.Util;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HostnamesKt {
    @Nullable
    public static final String toCanonicalHost(@NotNull String $this$toCanonicalHost) {
        Intrinsics.checkNotNullParameter((Object)$this$toCanonicalHost, (String)"<this>");
        String host = $this$toCanonicalHost;
        if (StringsKt.contains$default((CharSequence)host, (CharSequence)":", (boolean)false, (int)2, null)) {
            InetAddress inetAddress = StringsKt.startsWith$default((String)host, (String)"[", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)host, (String)"]", (boolean)false, (int)2, null) ? HostnamesKt.decodeIpv6(host, 1, host.length() - 1) : HostnamesKt.decodeIpv6(host, 0, host.length());
            if (inetAddress == null) {
                return null;
            }
            InetAddress inetAddress2 = inetAddress;
            byte[] address = inetAddress2.getAddress();
            if (address.length == 16) {
                Intrinsics.checkNotNullExpressionValue((Object)address, (String)"address");
                return HostnamesKt.inet6AddressToAscii(address);
            }
            if (address.length == 4) {
                return inetAddress2.getHostAddress();
            }
            throw new AssertionError((Object)("Invalid IPv6 address: '" + host + '\''));
        }
        try {
            String string = IDN.toASCII(host);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toASCII(host)");
            String string2 = string;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string3 = string2.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
            String result2 = string3;
            if (((CharSequence)result2).length() == 0) {
                return null;
            }
            return HostnamesKt.containsInvalidHostnameAsciiCodes(result2) ? null : result2;
        }
        catch (IllegalArgumentException _) {
            return null;
        }
    }

    private static final boolean containsInvalidHostnameAsciiCodes(String $this$containsInvalidHostnameAsciiCodes) {
        int n = $this$containsInvalidHostnameAsciiCodes.length();
        for (int i2 = 0; i2 < n; ++i2) {
            char c = $this$containsInvalidHostnameAsciiCodes.charAt(i2);
            if (Intrinsics.compare((int)c, (int)31) <= 0 || Intrinsics.compare((int)c, (int)127) >= 0) {
                return true;
            }
            if (StringsKt.indexOf$default((CharSequence)" #%/:?@[\\]", (char)c, (int)0, (boolean)false, (int)6, null) == -1) continue;
            return true;
        }
        return false;
    }

    private static final InetAddress decodeIpv6(String input, int pos, int limit) {
        byte[] address = new byte[16];
        int b = 0;
        int compress = -1;
        int groupOffset = -1;
        int i2 = pos;
        while (i2 < limit) {
            int hexDigit;
            if (b == address.length) {
                return null;
            }
            if (i2 + 2 <= limit && StringsKt.startsWith$default((String)input, (String)"::", (int)i2, (boolean)false, (int)4, null)) {
                if (compress != -1) {
                    return null;
                }
                compress = b += 2;
                if ((i2 += 2) == limit) {
                    break;
                }
            } else if (b != 0 && !StringsKt.startsWith$default((String)input, (String)":", (int)i2, (boolean)false, (int)4, null)) {
                if (StringsKt.startsWith$default((String)input, (String)".", (int)i2, (boolean)false, (int)4, null)) {
                    if (!HostnamesKt.decodeIpv4Suffix(input, groupOffset, limit, address, b - 2)) {
                        return null;
                    }
                    b += 2;
                    break;
                }
                return null;
            }
            int value2 = 0;
            groupOffset = ++i2;
            while (i2 < limit && (hexDigit = Util.parseHexDigit(input.charAt(i2))) != -1) {
                value2 = (value2 << 4) + hexDigit;
                ++i2;
            }
            int groupLength = i2 - groupOffset;
            if (groupLength == 0 || groupLength > 4) {
                return null;
            }
            address[b++] = (byte)(value2 >>> 8 & 0xFF);
            address[b++] = (byte)(value2 & 0xFF);
        }
        if (b != address.length) {
            if (compress == -1) {
                return null;
            }
            System.arraycopy(address, compress, address, address.length - (b - compress), b - compress);
            Arrays.fill(address, compress, compress + (address.length - b), (byte)0);
        }
        return InetAddress.getByAddress(address);
    }

    private static final boolean decodeIpv4Suffix(String input, int pos, int limit, byte[] address, int addressOffset) {
        int b = addressOffset;
        int i2 = pos;
        while (i2 < limit) {
            char c;
            if (b == address.length) {
                return false;
            }
            if (b != addressOffset && input.charAt(i2) != '.') {
                return false;
            }
            int value2 = 0;
            int groupOffset = ++i2;
            while (i2 < limit && Intrinsics.compare((int)(c = input.charAt(i2)), (int)48) >= 0 && Intrinsics.compare((int)c, (int)57) <= 0) {
                if (value2 == 0 && groupOffset != i2) {
                    return false;
                }
                if ((value2 = value2 * 10 + c - 48) > 255) {
                    return false;
                }
                ++i2;
            }
            int groupLength = i2 - groupOffset;
            if (groupLength == 0) {
                return false;
            }
            address[b++] = (byte)value2;
        }
        return b == addressOffset + 4;
    }

    private static final String inet6AddressToAscii(byte[] address) {
        int i2;
        int longestRunOffset = 0;
        longestRunOffset = -1;
        int longestRunLength = 0;
        boolean bl = false;
        for (i2 = 0; i2 < address.length; i2 += 2) {
            int currentRunOffset = i2;
            while (i2 < 16 && address[i2] == 0 && address[i2 + 1] == 0) {
                i2 += 2;
            }
            int currentRunLength = i2 - currentRunOffset;
            if (currentRunLength <= longestRunLength || currentRunLength < 4) continue;
            longestRunOffset = currentRunOffset;
            longestRunLength = currentRunLength;
        }
        Buffer result2 = new Buffer();
        i2 = 0;
        while (i2 < address.length) {
            if (i2 == longestRunOffset) {
                result2.writeByte(58);
                if ((i2 += longestRunLength) != 16) continue;
                result2.writeByte(58);
                continue;
            }
            if (i2 > 0) {
                result2.writeByte(58);
            }
            int group = Util.and(address[i2], 255) << 8 | Util.and(address[i2 + 1], 255);
            result2.writeHexadecimalUnsignedLong((long)group);
            i2 += 2;
        }
        return result2.readUtf8();
    }
}

