/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.ReplaceWith;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import okhttp3.MediaType;
import okhttp3.internal.Util;
import okio.BufferedSink;
import okio.ByteString;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RequestBody {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public abstract MediaType contentType();

    public long contentLength() throws IOException {
        return -1L;
    }

    public abstract void writeTo(@NotNull BufferedSink var1) throws IOException;

    public boolean isDuplex() {
        return false;
    }

    public boolean isOneShot() {
        return false;
    }

    @JvmStatic
    @JvmName(name="create")
    @NotNull
    public static final RequestBody create(@NotNull String $this$create, @Nullable MediaType contentType) {
        return Companion.create($this$create, contentType);
    }

    @JvmStatic
    @JvmName(name="create")
    @NotNull
    public static final RequestBody create(@NotNull ByteString $this$create, @Nullable MediaType contentType) {
        return Companion.create($this$create, contentType);
    }

    @JvmStatic
    @JvmOverloads
    @JvmName(name="create")
    @NotNull
    public static final RequestBody create(@NotNull byte[] $this$create, @Nullable MediaType contentType, int offset, int byteCount) {
        return Companion.create($this$create, contentType, offset, byteCount);
    }

    @JvmStatic
    @JvmName(name="create")
    @NotNull
    public static final RequestBody create(@NotNull File $this$create, @Nullable MediaType contentType) {
        return Companion.create($this$create, contentType);
    }

    @JvmStatic
    @Deprecated(message="Moved to extension function. Put the 'content' argument first to fix Java", replaceWith=@ReplaceWith(expression="content.toRequestBody(contentType)", imports={"okhttp3.RequestBody.Companion.toRequestBody"}), level=DeprecationLevel.WARNING)
    @NotNull
    public static final RequestBody create(@Nullable MediaType contentType, @NotNull String content2) {
        return Companion.create(contentType, content2);
    }

    @JvmStatic
    @Deprecated(message="Moved to extension function. Put the 'content' argument first to fix Java", replaceWith=@ReplaceWith(expression="content.toRequestBody(contentType)", imports={"okhttp3.RequestBody.Companion.toRequestBody"}), level=DeprecationLevel.WARNING)
    @NotNull
    public static final RequestBody create(@Nullable MediaType contentType, @NotNull ByteString content2) {
        return Companion.create(contentType, content2);
    }

    @JvmStatic
    @Deprecated(message="Moved to extension function. Put the 'content' argument first to fix Java", replaceWith=@ReplaceWith(expression="content.toRequestBody(contentType, offset, byteCount)", imports={"okhttp3.RequestBody.Companion.toRequestBody"}), level=DeprecationLevel.WARNING)
    @JvmOverloads
    @NotNull
    public static final RequestBody create(@Nullable MediaType contentType, @NotNull byte[] content2, int offset, int byteCount) {
        return Companion.create(contentType, content2, offset, byteCount);
    }

    @JvmStatic
    @Deprecated(message="Moved to extension function. Put the 'file' argument first to fix Java", replaceWith=@ReplaceWith(expression="file.asRequestBody(contentType)", imports={"okhttp3.RequestBody.Companion.asRequestBody"}), level=DeprecationLevel.WARNING)
    @NotNull
    public static final RequestBody create(@Nullable MediaType contentType, @NotNull File file) {
        return Companion.create(contentType, file);
    }

    @JvmStatic
    @JvmOverloads
    @JvmName(name="create")
    @NotNull
    public static final RequestBody create(@NotNull byte[] $this$create, @Nullable MediaType contentType, int offset) {
        return Companion.create($this$create, contentType, offset);
    }

    @JvmStatic
    @JvmOverloads
    @JvmName(name="create")
    @NotNull
    public static final RequestBody create(@NotNull byte[] $this$create, @Nullable MediaType contentType) {
        return Companion.create($this$create, contentType);
    }

    @JvmStatic
    @JvmOverloads
    @JvmName(name="create")
    @NotNull
    public static final RequestBody create(@NotNull byte[] $this$create) {
        return Companion.create($this$create);
    }

    @JvmStatic
    @Deprecated(message="Moved to extension function. Put the 'content' argument first to fix Java", replaceWith=@ReplaceWith(expression="content.toRequestBody(contentType, offset, byteCount)", imports={"okhttp3.RequestBody.Companion.toRequestBody"}), level=DeprecationLevel.WARNING)
    @JvmOverloads
    @NotNull
    public static final RequestBody create(@Nullable MediaType contentType, @NotNull byte[] content2, int offset) {
        return Companion.create(contentType, content2, offset);
    }

    @JvmStatic
    @Deprecated(message="Moved to extension function. Put the 'content' argument first to fix Java", replaceWith=@ReplaceWith(expression="content.toRequestBody(contentType, offset, byteCount)", imports={"okhttp3.RequestBody.Companion.toRequestBody"}), level=DeprecationLevel.WARNING)
    @JvmOverloads
    @NotNull
    public static final RequestBody create(@Nullable MediaType contentType, @NotNull byte[] content2) {
        return Companion.create(contentType, content2);
    }

    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmName(name="create")
        @NotNull
        public final RequestBody create(@NotNull String $this$toRequestBody, @Nullable MediaType contentType) {
            Intrinsics.checkNotNullParameter((Object)$this$toRequestBody, (String)"<this>");
            Charset charset = Charsets.UTF_8;
            MediaType finalContentType = contentType;
            if (contentType != null) {
                Charset resolvedCharset = MediaType.charset$default(contentType, null, 1, null);
                if (resolvedCharset == null) {
                    charset = Charsets.UTF_8;
                    finalContentType = MediaType.Companion.parse(contentType + "; charset=utf-8");
                } else {
                    charset = resolvedCharset;
                }
            }
            byte[] byArray = $this$toRequestBody.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            byte[] bytes2 = byArray;
            return this.create(bytes2, finalContentType, 0, bytes2.length);
        }

        public static /* synthetic */ RequestBody create$default(Companion companion, String string, MediaType mediaType, int n, Object object) {
            if ((n & 1) != 0) {
                mediaType = null;
            }
            return companion.create(string, mediaType);
        }

        @JvmStatic
        @JvmName(name="create")
        @NotNull
        public final RequestBody create(@NotNull ByteString $this$toRequestBody, @Nullable MediaType contentType) {
            Intrinsics.checkNotNullParameter((Object)$this$toRequestBody, (String)"<this>");
            return new RequestBody(contentType, $this$toRequestBody){
                final /* synthetic */ MediaType $contentType;
                final /* synthetic */ ByteString $this_toRequestBody;
                {
                    this.$contentType = $contentType;
                    this.$this_toRequestBody = $receiver;
                }

                @Nullable
                public MediaType contentType() {
                    return this.$contentType;
                }

                public long contentLength() {
                    return this.$this_toRequestBody.size();
                }

                public void writeTo(@NotNull BufferedSink sink) {
                    Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                    sink.write(this.$this_toRequestBody);
                }
            };
        }

        public static /* synthetic */ RequestBody create$default(Companion companion, ByteString byteString, MediaType mediaType, int n, Object object) {
            if ((n & 1) != 0) {
                mediaType = null;
            }
            return companion.create(byteString, mediaType);
        }

        @JvmStatic
        @JvmOverloads
        @JvmName(name="create")
        @NotNull
        public final RequestBody create(@NotNull byte[] $this$toRequestBody, @Nullable MediaType contentType, int offset, int byteCount) {
            Intrinsics.checkNotNullParameter((Object)$this$toRequestBody, (String)"<this>");
            Util.checkOffsetAndCount($this$toRequestBody.length, offset, byteCount);
            return new RequestBody(contentType, byteCount, $this$toRequestBody, offset){
                final /* synthetic */ MediaType $contentType;
                final /* synthetic */ int $byteCount;
                final /* synthetic */ byte[] $this_toRequestBody;
                final /* synthetic */ int $offset;
                {
                    this.$contentType = $contentType;
                    this.$byteCount = $byteCount;
                    this.$this_toRequestBody = $receiver;
                    this.$offset = $offset;
                }

                @Nullable
                public MediaType contentType() {
                    return this.$contentType;
                }

                public long contentLength() {
                    return this.$byteCount;
                }

                public void writeTo(@NotNull BufferedSink sink) {
                    Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                    sink.write(this.$this_toRequestBody, this.$offset, this.$byteCount);
                }
            };
        }

        public static /* synthetic */ RequestBody create$default(Companion companion, byte[] byArray, MediaType mediaType, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                mediaType = null;
            }
            if ((n3 & 2) != 0) {
                n = 0;
            }
            if ((n3 & 4) != 0) {
                n2 = byArray.length;
            }
            return companion.create(byArray, mediaType, n, n2);
        }

        @JvmStatic
        @JvmName(name="create")
        @NotNull
        public final RequestBody create(@NotNull File $this$asRequestBody, @Nullable MediaType contentType) {
            Intrinsics.checkNotNullParameter((Object)$this$asRequestBody, (String)"<this>");
            return new RequestBody(contentType, $this$asRequestBody){
                final /* synthetic */ MediaType $contentType;
                final /* synthetic */ File $this_asRequestBody;
                {
                    this.$contentType = $contentType;
                    this.$this_asRequestBody = $receiver;
                }

                @Nullable
                public MediaType contentType() {
                    return this.$contentType;
                }

                public long contentLength() {
                    return this.$this_asRequestBody.length();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void writeTo(@NotNull BufferedSink sink) {
                    Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                    Closeable closeable = (Closeable)Okio.source((File)this.$this_asRequestBody);
                    Throwable throwable = null;
                    try {
                        Source source = (Source)closeable;
                        boolean bl = false;
                        long l = sink.writeAll(source);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
            };
        }

        public static /* synthetic */ RequestBody create$default(Companion companion, File file, MediaType mediaType, int n, Object object) {
            if ((n & 1) != 0) {
                mediaType = null;
            }
            return companion.create(file, mediaType);
        }

        @JvmStatic
        @Deprecated(message="Moved to extension function. Put the 'content' argument first to fix Java", replaceWith=@ReplaceWith(expression="content.toRequestBody(contentType)", imports={"okhttp3.RequestBody.Companion.toRequestBody"}), level=DeprecationLevel.WARNING)
        @NotNull
        public final RequestBody create(@Nullable MediaType contentType, @NotNull String content2) {
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            return this.create(content2, contentType);
        }

        @JvmStatic
        @Deprecated(message="Moved to extension function. Put the 'content' argument first to fix Java", replaceWith=@ReplaceWith(expression="content.toRequestBody(contentType)", imports={"okhttp3.RequestBody.Companion.toRequestBody"}), level=DeprecationLevel.WARNING)
        @NotNull
        public final RequestBody create(@Nullable MediaType contentType, @NotNull ByteString content2) {
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            return this.create(content2, contentType);
        }

        @JvmStatic
        @Deprecated(message="Moved to extension function. Put the 'content' argument first to fix Java", replaceWith=@ReplaceWith(expression="content.toRequestBody(contentType, offset, byteCount)", imports={"okhttp3.RequestBody.Companion.toRequestBody"}), level=DeprecationLevel.WARNING)
        @JvmOverloads
        @NotNull
        public final RequestBody create(@Nullable MediaType contentType, @NotNull byte[] content2, int offset, int byteCount) {
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            return this.create(content2, contentType, offset, byteCount);
        }

        public static /* synthetic */ RequestBody create$default(Companion companion, MediaType mediaType, byte[] byArray, int n, int n2, int n3, Object object) {
            if ((n3 & 4) != 0) {
                n = 0;
            }
            if ((n3 & 8) != 0) {
                n2 = byArray.length;
            }
            return companion.create(mediaType, byArray, n, n2);
        }

        @JvmStatic
        @Deprecated(message="Moved to extension function. Put the 'file' argument first to fix Java", replaceWith=@ReplaceWith(expression="file.asRequestBody(contentType)", imports={"okhttp3.RequestBody.Companion.asRequestBody"}), level=DeprecationLevel.WARNING)
        @NotNull
        public final RequestBody create(@Nullable MediaType contentType, @NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return this.create(file, contentType);
        }

        @JvmStatic
        @JvmOverloads
        @JvmName(name="create")
        @NotNull
        public final RequestBody create(@NotNull byte[] $this$toRequestBody, @Nullable MediaType contentType, int offset) {
            Intrinsics.checkNotNullParameter((Object)$this$toRequestBody, (String)"<this>");
            return okhttp3.RequestBody$Companion.create$default(this, $this$toRequestBody, contentType, offset, 0, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        @JvmName(name="create")
        @NotNull
        public final RequestBody create(@NotNull byte[] $this$toRequestBody, @Nullable MediaType contentType) {
            Intrinsics.checkNotNullParameter((Object)$this$toRequestBody, (String)"<this>");
            return okhttp3.RequestBody$Companion.create$default(this, $this$toRequestBody, contentType, 0, 0, 6, null);
        }

        @JvmStatic
        @JvmOverloads
        @JvmName(name="create")
        @NotNull
        public final RequestBody create(@NotNull byte[] $this$toRequestBody) {
            Intrinsics.checkNotNullParameter((Object)$this$toRequestBody, (String)"<this>");
            return okhttp3.RequestBody$Companion.create$default(this, $this$toRequestBody, null, 0, 0, 7, null);
        }

        @JvmStatic
        @Deprecated(message="Moved to extension function. Put the 'content' argument first to fix Java", replaceWith=@ReplaceWith(expression="content.toRequestBody(contentType, offset, byteCount)", imports={"okhttp3.RequestBody.Companion.toRequestBody"}), level=DeprecationLevel.WARNING)
        @JvmOverloads
        @NotNull
        public final RequestBody create(@Nullable MediaType contentType, @NotNull byte[] content2, int offset) {
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            return okhttp3.RequestBody$Companion.create$default(this, contentType, content2, offset, 0, 8, null);
        }

        @JvmStatic
        @Deprecated(message="Moved to extension function. Put the 'content' argument first to fix Java", replaceWith=@ReplaceWith(expression="content.toRequestBody(contentType, offset, byteCount)", imports={"okhttp3.RequestBody.Companion.toRequestBody"}), level=DeprecationLevel.WARNING)
        @JvmOverloads
        @NotNull
        public final RequestBody create(@Nullable MediaType contentType, @NotNull byte[] content2) {
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            return okhttp3.RequestBody$Companion.create$default(this, contentType, content2, 0, 0, 12, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

