/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.ReplaceWith;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Challenge {
    @NotNull
    private final String scheme;
    @NotNull
    private final Map<String, String> authParams;

    public Challenge(@NotNull String scheme, @NotNull Map<String, String> authParams) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Intrinsics.checkNotNullParameter(authParams, (String)"authParams");
        this.scheme = scheme;
        Map newAuthParams = new LinkedHashMap();
        for (Map.Entry<String, String> entry : authParams.entrySet()) {
            String string;
            String key = entry.getKey();
            String value2 = entry.getValue();
            if (key != null) {
                String string2;
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                String string3 = string2.toLowerCase(locale);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
            } else {
                string = null;
            }
            String newKey = string;
            newAuthParams.put(newKey, value2);
        }
        Map map2 = Collections.unmodifiableMap(newAuthParams);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"unmodifiableMap<String?, String>(newAuthParams)");
        this.authParams = map2;
    }

    @JvmName(name="scheme")
    @NotNull
    public final String scheme() {
        return this.scheme;
    }

    @JvmName(name="authParams")
    @NotNull
    public final Map<String, String> authParams() {
        return this.authParams;
    }

    @JvmName(name="realm")
    @Nullable
    public final String realm() {
        return this.authParams.get("realm");
    }

    @JvmName(name="charset")
    @NotNull
    public final Charset charset() {
        String charset = this.authParams.get("charset");
        if (charset != null) {
            try {
                Charset charset2 = Charset.forName(charset);
                Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"forName(charset)");
                return charset2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Charset charset3 = StandardCharsets.ISO_8859_1;
        Intrinsics.checkNotNullExpressionValue((Object)charset3, (String)"ISO_8859_1");
        return charset3;
    }

    public Challenge(@NotNull String scheme, @NotNull String realm) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Intrinsics.checkNotNullParameter((Object)realm, (String)"realm");
        Map<String, String> map2 = Collections.singletonMap("realm", realm);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"singletonMap(\"realm\", realm)");
        this(scheme, map2);
    }

    @NotNull
    public final Challenge withCharset(@NotNull Charset charset) {
        Map authParams;
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Map map2 = authParams = MapsKt.toMutableMap(this.authParams);
        String string = "charset";
        String string2 = charset.name();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"charset.name()");
        String string3 = string2;
        map2.put(string, string3);
        return new Challenge(this.scheme, authParams);
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="scheme", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_scheme")
    @NotNull
    public final String -deprecated_scheme() {
        return this.scheme;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="authParams", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_authParams")
    @NotNull
    public final Map<String, String> -deprecated_authParams() {
        return this.authParams;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="realm", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_realm")
    @Nullable
    public final String -deprecated_realm() {
        return this.realm();
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="charset", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_charset")
    @NotNull
    public final Charset -deprecated_charset() {
        return this.charset();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof Challenge && Intrinsics.areEqual((Object)((Challenge)other).scheme, (Object)this.scheme) && Intrinsics.areEqual(((Challenge)other).authParams, this.authParams);
    }

    public int hashCode() {
        int result2 = 29;
        result2 = 31 * result2 + this.scheme.hashCode();
        result2 = 31 * result2 + ((Object)this.authParams).hashCode();
        return result2;
    }

    @NotNull
    public String toString() {
        return this.scheme + " authParams=" + this.authParams;
    }
}

