/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io.files;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.io.files.AnimalSnifferIgnore;
import kotlinx.io.files.Mover;
import kotlinx.io.files.Path;
import org.jetbrains.annotations.NotNull;

final class NioMover
implements Mover {
    @Override
    @AnimalSnifferIgnore
    public void move(@NotNull Path source, @NotNull Path destination) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        if (!source.getFile$kotlinx_io_core().exists()) {
            throw new FileNotFoundException("Source file does not exist: " + source.getFile$kotlinx_io_core());
        }
        try {
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING};
            Files.move(source.getFile$kotlinx_io_core().toPath(), destination.getFile$kotlinx_io_core().toPath(), copyOptionArray);
        }
        catch (Throwable e) {
            if (e instanceof IOException) {
                throw e;
            }
            throw new IOException("Move failed", e);
        }
    }
}

