/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io.bytestring;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlinx.io.bytestring.ByteString;
import kotlinx.io.bytestring.ByteStringKt;
import kotlinx.io.bytestring.unsafe.UnsafeByteStringOperations;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nByteStringJvmExt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteStringJvmExt.kt\nkotlinx/io/bytestring/ByteStringJvmExtKt\n+ 2 UnsafeByteStringOperations.kt\nkotlinx/io/bytestring/unsafe/UnsafeByteStringOperations\n*L\n1#1,137:1\n42#2,2:138\n42#2,2:140\n*S KotlinDebug\n*F\n+ 1 ByteStringJvmExt.kt\nkotlinx/io/bytestring/ByteStringJvmExtKt\n*L\n37#1:138,2\n101#1:140,2\n*E\n"})
public final class ByteStringJvmExtKt {
    @NotNull
    public static final String decodeToString(@NotNull ByteString $this$decodeToString, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeToString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return new String($this$decodeToString.getBackingArrayReference(), charset);
    }

    @NotNull
    public static final ByteString encodeToByteString(@NotNull String $this$encodeToByteString, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeToByteString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        byte[] byArray = $this$encodeToByteString.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return ByteString.Companion.wrap$kotlinx_io_bytestring(byArray);
    }

    @NotNull
    public static final ByteBuffer asReadOnlyByteBuffer(@NotNull ByteString $this$asReadOnlyByteBuffer) {
        Intrinsics.checkNotNullParameter((Object)$this$asReadOnlyByteBuffer, (String)"<this>");
        byte[] data2 = null;
        UnsafeByteStringOperations this_$iv = UnsafeByteStringOperations.INSTANCE;
        boolean $i$f$withByteArrayUnsafe = false;
        byte[] it = $this$asReadOnlyByteBuffer.getBackingArrayReference();
        boolean bl = false;
        data2 = it;
        ByteBuffer byteBuffer = ByteBuffer.wrap(data2).asReadOnlyBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"asReadOnlyBuffer(...)");
        return byteBuffer;
    }

    @NotNull
    public static final ByteString getByteString(@NotNull ByteBuffer $this$getByteString, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$getByteString, (String)"<this>");
        if (length < 0) {
            throw new IndexOutOfBoundsException("length should be non-negative (was " + length + ')');
        }
        if ($this$getByteString.remaining() < length) {
            throw new IndexOutOfBoundsException("length (" + length + ") exceeds remaining bytes count ({" + $this$getByteString.remaining() + "})");
        }
        byte[] bytes2 = new byte[length];
        $this$getByteString.get(bytes2);
        return UnsafeByteStringOperations.INSTANCE.wrapUnsafe(bytes2);
    }

    public static /* synthetic */ ByteString getByteString$default(ByteBuffer byteBuffer, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = byteBuffer.remaining();
        }
        return ByteStringJvmExtKt.getByteString(byteBuffer, n);
    }

    @NotNull
    public static final ByteString getByteString(@NotNull ByteBuffer $this$getByteString, int at, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$getByteString, (String)"<this>");
        ByteStringJvmExtKt.checkIndexAndCapacity($this$getByteString, at, length);
        byte[] bytes2 = new byte[length];
        for (int i2 = 0; i2 < length; ++i2) {
            bytes2[i2] = $this$getByteString.get(at + i2);
        }
        return UnsafeByteStringOperations.INSTANCE.wrapUnsafe(bytes2);
    }

    public static final void putByteString(@NotNull ByteBuffer $this$putByteString, @NotNull ByteString string) {
        Intrinsics.checkNotNullParameter((Object)$this$putByteString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        UnsafeByteStringOperations this_$iv = UnsafeByteStringOperations.INSTANCE;
        boolean $i$f$withByteArrayUnsafe = false;
        byte[] it = string.getBackingArrayReference();
        boolean bl = false;
        $this$putByteString.put(it);
    }

    public static final void putByteString(@NotNull ByteBuffer $this$putByteString, int at, @NotNull ByteString string) {
        Intrinsics.checkNotNullParameter((Object)$this$putByteString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        ByteStringJvmExtKt.checkIndexAndCapacity($this$putByteString, at, string.getSize());
        IntRange intRange = ByteStringKt.getIndices(string);
        int idx = intRange.getFirst();
        int n = intRange.getLast();
        if (idx <= n) {
            while (true) {
                $this$putByteString.put(at + idx, string.get(idx));
                if (idx == n) break;
                ++idx;
            }
        }
    }

    private static final void checkIndexAndCapacity(ByteBuffer $this$checkIndexAndCapacity, int idx, int length) {
        if (idx < 0 || idx >= $this$checkIndexAndCapacity.limit()) {
            throw new IndexOutOfBoundsException("Index " + idx + " is out of this ByteBuffer's bounds: [0, " + $this$checkIndexAndCapacity.limit() + ')');
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("length should be non-negative (was " + length + ')');
        }
        if (idx + length > $this$checkIndexAndCapacity.limit()) {
            throw new IndexOutOfBoundsException("There's not enough space to put ByteString of length " + length + " starting from index " + idx);
        }
    }
}

