/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io;

import kotlin.PublishedApi;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.SegmentCopyTracker;
import kotlinx.io.SegmentPool;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nSegment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Segment.kt\nkotlinx/io/Segment\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 -Util.kt\nkotlinx/io/_UtilKt\n*L\n1#1,535:1\n1#2:536\n95#3:537\n95#3:538\n95#3:539\n95#3:540\n95#3:541\n98#3:542\n98#3:543\n98#3:544\n98#3:545\n98#3:546\n98#3:547\n98#3:548\n98#3:549\n*S KotlinDebug\n*F\n+ 1 Segment.kt\nkotlinx/io/Segment\n*L\n282#1:537\n291#1:538\n292#1:539\n293#1:540\n294#1:541\n304#1:542\n305#1:543\n306#1:544\n307#1:545\n308#1:546\n309#1:547\n310#1:548\n311#1:549\n*E\n"})
public final class Segment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] data;
    private int pos;
    private int limit;
    @Nullable
    private SegmentCopyTracker copyTracker;
    @JvmField
    public boolean owner;
    @Nullable
    private Segment next;
    @Nullable
    private Segment prev;
    public static final int SIZE = 8192;
    public static final int SHARE_MINIMUM = 1024;

    public final /* synthetic */ int getPos() {
        return this.pos;
    }

    public final /* synthetic */ void setPos(int n) {
        this.pos = n;
    }

    @PublishedApi
    public static /* synthetic */ void getPos$annotations() {
    }

    public final /* synthetic */ int getLimit() {
        return this.limit;
    }

    public final /* synthetic */ void setLimit(int n) {
        this.limit = n;
    }

    @PublishedApi
    public static /* synthetic */ void getLimit$annotations() {
    }

    public final boolean getShared$kotlinx_io_core() {
        SegmentCopyTracker segmentCopyTracker = this.copyTracker;
        return segmentCopyTracker != null ? segmentCopyTracker.getShared() : false;
    }

    @Nullable
    public final SegmentCopyTracker getCopyTracker$kotlinx_io_core() {
        return this.copyTracker;
    }

    public final void setCopyTracker$kotlinx_io_core(@Nullable SegmentCopyTracker segmentCopyTracker) {
        this.copyTracker = segmentCopyTracker;
    }

    public final /* synthetic */ Segment getNext() {
        return this.next;
    }

    public final /* synthetic */ void setNext(Segment segment) {
        this.next = segment;
    }

    @PublishedApi
    public static /* synthetic */ void getNext$annotations() {
    }

    public final /* synthetic */ Segment getPrev() {
        return this.prev;
    }

    public final /* synthetic */ void setPrev(Segment segment) {
        this.prev = segment;
    }

    @PublishedApi
    public static /* synthetic */ void getPrev$annotations() {
    }

    private Segment() {
        this.data = new byte[8192];
        this.owner = true;
        this.copyTracker = null;
    }

    private Segment(byte[] data2, int pos, int limit, SegmentCopyTracker shareToken, boolean owner2) {
        this.data = data2;
        this.pos = pos;
        this.limit = limit;
        this.copyTracker = shareToken;
        this.owner = owner2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Segment sharedCopy$kotlinx_io_core() {
        void it;
        SegmentCopyTracker t2;
        SegmentCopyTracker segmentCopyTracker;
        SegmentCopyTracker segmentCopyTracker2;
        SegmentCopyTracker segmentCopyTracker3 = this.copyTracker;
        if (segmentCopyTracker3 == null) {
            SegmentCopyTracker it2 = segmentCopyTracker2 = SegmentPool.tracker();
            boolean bl = false;
            this.copyTracker = it2;
            segmentCopyTracker3 = segmentCopyTracker2;
        }
        segmentCopyTracker2 = segmentCopyTracker = (t2 = segmentCopyTracker3);
        int n = this.limit;
        int n2 = this.pos;
        byte[] byArray = this.data;
        boolean bl = false;
        it.addCopy();
        Unit unit = Unit.INSTANCE;
        boolean bl2 = false;
        SegmentCopyTracker segmentCopyTracker4 = segmentCopyTracker;
        int n3 = n;
        int n4 = n2;
        byte[] byArray2 = byArray;
        return new Segment(byArray2, n4, n3, segmentCopyTracker4, bl2);
    }

    @Nullable
    public final Segment pop$kotlinx_io_core() {
        Segment result2 = this.next;
        if (this.prev != null) {
            Intrinsics.checkNotNull((Object)this.prev);
            this.prev.next = this.next;
        }
        if (this.next != null) {
            Intrinsics.checkNotNull((Object)this.next);
            this.next.prev = this.prev;
        }
        this.next = null;
        this.prev = null;
        return result2;
    }

    @NotNull
    public final Segment push$kotlinx_io_core(@NotNull Segment segment) {
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        segment.prev = this;
        segment.next = this.next;
        if (this.next != null) {
            Intrinsics.checkNotNull((Object)this.next);
            this.next.prev = segment;
        }
        this.next = segment;
        return segment;
    }

    @NotNull
    public final Segment split$kotlinx_io_core(int byteCount) {
        if (!(byteCount > 0 && byteCount <= this.limit - this.pos)) {
            boolean bl = false;
            String string = "byteCount out of range";
            throw new IllegalArgumentException(string.toString());
        }
        Segment prefix = null;
        if (byteCount >= 1024) {
            prefix = this.sharedCopy$kotlinx_io_core();
        } else {
            prefix = SegmentPool.take();
            ArraysKt.copyInto$default((byte[])this.data, (byte[])prefix.data, (int)0, (int)this.pos, (int)(this.pos + byteCount), (int)2, null);
        }
        prefix.limit = prefix.pos + byteCount;
        this.pos += byteCount;
        if (this.prev != null) {
            Segment segment = this.prev;
            Intrinsics.checkNotNull((Object)segment);
            segment.push$kotlinx_io_core(prefix);
        } else {
            prefix.next = this;
            this.prev = prefix;
        }
        return prefix;
    }

    @NotNull
    public final Segment compact$kotlinx_io_core() {
        Segment predecessor;
        int n;
        if (!(this.prev != null)) {
            boolean $i$a$-check-Segment$compact$22 = false;
            String $i$a$-check-Segment$compact$22 = "cannot compact";
            throw new IllegalStateException($i$a$-check-Segment$compact$22.toString());
        }
        Segment segment = this.prev;
        Intrinsics.checkNotNull((Object)segment);
        if (!segment.owner) {
            return this;
        }
        int byteCount = this.limit - this.pos;
        Segment segment2 = this.prev;
        Intrinsics.checkNotNull((Object)segment2);
        int n2 = 8192 - segment2.limit;
        Segment segment3 = this.prev;
        Intrinsics.checkNotNull((Object)segment3);
        if (segment3.getShared$kotlinx_io_core()) {
            n = 0;
        } else {
            Segment segment4 = this.prev;
            Intrinsics.checkNotNull((Object)segment4);
            n = segment4.pos;
        }
        int availableByteCount = n2 + n;
        if (byteCount > availableByteCount) {
            return this;
        }
        Segment segment5 = predecessor = this.prev;
        Intrinsics.checkNotNull((Object)segment5);
        this.writeTo$kotlinx_io_core(segment5, byteCount);
        Segment successor = this.pop$kotlinx_io_core();
        if (!(successor == null)) {
            throw new IllegalStateException("Check failed.");
        }
        SegmentPool.recycle(this);
        return predecessor;
    }

    public final void writeByte$kotlinx_io_core(byte by) {
        int n = this.limit;
        this.limit = n + 1;
        this.data[n] = by;
    }

    public final void writeShort$kotlinx_io_core(short s) {
        byte[] data2 = this.data;
        int limit = this.limit;
        data2[limit++] = (byte)(s >>> 8 & 0xFF);
        data2[limit++] = (byte)(s & 0xFF);
        this.limit = limit;
    }

    public final void writeInt$kotlinx_io_core(int n) {
        byte[] data2 = this.data;
        int limit = this.limit;
        data2[limit++] = (byte)(n >>> 24 & 0xFF);
        data2[limit++] = (byte)(n >>> 16 & 0xFF);
        data2[limit++] = (byte)(n >>> 8 & 0xFF);
        data2[limit++] = (byte)(n & 0xFF);
        this.limit = limit;
    }

    public final void writeLong$kotlinx_io_core(long l) {
        byte[] data2 = this.data;
        int limit = this.limit;
        data2[limit++] = (byte)(l >>> 56 & 0xFFL);
        data2[limit++] = (byte)(l >>> 48 & 0xFFL);
        data2[limit++] = (byte)(l >>> 40 & 0xFFL);
        data2[limit++] = (byte)(l >>> 32 & 0xFFL);
        data2[limit++] = (byte)(l >>> 24 & 0xFFL);
        data2[limit++] = (byte)(l >>> 16 & 0xFFL);
        data2[limit++] = (byte)(l >>> 8 & 0xFFL);
        data2[limit++] = (byte)(l & 0xFFL);
        this.limit = limit;
    }

    public final byte readByte$kotlinx_io_core() {
        int n = this.pos;
        this.pos = n + 1;
        return this.data[n];
    }

    public final short readShort$kotlinx_io_core() {
        byte $this$and$iv;
        byte[] data2 = this.data;
        int pos = this.pos;
        byte by = data2[pos++];
        int other$iv = 255;
        boolean $i$f$and = false;
        int n = ($this$and$iv & other$iv) << 8;
        $this$and$iv = data2[pos++];
        other$iv = 255;
        $i$f$and = false;
        short s = (short)(n | $this$and$iv & other$iv);
        this.pos = pos;
        return s;
    }

    public final int readInt$kotlinx_io_core() {
        byte $this$and$iv;
        byte[] data2 = this.data;
        int pos = this.pos;
        byte by = data2[pos++];
        int other$iv = 255;
        boolean $i$f$and = false;
        int n = ($this$and$iv & other$iv) << 24;
        $this$and$iv = data2[pos++];
        other$iv = 255;
        $i$f$and = false;
        int n2 = n | ($this$and$iv & other$iv) << 16;
        $this$and$iv = data2[pos++];
        other$iv = 255;
        $i$f$and = false;
        int n3 = n2 | ($this$and$iv & other$iv) << 8;
        $this$and$iv = data2[pos++];
        other$iv = 255;
        $i$f$and = false;
        int i2 = n3 | $this$and$iv & other$iv;
        this.pos = pos;
        return i2;
    }

    public final long readLong$kotlinx_io_core() {
        byte $this$and$iv;
        byte[] data2 = this.data;
        int pos = this.pos;
        byte by = data2[pos++];
        long other$iv = 255L;
        boolean $i$f$and = false;
        long l = ((long)$this$and$iv & other$iv) << 56;
        $this$and$iv = data2[pos++];
        other$iv = 255L;
        $i$f$and = false;
        long l2 = l | ((long)$this$and$iv & other$iv) << 48;
        $this$and$iv = data2[pos++];
        other$iv = 255L;
        $i$f$and = false;
        long l3 = l2 | ((long)$this$and$iv & other$iv) << 40;
        $this$and$iv = data2[pos++];
        other$iv = 255L;
        $i$f$and = false;
        long l4 = l3 | ((long)$this$and$iv & other$iv) << 32;
        $this$and$iv = data2[pos++];
        other$iv = 255L;
        $i$f$and = false;
        long l5 = l4 | ((long)$this$and$iv & other$iv) << 24;
        $this$and$iv = data2[pos++];
        other$iv = 255L;
        $i$f$and = false;
        long l6 = l5 | ((long)$this$and$iv & other$iv) << 16;
        $this$and$iv = data2[pos++];
        other$iv = 255L;
        $i$f$and = false;
        long l7 = l6 | ((long)$this$and$iv & other$iv) << 8;
        $this$and$iv = data2[pos++];
        other$iv = 255L;
        $i$f$and = false;
        long v = l7 | (long)$this$and$iv & other$iv;
        this.pos = pos;
        return v;
    }

    public final void writeTo$kotlinx_io_core(@NotNull Segment sink, int byteCount) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        if (!sink.owner) {
            boolean bl = false;
            String string = "only owner can write";
            throw new IllegalStateException(string.toString());
        }
        if (sink.limit + byteCount > 8192) {
            if (sink.getShared$kotlinx_io_core()) {
                throw new IllegalArgumentException();
            }
            if (sink.limit + byteCount - sink.pos > 8192) {
                throw new IllegalArgumentException();
            }
            ArraysKt.copyInto$default((byte[])sink.data, (byte[])sink.data, (int)0, (int)sink.pos, (int)sink.limit, (int)2, null);
            sink.limit -= sink.pos;
            sink.pos = 0;
        }
        ArraysKt.copyInto((byte[])this.data, (byte[])sink.data, (int)sink.limit, (int)this.pos, (int)(this.pos + byteCount));
        sink.limit += byteCount;
        this.pos += byteCount;
    }

    public final void readTo$kotlinx_io_core(@NotNull byte[] dst, int dstStartOffset, int dstEndOffset) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        int len = dstEndOffset - dstStartOffset;
        ArraysKt.copyInto((byte[])this.data, (byte[])dst, (int)dstStartOffset, (int)this.pos, (int)(this.pos + len));
        this.pos += len;
    }

    public final void write$kotlinx_io_core(@NotNull byte[] src, int srcStartOffset, int srcEndOffset) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        ArraysKt.copyInto((byte[])src, (byte[])this.data, (int)this.limit, (int)srcStartOffset, (int)srcEndOffset);
        this.limit += srcEndOffset - srcStartOffset;
    }

    public final int getSize() {
        return this.limit - this.pos;
    }

    public final int getRemainingCapacity() {
        return this.data.length - this.limit;
    }

    @PublishedApi
    public final /* synthetic */ byte[] dataAsByteArray(boolean readOnly) {
        return this.data;
    }

    @PublishedApi
    public final /* synthetic */ void writeBackData(byte[] data2, int bytesToCommit) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
    }

    public final byte getUnchecked$kotlinx_io_core(int index) {
        return this.data[this.pos + index];
    }

    public final void setUnchecked$kotlinx_io_core(int index, byte value2) {
        this.data[this.limit + index] = value2;
    }

    public final void setUnchecked$kotlinx_io_core(int index, byte b0, byte b1) {
        byte[] d = this.data;
        int l = this.limit;
        d[l + index] = b0;
        d[l + index + 1] = b1;
    }

    public final void setUnchecked$kotlinx_io_core(int index, byte b0, byte b1, byte b2) {
        byte[] d = this.data;
        int l = this.limit;
        d[l + index] = b0;
        d[l + index + 1] = b1;
        d[l + index + 2] = b2;
    }

    public final void setUnchecked$kotlinx_io_core(int index, byte b0, byte b1, byte b2, byte b3) {
        byte[] d = this.data;
        int l = this.limit;
        d[l + index] = b0;
        d[l + index + 1] = b1;
        d[l + index + 2] = b2;
        d[l + index + 3] = b3;
    }

    public /* synthetic */ Segment(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public /* synthetic */ Segment(byte[] data2, int pos, int limit, SegmentCopyTracker shareToken, boolean owner2, DefaultConstructorMarker $constructor_marker) {
        this(data2, pos, limit, shareToken, owner2);
    }

    public static final class Companion {
        private Companion() {
        }

        public final /* synthetic */ Segment new$kotlinx_io_core() {
            return new Segment(null);
        }

        public final /* synthetic */ Segment new$kotlinx_io_core(byte[] data2, int pos, int limit, SegmentCopyTracker copyTracker, boolean owner2) {
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            return new Segment(data2, pos, limit, copyTracker, owner2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

