/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io;

import java.io.EOFException;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.DelicateIoApi;
import kotlinx.io.InternalIoApi;
import kotlinx.io.RawSink;
import kotlinx.io.RawSource;
import kotlinx.io.Sink;
import kotlinx.io._UtilKt;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nRealSink.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealSink.kt\nkotlinx/io/RealSink\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 -Util.kt\nkotlinx/io/_UtilKt\n*L\n1#1,158:1\n155#1:159\n156#1:161\n155#1:163\n156#1:165\n155#1:167\n156#1:169\n155#1:170\n156#1:172\n155#1:174\n156#1:176\n155#1:177\n156#1:179\n155#1:180\n156#1:182\n155#1:183\n156#1:185\n155#1:186\n156#1:188\n155#1:189\n156#1:191\n155#1:192\n156#1:194\n1#2:160\n1#2:162\n1#2:164\n1#2:168\n1#2:171\n1#2:173\n1#2:175\n1#2:178\n1#2:181\n1#2:184\n1#2:187\n1#2:190\n1#2:193\n1#2:195\n38#3:166\n*S KotlinDebug\n*F\n+ 1 RealSink.kt\nkotlinx/io/RealSink\n*L\n39#1:159\n39#1:161\n46#1:163\n46#1:165\n53#1:167\n53#1:169\n65#1:170\n65#1:172\n82#1:174\n82#1:176\n88#1:177\n88#1:179\n94#1:180\n94#1:182\n100#1:183\n100#1:185\n107#1:186\n107#1:188\n113#1:189\n113#1:191\n119#1:192\n119#1:194\n39#1:160\n46#1:164\n53#1:168\n65#1:171\n82#1:175\n88#1:178\n94#1:181\n100#1:184\n107#1:187\n113#1:190\n119#1:193\n47#1:166\n*E\n"})
public final class RealSink
implements Sink {
    @NotNull
    private final RawSink sink;
    @JvmField
    public boolean closed;
    @NotNull
    private final Buffer bufferField;

    public RealSink(@NotNull RawSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        this.sink = sink;
        this.bufferField = new Buffer();
    }

    @NotNull
    public final RawSink getSink() {
        return this.sink;
    }

    @Override
    @NotNull
    public Buffer getBuffer() {
        return this.bufferField;
    }

    @DelicateIoApi
    public static /* synthetic */ void getBuffer$annotations() {
    }

    @Override
    public void write(@NotNull Buffer source, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        RealSink this_$iv = this;
        boolean $i$f$checkNotClosed = false;
        if (!(!this_$iv.closed)) {
            boolean bl = false;
            String string = "Sink is closed.";
            throw new IllegalStateException(string.toString());
        }
        if (!(byteCount >= 0L)) {
            boolean bl = false;
            String string = "byteCount: " + byteCount;
            throw new IllegalArgumentException(string.toString());
        }
        this.bufferField.write(source, byteCount);
        this.hintEmit();
    }

    @Override
    public void write(@NotNull byte[] source, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        RealSink this_$iv = this;
        boolean $i$f$checkNotClosed = false;
        if (!(!this_$iv.closed)) {
            boolean bl = false;
            String string = "Sink is closed.";
            throw new IllegalStateException(string.toString());
        }
        int size$iv = source.length;
        boolean $i$f$checkBounds = false;
        _UtilKt.checkBounds((long)size$iv, (long)startIndex, (long)endIndex);
        this.bufferField.write(source, startIndex, endIndex);
        this.hintEmit();
    }

    @Override
    public long transferFrom(@NotNull RawSource source) {
        long readCount;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        RealSink this_$iv = this;
        boolean $i$f$checkNotClosed = false;
        if (!(!this_$iv.closed)) {
            boolean $i$a$-check-RealSink$checkNotClosed$1$iv22 = false;
            String $i$a$-check-RealSink$checkNotClosed$1$iv22 = "Sink is closed.";
            throw new IllegalStateException($i$a$-check-RealSink$checkNotClosed$1$iv22.toString());
        }
        long totalBytesRead = 0L;
        while ((readCount = source.readAtMostTo(this.bufferField, 8192L)) != -1L) {
            totalBytesRead += readCount;
            this.hintEmit();
        }
        return totalBytesRead;
    }

    @Override
    public void write(@NotNull RawSource source, long byteCount) {
        long read2;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        RealSink this_$iv = this;
        boolean $i$f$checkNotClosed = false;
        if (!(!this_$iv.closed)) {
            boolean $i$a$-check-RealSink$checkNotClosed$1$iv22 = false;
            String $i$a$-check-RealSink$checkNotClosed$1$iv22 = "Sink is closed.";
            throw new IllegalStateException($i$a$-check-RealSink$checkNotClosed$1$iv22.toString());
        }
        if (!(byteCount >= 0L)) {
            boolean bl = false;
            String string = "byteCount: " + byteCount;
            throw new IllegalArgumentException(string.toString());
        }
        for (long remainingByteCount = byteCount; remainingByteCount > 0L; remainingByteCount -= read2) {
            read2 = source.readAtMostTo(this.bufferField, remainingByteCount);
            if (read2 == -1L) {
                long bytesRead = byteCount - remainingByteCount;
                throw new EOFException("Source exhausted before reading " + byteCount + " bytes from it (number of bytes read: " + bytesRead + ").");
            }
            this.hintEmit();
        }
    }

    @Override
    public void writeByte(byte by) {
        RealSink this_$iv = this;
        boolean $i$f$checkNotClosed = false;
        if (!(!this_$iv.closed)) {
            boolean bl = false;
            String string = "Sink is closed.";
            throw new IllegalStateException(string.toString());
        }
        this.bufferField.writeByte(by);
        this.hintEmit();
    }

    @Override
    public void writeShort(short s) {
        RealSink this_$iv = this;
        boolean $i$f$checkNotClosed = false;
        if (!(!this_$iv.closed)) {
            boolean bl = false;
            String string = "Sink is closed.";
            throw new IllegalStateException(string.toString());
        }
        this.bufferField.writeShort(s);
        this.hintEmit();
    }

    @Override
    public void writeInt(int n) {
        RealSink this_$iv = this;
        boolean $i$f$checkNotClosed = false;
        if (!(!this_$iv.closed)) {
            boolean bl = false;
            String string = "Sink is closed.";
            throw new IllegalStateException(string.toString());
        }
        this.bufferField.writeInt(n);
        this.hintEmit();
    }

    @Override
    public void writeLong(long l) {
        RealSink this_$iv = this;
        boolean $i$f$checkNotClosed = false;
        if (!(!this_$iv.closed)) {
            boolean bl = false;
            String string = "Sink is closed.";
            throw new IllegalStateException(string.toString());
        }
        this.bufferField.writeLong(l);
        this.hintEmit();
    }

    @Override
    @InternalIoApi
    public void hintEmit() {
        RealSink this_$iv = this;
        boolean $i$f$checkNotClosed = false;
        if (!(!this_$iv.closed)) {
            boolean bl = false;
            String string = "Sink is closed.";
            throw new IllegalStateException(string.toString());
        }
        long byteCount = this.bufferField.completeSegmentByteCount$kotlinx_io_core();
        if (byteCount > 0L) {
            this.sink.write(this.bufferField, byteCount);
        }
    }

    @Override
    public void emit() {
        RealSink this_$iv = this;
        boolean $i$f$checkNotClosed = false;
        if (!(!this_$iv.closed)) {
            boolean bl = false;
            String string = "Sink is closed.";
            throw new IllegalStateException(string.toString());
        }
        long byteCount = this.bufferField.getSize();
        if (byteCount > 0L) {
            this.sink.write(this.bufferField, byteCount);
        }
    }

    @Override
    public void flush() {
        RealSink this_$iv = this;
        boolean $i$f$checkNotClosed = false;
        if (!(!this_$iv.closed)) {
            boolean bl = false;
            String string = "Sink is closed.";
            throw new IllegalStateException(string.toString());
        }
        if (this.bufferField.getSize() > 0L) {
            this.sink.write(this.bufferField, this.bufferField.getSize());
        }
        this.sink.flush();
    }

    @Override
    public void close() {
        Throwable thrown;
        block7: {
            if (this.closed) {
                return;
            }
            thrown = null;
            try {
                if (this.bufferField.getSize() > 0L) {
                    this.sink.write(this.bufferField, this.bufferField.getSize());
                }
            }
            catch (Throwable e) {
                thrown = e;
            }
            try {
                this.sink.close();
            }
            catch (Throwable e) {
                if (thrown != null) break block7;
                thrown = e;
            }
        }
        this.closed = true;
        Throwable throwable = thrown;
        if (throwable != null) {
            throw throwable;
        }
    }

    @NotNull
    public String toString() {
        return "buffered(" + this.sink + ')';
    }

    private final void checkNotClosed() {
        boolean $i$f$checkNotClosed = false;
        if (!(!this.closed)) {
            boolean bl = false;
            String string = "Sink is closed.";
            throw new IllegalStateException(string.toString());
        }
    }
}

