/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.collections.immutable.implementations.immutableList;

import java.util.ConcurrentModificationException;
import java.util.ListIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableListIterator;
import kotlin.ranges.RangesKt;
import kotlinx.collections.immutable.implementations.immutableList.AbstractListIterator;
import kotlinx.collections.immutable.implementations.immutableList.PersistentVectorBuilder;
import kotlinx.collections.immutable.implementations.immutableList.TrieIterator;
import kotlinx.collections.immutable.implementations.immutableList.UtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PersistentVectorMutableIterator<T>
extends AbstractListIterator<T>
implements ListIterator<T>,
KMutableListIterator {
    @NotNull
    private final PersistentVectorBuilder<T> builder;
    private int expectedModCount;
    @Nullable
    private TrieIterator<? extends T> trieIterator;
    private int lastIteratedIndex;

    public PersistentVectorMutableIterator(@NotNull PersistentVectorBuilder<T> builder, int index) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        super(index, builder.size());
        this.builder = builder;
        this.expectedModCount = this.builder.getModCount$kotlinx_collections_immutable();
        this.lastIteratedIndex = -1;
        this.setupTrieIterator();
    }

    @Override
    public T previous() {
        this.checkForComodification();
        this.checkHasPrevious$kotlinx_collections_immutable();
        this.lastIteratedIndex = this.getIndex() - 1;
        TrieIterator<T> trieIterator = this.trieIterator;
        if (trieIterator == null) {
            Object[] objectArray = this.builder.getTail$kotlinx_collections_immutable();
            this.setIndex(this.getIndex() + -1);
            return (T)objectArray[this.getIndex()];
        }
        TrieIterator<T> trieIterator2 = trieIterator;
        if (this.getIndex() > trieIterator2.getSize()) {
            Object[] objectArray = this.builder.getTail$kotlinx_collections_immutable();
            this.setIndex(this.getIndex() + -1);
            return (T)objectArray[this.getIndex() - trieIterator2.getSize()];
        }
        int n = this.getIndex();
        this.setIndex(n + -1);
        return trieIterator2.previous();
    }

    @Override
    public T next() {
        this.checkForComodification();
        this.checkHasNext$kotlinx_collections_immutable();
        this.lastIteratedIndex = this.getIndex();
        TrieIterator<T> trieIterator = this.trieIterator;
        if (trieIterator == null) {
            Object[] objectArray = this.builder.getTail$kotlinx_collections_immutable();
            int n = this.getIndex();
            this.setIndex(n + 1);
            return (T)objectArray[n];
        }
        TrieIterator<T> trieIterator2 = trieIterator;
        if (trieIterator2.hasNext()) {
            int n = this.getIndex();
            this.setIndex(n + 1);
            return trieIterator2.next();
        }
        Object[] objectArray = this.builder.getTail$kotlinx_collections_immutable();
        int n = this.getIndex();
        this.setIndex(n + 1);
        return (T)objectArray[n - trieIterator2.getSize()];
    }

    private final void reset() {
        this.setSize(this.builder.size());
        this.expectedModCount = this.builder.getModCount$kotlinx_collections_immutable();
        this.lastIteratedIndex = -1;
        this.setupTrieIterator();
    }

    private final void setupTrieIterator() {
        Object[] root = this.builder.getRoot$kotlinx_collections_immutable();
        if (root == null) {
            this.trieIterator = null;
            return;
        }
        int trieSize = UtilsKt.rootSize(this.builder.size());
        int trieIndex = RangesKt.coerceAtMost((int)this.getIndex(), (int)trieSize);
        int trieHeight = this.builder.getRootShift$kotlinx_collections_immutable() / 5 + 1;
        if (this.trieIterator == null) {
            this.trieIterator = new TrieIterator(root, trieIndex, trieSize, trieHeight);
        } else {
            TrieIterator<T> trieIterator = this.trieIterator;
            Intrinsics.checkNotNull(trieIterator);
            trieIterator.reset$kotlinx_collections_immutable(root, trieIndex, trieSize, trieHeight);
        }
    }

    @Override
    public void add(T element) {
        this.checkForComodification();
        this.builder.add(this.getIndex(), element);
        int n = this.getIndex();
        this.setIndex(n + 1);
        this.reset();
    }

    @Override
    public void remove() {
        this.checkForComodification();
        this.checkHasIterated();
        this.builder.remove(this.lastIteratedIndex);
        if (this.lastIteratedIndex < this.getIndex()) {
            this.setIndex(this.lastIteratedIndex);
        }
        this.reset();
    }

    @Override
    public void set(T element) {
        this.checkForComodification();
        this.checkHasIterated();
        this.builder.set(this.lastIteratedIndex, element);
        this.expectedModCount = this.builder.getModCount$kotlinx_collections_immutable();
        this.setupTrieIterator();
    }

    private final void checkForComodification() {
        if (this.expectedModCount != this.builder.getModCount$kotlinx_collections_immutable()) {
            throw new ConcurrentModificationException();
        }
    }

    private final void checkHasIterated() {
        if (this.lastIteratedIndex == -1) {
            throw new IllegalStateException();
        }
    }
}

