/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;

public final class SystemPropertyUtil {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SystemPropertyUtil.class);

    public static boolean contains(String key) {
        return SystemPropertyUtil.get(key) != null;
    }

    public static String get(String key) {
        return SystemPropertyUtil.get(key, null);
    }

    public static String get(final String key, String def2) {
        ObjectUtil.checkNonEmpty(key, "key");
        String value2 = null;
        try {
            value2 = System.getSecurityManager() == null ? System.getProperty(key) : AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(key);
                }
            });
        }
        catch (SecurityException e) {
            logger.warn("Unable to retrieve a system property '{}'; default values will be used.", (Object)key, (Object)e);
        }
        if (value2 == null) {
            return def2;
        }
        return value2;
    }

    public static boolean getBoolean(String key, boolean def2) {
        String value2 = SystemPropertyUtil.get(key);
        if (value2 == null) {
            return def2;
        }
        if ((value2 = value2.trim().toLowerCase()).isEmpty()) {
            return def2;
        }
        if ("true".equals(value2) || "yes".equals(value2) || "1".equals(value2)) {
            return true;
        }
        if ("false".equals(value2) || "no".equals(value2) || "0".equals(value2)) {
            return false;
        }
        logger.warn("Unable to parse the boolean system property '{}':{} - using the default value: {}", key, value2, def2);
        return def2;
    }

    public static int getInt(String key, int def2) {
        String value2 = SystemPropertyUtil.get(key);
        if (value2 == null) {
            return def2;
        }
        value2 = value2.trim();
        try {
            return Integer.parseInt(value2);
        }
        catch (Exception exception) {
            logger.warn("Unable to parse the integer system property '{}':{} - using the default value: {}", key, value2, def2);
            return def2;
        }
    }

    public static long getLong(String key, long def2) {
        String value2 = SystemPropertyUtil.get(key);
        if (value2 == null) {
            return def2;
        }
        value2 = value2.trim();
        try {
            return Long.parseLong(value2);
        }
        catch (Exception exception) {
            logger.warn("Unable to parse the long integer system property '{}':{} - using the default value: {}", key, value2, def2);
            return def2;
        }
    }

    private SystemPropertyUtil() {
    }
}

