/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import java.util.Collection;

public final class ObjectUtil {
    public static <T> T checkNotNull(T arg, String text2) {
        if (arg == null) {
            throw new NullPointerException(text2);
        }
        return arg;
    }

    public static <T> T[] deepCheckNotNull(String text2, T ... varargs) {
        if (varargs == null) {
            throw new NullPointerException(text2);
        }
        for (T element : varargs) {
            if (element != null) continue;
            throw new NullPointerException(text2);
        }
        return varargs;
    }

    public static <T> T checkNotNullWithIAE(T arg, String paramName) throws IllegalArgumentException {
        if (arg == null) {
            throw new IllegalArgumentException("Param '" + paramName + "' must not be null");
        }
        return arg;
    }

    public static <T> T checkNotNullArrayParam(T value2, int index, String name2) throws IllegalArgumentException {
        if (value2 == null) {
            throw new IllegalArgumentException("Array index " + index + " of parameter '" + name2 + "' must not be null");
        }
        return value2;
    }

    public static int checkPositive(int i2, String name2) {
        if (i2 <= 0) {
            throw new IllegalArgumentException(name2 + " : " + i2 + " (expected: > 0)");
        }
        return i2;
    }

    public static int checkPositiveOrZero(int i2, String name2) {
        if (i2 < 0) {
            throw new IllegalArgumentException(name2 + " : " + i2 + " (expected: >= 0)");
        }
        return i2;
    }

    public static long checkPositiveOrZero(long l, String name2) {
        if (l < 0L) {
            throw new IllegalArgumentException(name2 + " : " + l + " (expected: >= 0)");
        }
        return l;
    }

    public static int checkInRange(int i2, int start2, int end, String name2) {
        if (i2 < start2 || i2 > end) {
            throw new IllegalArgumentException(name2 + ": " + i2 + " (expected: " + start2 + "-" + end + ")");
        }
        return i2;
    }

    public static <T> T[] checkNonEmpty(T[] array, String name2) {
        if (ObjectUtil.checkNotNull(array, name2).length == 0) {
            throw new IllegalArgumentException("Param '" + name2 + "' must not be empty");
        }
        return array;
    }

    public static <T extends Collection<?>> T checkNonEmpty(T collection, String name2) {
        if (ObjectUtil.checkNotNull(collection, name2).isEmpty()) {
            throw new IllegalArgumentException("Param '" + name2 + "' must not be empty");
        }
        return collection;
    }

    public static String checkNonEmpty(String value2, String name2) {
        if (ObjectUtil.checkNotNull(value2, name2).isEmpty()) {
            throw new IllegalArgumentException("Param '" + name2 + "' must not be empty");
        }
        return value2;
    }

    public static String checkNonEmptyAfterTrim(String value2, String name2) {
        String trimmed = ObjectUtil.checkNotNull(value2, name2).trim();
        return ObjectUtil.checkNonEmpty(trimmed, name2);
    }
}

