/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.FastThreadLocalRunnable;
import io.netty.util.internal.InternalThreadLocalMap;
import io.netty.util.internal.LongLongHashMap;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.atomic.AtomicReference;

public class FastThreadLocalThread
extends Thread {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(FastThreadLocalThread.class);
    private static final AtomicReference<FallbackThreadSet> fallbackThreads = new AtomicReference<FallbackThreadSet>(FallbackThreadSet.EMPTY);
    private final boolean cleanupFastThreadLocals;
    private InternalThreadLocalMap threadLocalMap;

    public FastThreadLocalThread() {
        this.cleanupFastThreadLocals = false;
    }

    public FastThreadLocalThread(Runnable target, String name2) {
        super(FastThreadLocalRunnable.wrap(target), name2);
        this.cleanupFastThreadLocals = true;
    }

    public FastThreadLocalThread(ThreadGroup group, Runnable target, String name2) {
        super(group, FastThreadLocalRunnable.wrap(target), name2);
        this.cleanupFastThreadLocals = true;
    }

    public final InternalThreadLocalMap threadLocalMap() {
        if (this != Thread.currentThread() && logger.isWarnEnabled()) {
            logger.warn(new RuntimeException("It's not thread-safe to get 'threadLocalMap' which doesn't belong to the caller thread"));
        }
        return this.threadLocalMap;
    }

    public final void setThreadLocalMap(InternalThreadLocalMap threadLocalMap) {
        if (this != Thread.currentThread() && logger.isWarnEnabled()) {
            logger.warn(new RuntimeException("It's not thread-safe to set 'threadLocalMap' which doesn't belong to the caller thread"));
        }
        this.threadLocalMap = threadLocalMap;
    }

    @Deprecated
    public boolean willCleanupFastThreadLocals() {
        return this.cleanupFastThreadLocals;
    }

    public static boolean currentThreadWillCleanupFastThreadLocals() {
        Thread currentThread = FastThreadLocalThread.currentThread();
        if (currentThread instanceof FastThreadLocalThread) {
            return ((FastThreadLocalThread)currentThread).willCleanupFastThreadLocals();
        }
        return FastThreadLocalThread.isFastThreadLocalVirtualThread();
    }

    public static boolean currentThreadHasFastThreadLocal() {
        return FastThreadLocalThread.currentThread() instanceof FastThreadLocalThread || FastThreadLocalThread.isFastThreadLocalVirtualThread();
    }

    private static boolean isFastThreadLocalVirtualThread() {
        return fallbackThreads.get().contains(FastThreadLocalThread.currentThread().getId());
    }

    private static final class FallbackThreadSet {
        static final FallbackThreadSet EMPTY = new FallbackThreadSet();
        private final LongLongHashMap map = new LongLongHashMap(0L);

        private FallbackThreadSet() {
        }

        public boolean contains(long threadId) {
            long key = threadId >>> 6;
            long bit = 1L << (int)(threadId & 0x3FL);
            long bitmap = this.map.get(key);
            return (bitmap & bit) != 0L;
        }
    }
}

