/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.ResourceLeakHint;
import io.netty.util.ResourceLeakTracker;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jetbrains.annotations.Nullable;

public class ResourceLeakDetector<T> {
    private static final Level DEFAULT_LEVEL;
    private static final int TARGET_RECORDS;
    static final int SAMPLING_INTERVAL;
    private static final boolean TRACK_CLOSE;
    private static Level level;
    private static final InternalLogger logger;
    private final Set<DefaultResourceLeak<?>> allLeaks = ConcurrentHashMap.newKeySet();
    private final ReferenceQueue<Object> refQueue = new ReferenceQueue();
    private final Set<String> reportedLeaks = ConcurrentHashMap.newKeySet();
    private final String resourceType;
    private final int samplingInterval;
    private volatile LeakListener leakListener;
    private static final AtomicReference<String[]> excludedMethods;

    public static boolean isEnabled() {
        return ResourceLeakDetector.getLevel().ordinal() > Level.DISABLED.ordinal();
    }

    public static Level getLevel() {
        return level;
    }

    @Deprecated
    public ResourceLeakDetector(Class<?> resourceType, int samplingInterval, long maxActive) {
        this(resourceType, samplingInterval);
    }

    public ResourceLeakDetector(Class<?> resourceType, int samplingInterval) {
        this(StringUtil.simpleClassName(resourceType), samplingInterval, Long.MAX_VALUE);
    }

    @Deprecated
    public ResourceLeakDetector(String resourceType, int samplingInterval, long maxActive) {
        this.resourceType = ObjectUtil.checkNotNull(resourceType, "resourceType");
        this.samplingInterval = samplingInterval;
    }

    public ResourceLeakTracker<T> track(T obj) {
        return this.track0(obj, false);
    }

    public ResourceLeakTracker<T> trackForcibly(T obj) {
        return this.track0(obj, true);
    }

    private DefaultResourceLeak<T> track0(T obj, boolean force) {
        Level level = ResourceLeakDetector.level;
        if (force || level == Level.PARANOID || level != Level.DISABLED && ThreadLocalRandom.current().nextInt(this.samplingInterval) == 0) {
            this.reportLeak();
            return new DefaultResourceLeak(obj, this.refQueue, this.allLeaks, this.getInitialHint(this.resourceType));
        }
        return null;
    }

    private void clearRefQueue() {
        DefaultResourceLeak ref;
        while ((ref = (DefaultResourceLeak)this.refQueue.poll()) != null) {
            ref.dispose();
        }
    }

    protected boolean needReport() {
        return logger.isErrorEnabled();
    }

    private void reportLeak() {
        DefaultResourceLeak ref;
        if (!this.needReport()) {
            this.clearRefQueue();
            return;
        }
        while ((ref = (DefaultResourceLeak)this.refQueue.poll()) != null) {
            LeakListener listener;
            String records;
            if (!ref.dispose() || !this.reportedLeaks.add(records = ref.getReportAndClearRecords())) continue;
            if (records.isEmpty()) {
                this.reportUntracedLeak(this.resourceType);
            } else {
                this.reportTracedLeak(this.resourceType, records);
            }
            if ((listener = this.leakListener) == null) continue;
            listener.onLeak(this.resourceType, records);
        }
    }

    protected void reportTracedLeak(String resourceType, String records) {
        logger.error("LEAK: {}.release() was not called before it's garbage-collected. See https://netty.io/wiki/reference-counted-objects.html for more information.{}", (Object)resourceType, (Object)records);
    }

    protected void reportUntracedLeak(String resourceType) {
        logger.error("LEAK: {}.release() was not called before it's garbage-collected. Enable advanced leak reporting to find out where the leak occurred. To enable advanced leak reporting, specify the JVM option '-D{}={}' or call {}.setLevel() See https://netty.io/wiki/reference-counted-objects.html for more information.", resourceType, "io.netty.leakDetection.level", Level.ADVANCED.name().toLowerCase(), StringUtil.simpleClassName(this));
    }

    protected Object getInitialHint(String resourceType) {
        return null;
    }

    public static void addExclusions(Class clz, String ... methodNames) {
        String[] newMethods;
        String[] oldMethods;
        Method method;
        HashSet<String> nameSet = new HashSet<String>(Arrays.asList(methodNames));
        Method[] methodArray = clz.getDeclaredMethods();
        int n = methodArray.length;
        for (int j = 0; !(j >= n || nameSet.remove((method = methodArray[j]).getName()) && nameSet.isEmpty()); ++j) {
        }
        if (!nameSet.isEmpty()) {
            throw new IllegalArgumentException("Can't find '" + nameSet + "' in " + clz.getName());
        }
        do {
            oldMethods = excludedMethods.get();
            newMethods = Arrays.copyOf(oldMethods, oldMethods.length + 2 * methodNames.length);
            for (int i2 = 0; i2 < methodNames.length; ++i2) {
                newMethods[oldMethods.length + i2 * 2] = clz.getName();
                newMethods[oldMethods.length + i2 * 2 + 1] = methodNames[i2];
            }
        } while (!excludedMethods.compareAndSet(oldMethods, newMethods));
    }

    static {
        boolean disabled;
        DEFAULT_LEVEL = Level.SIMPLE;
        logger = InternalLoggerFactory.getInstance(ResourceLeakDetector.class);
        if (SystemPropertyUtil.get("io.netty.noResourceLeakDetection") != null) {
            disabled = SystemPropertyUtil.getBoolean("io.netty.noResourceLeakDetection", false);
            logger.debug("-Dio.netty.noResourceLeakDetection: {}", (Object)disabled);
            logger.warn("-Dio.netty.noResourceLeakDetection is deprecated. Use '-D{}={}' instead.", (Object)"io.netty.leakDetection.level", (Object)Level.DISABLED.name().toLowerCase());
        } else {
            disabled = false;
        }
        Level defaultLevel = disabled ? Level.DISABLED : DEFAULT_LEVEL;
        String levelStr = SystemPropertyUtil.get("io.netty.leakDetectionLevel", defaultLevel.name());
        levelStr = SystemPropertyUtil.get("io.netty.leakDetection.level", levelStr);
        Level level = Level.parseLevel(levelStr);
        TARGET_RECORDS = SystemPropertyUtil.getInt("io.netty.leakDetection.targetRecords", 4);
        SAMPLING_INTERVAL = SystemPropertyUtil.getInt("io.netty.leakDetection.samplingInterval", 128);
        TRACK_CLOSE = SystemPropertyUtil.getBoolean("io.netty.leakDetection.trackClose", true);
        ResourceLeakDetector.level = level;
        if (logger.isDebugEnabled()) {
            logger.debug("-D{}: {}", (Object)"io.netty.leakDetection.level", (Object)level.name().toLowerCase());
            logger.debug("-D{}: {}", (Object)"io.netty.leakDetection.targetRecords", (Object)TARGET_RECORDS);
        }
        excludedMethods = new AtomicReference<String[]>(EmptyArrays.EMPTY_STRINGS);
    }

    private static class TraceRecord
    extends Throwable {
        private static final TraceRecord BOTTOM = new TraceRecord(false){

            @Override
            public Throwable fillInStackTrace() {
                return this;
            }
        };
        private final String hintString;
        private final TraceRecord next;
        private final int pos;

        TraceRecord(TraceRecord next2, Object hint) {
            this.hintString = hint instanceof ResourceLeakHint ? ((ResourceLeakHint)hint).toHintString() : hint.toString();
            this.next = next2;
            this.pos = next2.pos + 1;
        }

        TraceRecord(TraceRecord next2) {
            this.hintString = null;
            this.next = next2;
            this.pos = next2.pos + 1;
        }

        private TraceRecord(boolean closeMarker) {
            this.hintString = null;
            this.next = null;
            this.pos = closeMarker ? -2 : -1;
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder(2048);
            if (this.hintString != null) {
                buf.append("\tHint: ").append(this.hintString).append(StringUtil.NEWLINE);
            }
            StackTraceElement[] array = this.getStackTrace();
            block0: for (int i2 = 3; i2 < array.length; ++i2) {
                StackTraceElement element = array[i2];
                String[] exclusions = (String[])excludedMethods.get();
                for (int k = 0; k < exclusions.length; k += 2) {
                    if (exclusions[k].equals(element.getClassName()) && exclusions[k + 1].equals(element.getMethodName())) continue block0;
                }
                buf.append('\t');
                buf.append(element.toString());
                buf.append(StringUtil.NEWLINE);
            }
            return buf.toString();
        }
    }

    private static final class DefaultResourceLeak<T>
    extends WeakReference<Object>
    implements ResourceLeakTracker<T> {
        private static final AtomicReferenceFieldUpdater<DefaultResourceLeak<?>, TraceRecord> headUpdater = AtomicReferenceFieldUpdater.newUpdater(DefaultResourceLeak.class, TraceRecord.class, "head");
        private static final AtomicIntegerFieldUpdater<DefaultResourceLeak<?>> droppedRecordsUpdater = AtomicIntegerFieldUpdater.newUpdater(DefaultResourceLeak.class, "droppedRecords");
        private volatile TraceRecord head;
        private volatile int droppedRecords;
        private final Set<DefaultResourceLeak<?>> allLeaks;
        private final int trackedHash;

        DefaultResourceLeak(Object referent, ReferenceQueue<Object> refQueue, Set<DefaultResourceLeak<?>> allLeaks, Object initialHint) {
            super(referent, refQueue);
            assert (referent != null);
            this.allLeaks = allLeaks;
            this.trackedHash = System.identityHashCode(referent);
            allLeaks.add(this);
            headUpdater.set(this, initialHint == null ? new TraceRecord(TraceRecord.BOTTOM) : new TraceRecord(TraceRecord.BOTTOM, initialHint));
        }

        @Override
        public void record() {
            this.record0(null);
        }

        @Override
        public void record(Object hint) {
            this.record0(hint);
        }

        private void record0(Object hint) {
            if (TARGET_RECORDS > 0) {
                boolean dropped;
                TraceRecord prevHead;
                TraceRecord newHead;
                TraceRecord oldHead;
                do {
                    prevHead = oldHead = headUpdater.get(this);
                    if (oldHead == null || oldHead.pos == -2) {
                        return;
                    }
                    int numElements = oldHead.pos + 1;
                    if (numElements >= TARGET_RECORDS) {
                        int backOffFactor = Math.min(numElements - TARGET_RECORDS, 30);
                        boolean bl = dropped = ThreadLocalRandom.current().nextInt(1 << backOffFactor) != 0;
                        if (!dropped) continue;
                        prevHead = oldHead.next;
                        continue;
                    }
                    dropped = false;
                } while (!headUpdater.compareAndSet(this, oldHead, newHead = hint != null ? new TraceRecord(prevHead, hint) : new TraceRecord(prevHead)));
                if (dropped) {
                    droppedRecordsUpdater.incrementAndGet(this);
                }
            }
        }

        boolean dispose() {
            this.clear();
            return this.allLeaks.remove(this);
        }

        public boolean close() {
            if (this.allLeaks.remove(this)) {
                this.clear();
                headUpdater.set(this, TRACK_CLOSE ? new TraceRecord(true) : null);
                return true;
            }
            return false;
        }

        @Override
        public boolean close(T trackedObject) {
            assert (this.trackedHash == System.identityHashCode(trackedObject));
            try {
                boolean bl = this.close();
                return bl;
            }
            finally {
                DefaultResourceLeak.reachabilityFence0(trackedObject);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void reachabilityFence0(Object ref) {
            if (ref != null) {
                Object object = ref;
                synchronized (object) {
                }
            }
        }

        @Override
        @Nullable
        public Throwable getCloseStackTraceIfAny() {
            TraceRecord head = headUpdater.get(this);
            if (head != null && head.pos == -2) {
                return head;
            }
            return null;
        }

        public String toString() {
            TraceRecord oldHead = headUpdater.get(this);
            return this.generateReport(oldHead);
        }

        String getReportAndClearRecords() {
            TraceRecord oldHead = headUpdater.getAndSet(this, null);
            return this.generateReport(oldHead);
        }

        private String generateReport(TraceRecord oldHead) {
            if (oldHead == null) {
                return "";
            }
            int dropped = droppedRecordsUpdater.get(this);
            int duped = 0;
            int present = oldHead.pos + 1;
            StringBuilder buf = new StringBuilder(present * 2048).append(StringUtil.NEWLINE);
            buf.append("Recent access records: ").append(StringUtil.NEWLINE);
            int i2 = 1;
            HashSet<String> seen = new HashSet<String>(present);
            while (oldHead != TraceRecord.BOTTOM) {
                String s = oldHead.toString();
                if (seen.add(s)) {
                    if (oldHead.next == TraceRecord.BOTTOM) {
                        buf.append("Created at:").append(StringUtil.NEWLINE).append(s);
                    } else {
                        buf.append('#').append(i2++).append(':').append(StringUtil.NEWLINE).append(s);
                    }
                } else {
                    ++duped;
                }
                oldHead = oldHead.next;
            }
            if (duped > 0) {
                buf.append(": ").append(duped).append(" leak records were discarded because they were duplicates").append(StringUtil.NEWLINE);
            }
            if (dropped > 0) {
                buf.append(": ").append(dropped).append(" leak records were discarded because the leak record count is targeted to ").append(TARGET_RECORDS).append(". Use system property ").append("io.netty.leakDetection.targetRecords").append(" to increase the limit.").append(StringUtil.NEWLINE);
            }
            buf.setLength(buf.length() - StringUtil.NEWLINE.length());
            return buf.toString();
        }
    }

    public static interface LeakListener {
        public void onLeak(String var1, String var2);
    }

    public static final class Level
    extends Enum<Level> {
        public static final /* enum */ Level DISABLED = new Level();
        public static final /* enum */ Level SIMPLE = new Level();
        public static final /* enum */ Level ADVANCED = new Level();
        public static final /* enum */ Level PARANOID = new Level();
        private static final /* synthetic */ Level[] $VALUES;

        public static Level[] values() {
            return (Level[])$VALUES.clone();
        }

        static Level parseLevel(String levelStr) {
            String trimmedLevelStr = levelStr.trim();
            for (Level l : Level.values()) {
                if (!trimmedLevelStr.equalsIgnoreCase(l.name()) && !trimmedLevelStr.equals(String.valueOf(l.ordinal()))) continue;
                return l;
            }
            return DEFAULT_LEVEL;
        }

        static {
            $VALUES = new Level[]{DISABLED, SIMPLE, ADVANCED, PARANOID};
        }
    }
}

