/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.NetUtilInitializations;
import io.netty.util.internal.BoundedInputStream;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;

public final class NetUtil {
    public static final Inet4Address LOCALHOST4;
    public static final Inet6Address LOCALHOST6;
    public static final InetAddress LOCALHOST;
    public static final NetworkInterface LOOPBACK_IF;
    public static final Collection<NetworkInterface> NETWORK_INTERFACES;
    public static final int SOMAXCONN;
    private static final boolean IPV4_PREFERRED;
    private static final boolean IPV6_ADDRESSES_PREFERRED;
    private static final InternalLogger logger;

    /*
     * Exception decompiling
     */
    private static Integer sysctlGetInt(String sysctlKey) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[FORLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private NetUtil() {
    }

    static {
        IPV4_PREFERRED = SystemPropertyUtil.getBoolean("java.net.preferIPv4Stack", false);
        logger = InternalLoggerFactory.getInstance(NetUtil.class);
        String prefer = SystemPropertyUtil.get("java.net.preferIPv6Addresses", "false");
        IPV6_ADDRESSES_PREFERRED = "true".equalsIgnoreCase(prefer.trim());
        logger.debug("-Djava.net.preferIPv4Stack: {}", (Object)IPV4_PREFERRED);
        logger.debug("-Djava.net.preferIPv6Addresses: {}", (Object)prefer);
        NETWORK_INTERFACES = NetUtilInitializations.networkInterfaces();
        LOCALHOST4 = NetUtilInitializations.createLocalhost4();
        LOCALHOST6 = NetUtilInitializations.createLocalhost6();
        NetUtilInitializations.NetworkIfaceAndInetAddress loopback = NetUtilInitializations.determineLoopback(NETWORK_INTERFACES, LOCALHOST4, LOCALHOST6);
        LOOPBACK_IF = loopback.iface();
        LOCALHOST = loopback.address();
        SOMAXCONN = AccessController.doPrivileged(new SoMaxConnAction());
    }

    private static final class SoMaxConnAction
    implements PrivilegedAction<Integer> {
        private SoMaxConnAction() {
        }

        @Override
        public Integer run() {
            int somaxconn;
            block14: {
                somaxconn = PlatformDependent.isWindows() ? 200 : (PlatformDependent.isOsx() ? 128 : 4096);
                File file = new File("/proc/sys/net/core/somaxconn");
                try {
                    if (file.exists()) {
                        try (BufferedReader in = new BufferedReader(new InputStreamReader(new BoundedInputStream(new FileInputStream(file))));){
                            somaxconn = Integer.parseInt(in.readLine());
                            if (logger.isDebugEnabled()) {
                                logger.debug("{}: {}", (Object)file, (Object)somaxconn);
                            }
                            break block14;
                        }
                    }
                    Integer tmp = null;
                    if (SystemPropertyUtil.getBoolean("io.netty.net.somaxconn.trySysctl", false)) {
                        tmp = NetUtil.sysctlGetInt("kern.ipc.somaxconn");
                        if (tmp == null) {
                            tmp = NetUtil.sysctlGetInt("kern.ipc.soacceptqueue");
                            if (tmp != null) {
                                somaxconn = tmp;
                            }
                        } else {
                            somaxconn = tmp;
                        }
                    }
                    if (tmp == null) {
                        logger.debug("Failed to get SOMAXCONN from sysctl and file {}. Default: {}", (Object)file, (Object)somaxconn);
                    }
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block14;
                    logger.debug("Failed to get SOMAXCONN from sysctl and file {}. Default: {}", file, somaxconn, e);
                }
            }
            return somaxconn;
        }
    }
}

