/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.AsciiStringUtil;
import io.netty.util.HashingStrategy;
import io.netty.util.internal.MathUtil;
import io.netty.util.internal.PlatformDependent;

public final class AsciiString
implements CharSequence,
Comparable<CharSequence> {
    public static final AsciiString EMPTY_STRING = AsciiString.cached("");
    private final byte[] value;
    private final int offset;
    private final int length;
    private int hash;
    private String string;
    public static final HashingStrategy<CharSequence> CASE_INSENSITIVE_HASHER = new HashingStrategy<CharSequence>(){

        @Override
        public int hashCode(CharSequence o) {
            return AsciiString.hashCode(o);
        }

        @Override
        public boolean equals(CharSequence a, CharSequence b) {
            return AsciiString.contentEqualsIgnoreCase(a, b);
        }
    };
    public static final HashingStrategy<CharSequence> CASE_SENSITIVE_HASHER = new HashingStrategy<CharSequence>(){

        @Override
        public int hashCode(CharSequence o) {
            return AsciiString.hashCode(o);
        }

        @Override
        public boolean equals(CharSequence a, CharSequence b) {
            return AsciiString.contentEquals(a, b);
        }
    };

    public AsciiString(byte[] value2, int start2, int length, boolean copy2) {
        if (copy2) {
            byte[] rangedCopy = new byte[length];
            System.arraycopy(value2, start2, rangedCopy, 0, rangedCopy.length);
            this.value = rangedCopy;
            this.offset = 0;
        } else {
            if (MathUtil.isOutOfBounds(start2, length, value2.length)) {
                throw new IndexOutOfBoundsException("expected: 0 <= start(" + start2 + ") <= start + length(" + length + ") <= value.length(" + value2.length + ')');
            }
            this.value = value2;
            this.offset = start2;
        }
        this.length = length;
    }

    public AsciiString(CharSequence value2) {
        this(value2, 0, value2.length());
    }

    public AsciiString(CharSequence value2, int start2, int length) {
        if (MathUtil.isOutOfBounds(start2, length, value2.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start2 + ") <= start + length(" + length + ") <= value.length(" + value2.length() + ')');
        }
        this.value = PlatformDependent.allocateUninitializedArray(length);
        int i2 = 0;
        int j = start2;
        while (i2 < length) {
            this.value[i2] = AsciiString.c2b(value2.charAt(j));
            ++i2;
            ++j;
        }
        this.offset = 0;
        this.length = length;
    }

    public byte byteAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException("index: " + index + " must be in the range [0," + this.length + ")");
        }
        if (PlatformDependent.hasUnsafe()) {
            return PlatformDependent.getByte(this.value, index + this.offset);
        }
        return this.value[index + this.offset];
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public int length() {
        return this.length;
    }

    public byte[] array() {
        return this.value;
    }

    public int arrayOffset() {
        return this.offset;
    }

    @Override
    public char charAt(int index) {
        return AsciiString.b2c(this.byteAt(index));
    }

    @Override
    public int compareTo(CharSequence string) {
        if (this == string) {
            return 0;
        }
        int length1 = this.length();
        int length2 = string.length();
        int minLength = Math.min(length1, length2);
        int i2 = 0;
        int j = this.arrayOffset();
        while (i2 < minLength) {
            int result2 = AsciiString.b2c(this.value[j]) - string.charAt(i2);
            if (result2 != 0) {
                return result2;
            }
            ++i2;
            ++j;
        }
        return length1 - length2;
    }

    public boolean contentEqualsIgnoreCase(CharSequence string) {
        if (this == string) {
            return true;
        }
        if (string == null || string.length() != this.length()) {
            return false;
        }
        if (string instanceof AsciiString) {
            AsciiString other = (AsciiString)string;
            byte[] value2 = this.value;
            if (this.offset == 0 && other.offset == 0 && this.length == value2.length) {
                byte[] otherValue = other.value;
                for (int i2 = 0; i2 < value2.length; ++i2) {
                    if (AsciiString.equalsIgnoreCase(value2[i2], otherValue[i2])) continue;
                    return false;
                }
                return true;
            }
            return this.misalignedEqualsIgnoreCase(other);
        }
        byte[] value3 = this.value;
        int i3 = this.offset;
        for (int j = 0; j < string.length(); ++j) {
            if (!AsciiString.equalsIgnoreCase(AsciiString.b2c(value3[i3]), string.charAt(j))) {
                return false;
            }
            ++i3;
        }
        return true;
    }

    private boolean misalignedEqualsIgnoreCase(AsciiString other) {
        byte[] value2 = this.value;
        byte[] otherValue = other.value;
        int i2 = this.offset;
        int j = other.offset;
        int end = this.offset + this.length;
        while (i2 < end) {
            if (!AsciiString.equalsIgnoreCase(value2[i2], otherValue[j])) {
                return false;
            }
            ++i2;
            ++j;
        }
        return true;
    }

    @Override
    public AsciiString subSequence(int start2, int end) {
        return this.subSequence(start2, end, true);
    }

    public AsciiString subSequence(int start2, int end, boolean copy2) {
        if (MathUtil.isOutOfBounds(start2, end - start2, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start2 + ") <= end (" + end + ") <= length(" + this.length() + ')');
        }
        if (start2 == 0 && end == this.length()) {
            return this;
        }
        if (end == start2) {
            return EMPTY_STRING;
        }
        return new AsciiString(this.value, start2 + this.offset, end - start2, copy2);
    }

    public int indexOf(char ch, int start2) {
        if (ch > '\u00ff') {
            return -1;
        }
        if (start2 < 0) {
            start2 = 0;
        }
        byte chAsByte = AsciiString.c2b0(ch);
        int len = this.offset + this.length;
        for (int i2 = start2 + this.offset; i2 < len; ++i2) {
            if (this.value[i2] != chAsByte) continue;
            return i2 - this.offset;
        }
        return -1;
    }

    public static CharSequence trim(CharSequence c) {
        int start2;
        int last;
        if (c instanceof AsciiString) {
            return ((AsciiString)c).trim();
        }
        if (c instanceof String) {
            return ((String)c).trim();
        }
        int end = last = c.length() - 1;
        for (start2 = 0; start2 <= end && c.charAt(start2) <= ' '; ++start2) {
        }
        while (end >= start2 && c.charAt(end) <= ' ') {
            --end;
        }
        if (start2 == 0 && end == last) {
            return c;
        }
        return c.subSequence(start2, end);
    }

    public AsciiString trim() {
        int start2;
        int last;
        int end = last = this.arrayOffset() + this.length() - 1;
        for (start2 = this.arrayOffset(); start2 <= end && this.value[start2] <= 32; ++start2) {
        }
        while (end >= start2 && this.value[end] <= 32) {
            --end;
        }
        if (start2 == 0 && end == last) {
            return this;
        }
        return new AsciiString(this.value, start2, end - start2 + 1, false);
    }

    public boolean contentEquals(CharSequence a) {
        if (this == a) {
            return true;
        }
        if (a == null || a.length() != this.length()) {
            return false;
        }
        if (a instanceof AsciiString) {
            return this.equals(a);
        }
        int i2 = this.arrayOffset();
        for (int j = 0; j < a.length(); ++j) {
            if (AsciiString.b2c(this.value[i2]) != a.charAt(j)) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            this.hash = h = PlatformDependent.hashCodeAscii(this.value, this.offset, this.length);
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != AsciiString.class) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        AsciiString other = (AsciiString)obj;
        return this.length() == other.length() && this.hashCode() == other.hashCode() && PlatformDependent.equals(this.array(), this.arrayOffset(), other.array(), other.arrayOffset(), this.length());
    }

    @Override
    public String toString() {
        String cache2 = this.string;
        if (cache2 == null) {
            this.string = cache2 = this.toString(0);
        }
        return cache2;
    }

    public String toString(int start2) {
        return this.toString(start2, this.length());
    }

    public String toString(int start2, int end) {
        int length = end - start2;
        if (length == 0) {
            return "";
        }
        if (MathUtil.isOutOfBounds(start2, length, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start2 + ") <= srcIdx + length(" + length + ") <= srcLen(" + this.length() + ')');
        }
        String str = new String(this.value, 0, start2 + this.offset, length);
        return str;
    }

    public static AsciiString of(CharSequence string) {
        return string instanceof AsciiString ? (AsciiString)string : new AsciiString(string);
    }

    public static AsciiString cached(String string) {
        AsciiString asciiString = new AsciiString(string);
        asciiString.string = string;
        return asciiString;
    }

    public static int hashCode(CharSequence value2) {
        if (value2 == null) {
            return 0;
        }
        if (value2 instanceof AsciiString) {
            return value2.hashCode();
        }
        return PlatformDependent.hashCodeAscii(value2);
    }

    public static boolean contentEqualsIgnoreCase(CharSequence a, CharSequence b) {
        if (a == null || b == null) {
            return a == b;
        }
        if (a instanceof AsciiString) {
            return ((AsciiString)a).contentEqualsIgnoreCase(b);
        }
        if (b instanceof AsciiString) {
            return ((AsciiString)b).contentEqualsIgnoreCase(a);
        }
        if (a.length() != b.length()) {
            return false;
        }
        for (int i2 = 0; i2 < a.length(); ++i2) {
            if (AsciiString.equalsIgnoreCase(a.charAt(i2), b.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean contentEquals(CharSequence a, CharSequence b) {
        if (a == null || b == null) {
            return a == b;
        }
        if (a instanceof AsciiString) {
            return ((AsciiString)a).contentEquals(b);
        }
        if (b instanceof AsciiString) {
            return ((AsciiString)b).contentEquals(a);
        }
        if (a.length() != b.length()) {
            return false;
        }
        for (int i2 = 0; i2 < a.length(); ++i2) {
            if (a.charAt(i2) == b.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    public static int indexOf(CharSequence cs, char searchChar, int start2) {
        int i2;
        if (cs instanceof String) {
            return ((String)cs).indexOf(searchChar, start2);
        }
        if (cs instanceof AsciiString) {
            return ((AsciiString)cs).indexOf(searchChar, start2);
        }
        if (cs == null) {
            return -1;
        }
        int sz = cs.length();
        int n = i2 = start2 < 0 ? 0 : start2;
        while (i2 < sz) {
            if (cs.charAt(i2) == searchChar) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    private static boolean equalsIgnoreCase(byte a, byte b) {
        return a == b || AsciiStringUtil.toLowerCase(a) == AsciiStringUtil.toLowerCase(b);
    }

    private static boolean equalsIgnoreCase(char a, char b) {
        return a == b || AsciiString.toLowerCase(a) == AsciiString.toLowerCase(b);
    }

    public static char toLowerCase(char c) {
        return AsciiString.isUpperCase(c) ? (char)(c + 32) : c;
    }

    public static boolean isUpperCase(char value2) {
        return value2 >= 'A' && value2 <= 'Z';
    }

    public static byte c2b(char c) {
        return (byte)(c > '\u00ff' ? 63 : (int)c);
    }

    private static byte c2b0(char c) {
        return (byte)c;
    }

    public static char b2c(byte b) {
        return (char)(b & 0xFF);
    }
}

