/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.util.internal.ObjectUtil;

public final class WebSocketCloseStatus
implements Comparable<WebSocketCloseStatus> {
    public static final WebSocketCloseStatus NORMAL_CLOSURE = new WebSocketCloseStatus(1000, "Bye");
    public static final WebSocketCloseStatus ENDPOINT_UNAVAILABLE = new WebSocketCloseStatus(1001, "Endpoint unavailable");
    public static final WebSocketCloseStatus PROTOCOL_ERROR = new WebSocketCloseStatus(1002, "Protocol error");
    public static final WebSocketCloseStatus INVALID_MESSAGE_TYPE = new WebSocketCloseStatus(1003, "Invalid message type");
    public static final WebSocketCloseStatus INVALID_PAYLOAD_DATA = new WebSocketCloseStatus(1007, "Invalid payload data");
    public static final WebSocketCloseStatus POLICY_VIOLATION = new WebSocketCloseStatus(1008, "Policy violation");
    public static final WebSocketCloseStatus MESSAGE_TOO_BIG = new WebSocketCloseStatus(1009, "Message too big");
    public static final WebSocketCloseStatus MANDATORY_EXTENSION = new WebSocketCloseStatus(1010, "Mandatory extension");
    public static final WebSocketCloseStatus INTERNAL_SERVER_ERROR = new WebSocketCloseStatus(1011, "Internal server error");
    public static final WebSocketCloseStatus SERVICE_RESTART = new WebSocketCloseStatus(1012, "Service Restart");
    public static final WebSocketCloseStatus TRY_AGAIN_LATER = new WebSocketCloseStatus(1013, "Try Again Later");
    public static final WebSocketCloseStatus BAD_GATEWAY = new WebSocketCloseStatus(1014, "Bad Gateway");
    public static final WebSocketCloseStatus EMPTY = new WebSocketCloseStatus(1005, "Empty", false);
    public static final WebSocketCloseStatus ABNORMAL_CLOSURE = new WebSocketCloseStatus(1006, "Abnormal closure", false);
    public static final WebSocketCloseStatus TLS_HANDSHAKE_FAILED = new WebSocketCloseStatus(1015, "TLS handshake failed", false);
    private final int statusCode;
    private final String reasonText;
    private String text;

    public WebSocketCloseStatus(int statusCode, String reasonText) {
        this(statusCode, reasonText, true);
    }

    public WebSocketCloseStatus(int statusCode, String reasonText, boolean validate2) {
        if (validate2 && !WebSocketCloseStatus.isValidStatusCode(statusCode)) {
            throw new IllegalArgumentException("WebSocket close status code does NOT comply with RFC-6455: " + statusCode);
        }
        this.statusCode = statusCode;
        this.reasonText = ObjectUtil.checkNotNull(reasonText, "reasonText");
    }

    public int code() {
        return this.statusCode;
    }

    public String reasonText() {
        return this.reasonText;
    }

    @Override
    public int compareTo(WebSocketCloseStatus o) {
        return this.code() - o.code();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o || this.getClass() != o.getClass()) {
            return false;
        }
        WebSocketCloseStatus that = (WebSocketCloseStatus)o;
        return this.statusCode == that.statusCode;
    }

    public int hashCode() {
        return this.statusCode;
    }

    public String toString() {
        String text2 = this.text;
        if (text2 == null) {
            this.text = text2 = this.code() + " " + this.reasonText();
        }
        return text2;
    }

    public static boolean isValidStatusCode(int code) {
        return code < 0 || 1000 <= code && code <= 1003 || 1007 <= code && code <= 1014 || 3000 <= code;
    }
}

